<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class House extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'name',
        'capacity',
        'age_days',
        'timezone',
        'notes',
        'telegram_chat_id',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function devices()
    {
        return $this->hasMany(Device::class);
    }

    public function weightSamples()
    {
        return $this->hasMany(WeightSample::class);
    }

    public function behaviorMetrics()
    {
        return $this->hasMany(BehaviorMetric::class);
    }

    public function alerts()
    {
        return $this->hasMany(Alert::class);
    }

    public function feedLogs()
    {
        return $this->hasMany(FeedLog::class);
    }

    public function waterLogs()
    {
        return $this->hasMany(WaterLog::class);
    }

    public function mortalityLogs()
    {
        return $this->hasMany(MortalityLog::class);
    }

    public function medicationLogs()
    {
        return $this->hasMany(MedicationLog::class);
    }

    public function camFrames()
    {
        return $this->hasMany(CamFrame::class);
    }
}
