<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class ImportBatch extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'created_by',
        'status',
        'file_path',
        'file_type',
        'import_type',
        'summary',
        'ai_summary',
        'processed_at',
    ];

    protected $casts = [
        'summary' => 'array',
        'processed_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function rows()
    {
        return $this->hasMany(ImportRow::class, 'batch_id');
    }
}
