<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class ImportRow extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'batch_id',
        'raw',
        'mapped',
        'status',
        'error_message',
    ];

    protected $casts = [
        'raw' => 'array',
        'mapped' => 'array',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function batch()
    {
        return $this->belongsTo(ImportBatch::class, 'batch_id');
    }
}
