<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class Maintenance extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'scheduled_date',
        'completed_date',
        'status',
        'description',
        'notes',
        'usage_hours',
        'meter_reading',
    ];

    protected $casts = [
        'scheduled_date' => 'date',
        'completed_date' => 'date',
        'usage_hours' => 'float',
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function scopeUpcoming($query)
    {
        return $query->where('scheduled_date', '>', now());
    }

    public function scopeCompleted($query)
    {
        return $query->whereNotNull('completed_date');
    }

    public function scopePending($query)
    {
        return $query->whereNull('completed_date')->where('status', 'pending');
    }
}
