<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaintenanceCashflowLine extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'period_type',
        'period_label',
        'period_start',
        'period_end',
        'category',
        'amount_usd',
        'notes',
        'source',
    ];

    protected $casts = [
        'period_start' => 'date',
        'period_end' => 'date',
        'amount_usd' => 'float',
    ];
}
