<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MaintenanceWeeklyRepair extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'week',
        'priority',
        'asset_ref',
        'category',
        'scope',
        'original_usd',
        'original_zar',
        'fx_rate',
        'additionals_usd',
        'planned_total_usd',
        'source',
    ];

    protected $casts = [
        'priority' => 'integer',
        'original_usd' => 'float',
        'original_zar' => 'float',
        'fx_rate' => 'float',
        'additionals_usd' => 'float',
        'planned_total_usd' => 'float',
    ];
}
