<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MedicationLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'house_id',
        'date',
        'drug',
        'dosage',
        'reason',
        'withdrawal_days',
        'note',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function house()
    {
        return $this->belongsTo(House::class);
    }
}
