<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotificationOutbox extends Model
{
    use HasFactory, BelongsToTenant;

    protected $table = 'notification_outbox';

    protected $fillable = [
        'tenant_id',
        'channel',
        'severity',
        'title',
        'message',
        'recipients',
        'status',
        'dedupe_key',
        'available_at',
        'sent_at',
        'failed_at',
        'error_message',
    ];

    protected $casts = [
        'recipients' => 'array',
        'available_at' => 'datetime',
        'sent_at' => 'datetime',
        'failed_at' => 'datetime',
    ];
}
