<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class NotificationRoute extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'event_type',
        'channel_order',
        'recipients',
        'quiet_hours',
        'escalation_minutes',
    ];

    protected $casts = [
        'channel_order' => 'array',
        'recipients' => 'array',
        'quiet_hours' => 'array',
        'escalation_minutes' => 'integer',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }
}
