<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class Part extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'sku',
        'name',
        'category',
        'stage_of_use',
        'replacement_frequency',
        'estimated_replacements_per_year',
        'cost_per_year',
        'unit',
        'description',
    ];

    protected $casts = [
        'estimated_replacements_per_year' => 'float',
        'cost_per_year' => 'float',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function inventoryItems()
    {
        return $this->hasMany(InventoryItem::class);
    }

    public function assetLinks()
    {
        return $this->hasMany(AssetSpare::class);
    }

    public function quotes()
    {
        return $this->hasMany(VendorQuote::class);
    }
}
