<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class PmSchedule extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'name',
        'schedule_type',
        'interval_value',
        'interval_unit',
        'meter_type',
        'last_meter_reading',
        'next_meter_reading',
        'last_service_at',
        'next_due_at',
        'active',
    ];

    protected $casts = [
        'last_meter_reading' => 'float',
        'next_meter_reading' => 'float',
        'last_service_at' => 'date',
        'next_due_at' => 'date',
        'active' => 'boolean',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }
}
