<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseOrder extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'purchase_request_id',
        'vendor_id',
        'po_number',
        'vendor_name',
        'status',
        'terms',
        'delivery_location',
        'total_estimated_cost',
        'currency',
        'created_by',
        'sent_at',
    ];

    protected $casts = [
        'total_estimated_cost' => 'decimal:2',
        'sent_at' => 'datetime',
    ];

    public function request()
    {
        return $this->belongsTo(PurchaseRequest::class, 'purchase_request_id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function items()
    {
        return $this->hasMany(PurchaseOrderItem::class);
    }
}
