<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseRequest extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'site_id',
        'request_code',
        'title',
        'department',
        'cost_center',
        'status',
        'priority',
        'requested_by',
        'needed_by',
        'submitted_at',
        'approved_at',
        'last_reminded_at',
        'total_estimated_cost',
        'currency',
        'notes',
        'source_file',
    ];

    protected $casts = [
        'needed_by' => 'date',
        'total_estimated_cost' => 'decimal:2',
        'submitted_at' => 'datetime',
        'approved_at' => 'datetime',
        'last_reminded_at' => 'datetime',
    ];

    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    public function items()
    {
        return $this->hasMany(PurchaseRequestItem::class);
    }

    public function approvals()
    {
        return $this->hasMany(PurchaseRequestApproval::class);
    }

    public function requestedBy()
    {
        return $this->belongsTo(User::class, 'requested_by');
    }
}
