<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PurchaseRequestItem extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'purchase_request_id',
        'part_id',
        'sku',
        'line_number',
        'item_name',
        'description',
        'quantity',
        'unit',
        'est_unit_cost',
        'purpose_cost_center',
        'date_initiated',
        'supplier_name',
        'quote_number',
        'quote_amount_usd',
        'quote_amount_zwl',
        'preferred_vendor',
        'selected_supplier',
        'comments',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'est_unit_cost' => 'decimal:2',
        'quote_amount_usd' => 'decimal:2',
        'quote_amount_zwl' => 'decimal:2',
        'date_initiated' => 'date',
    ];

    public function request()
    {
        return $this->belongsTo(PurchaseRequest::class, 'purchase_request_id');
    }

    public function documents()
    {
        return $this->hasMany(PurchaseRequestItemDocument::class, 'purchase_request_item_id');
    }

    public function part()
    {
        return $this->belongsTo(Part::class);
    }
}
