<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReconciliationLink extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'source_type',
        'source_id',
        'target_type',
        'target_id',
        'confidence',
        'status',
        'reason',
        'meta_json',
        'applied_by',
        'applied_at',
        'notified_at',
        'notified_channel',
    ];

    protected $casts = [
        'confidence' => 'float',
        'meta_json' => 'array',
        'applied_at' => 'datetime',
        'notified_at' => 'datetime',
    ];
}
