<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class SensorEventRaw extends Model
{
    use HasFactory, BelongsToTenant;

    protected $table = 'sensor_events_raw';

    protected $fillable = [
        'tenant_id',
        'device_id',
        'payload',
        'occurred_at',
    ];

    protected $casts = [
        'payload' => 'array',
        'occurred_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function device()
    {
        return $this->belongsTo(Device::class);
    }
}
