<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SensorReading extends Model
{
    use HasFactory;

    protected $fillable = [
        'sensor_id',
        'ts',
        'value',
        'meta_json',
    ];

    protected $casts = [
        'ts' => 'datetime',
        'meta_json' => 'array',
    ];

    public function sensor()
    {
        return $this->belongsTo(Sensor::class);
    }
}
