<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TelegramEvent extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'site_id',
        'asset_id',
        'work_order_id',
        'event_code',
        'event_type',
        'severity',
        'title',
        'message',
        'payload',
        'status',
        'acked_by',
        'acked_at',
        'snoozed_until',
        'escalation_level',
        'last_escalated_at',
        'dedupe_key',
    ];

    protected $casts = [
        'payload' => 'array',
        'acked_at' => 'datetime',
        'snoozed_until' => 'datetime',
        'last_escalated_at' => 'datetime',
    ];

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function workOrder()
    {
        return $this->belongsTo(WorkOrder::class);
    }
}
