<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TelegramEventMessage extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'telegram_event_id',
        'chat_id',
        'message_id',
        'status',
    ];

    public function event()
    {
        return $this->belongsTo(TelegramEvent::class, 'telegram_event_id');
    }
}
