<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tenant extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'email',
        'password',
        'subdomain',
        'database_name',
        'subscription_plan',
        'status',
    ];

    protected $hidden = [
        'password',
    ];

    public function assets()
    {
        return $this->hasMany(Asset::class);
    }

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function vehicles()
    {
        return $this->hasMany(Vehicle::class);
    }

    public function sites()
    {
        return $this->hasMany(Site::class);
    }

    public function workOrders()
    {
        return $this->hasMany(WorkOrder::class);
    }

    public function fuelLogs()
    {
        return $this->hasMany(FuelLog::class);
    }

    public function devices()
    {
        return $this->hasMany(Device::class);
    }

    public function alarms()
    {
        return $this->hasMany(Alarm::class);
    }

    public function importBatches()
    {
        return $this->hasMany(ImportBatch::class);
    }

    public function auditLogs()
    {
        return $this->hasMany(AuditLog::class);
    }

    public function maintenanceRecords()
    {
        return $this->hasMany(Maintenance::class);
    }

    public function trips()
    {
        return $this->hasMany(Trip::class);
    }

    public function isActive()
    {
        return $this->status === 'active';
    }
}
