<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class Tyre extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'position',
        'serial_number',
        'brand',
        'model',
        'tread_depth',
        'status',
        'installed_at',
        'removed_at',
        'failure_reason',
        'notes',
    ];

    protected $casts = [
        'tread_depth' => 'float',
        'installed_at' => 'datetime',
        'removed_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function rotations()
    {
        return $this->hasMany(TyreRotation::class);
    }
}
