<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class TyreRotation extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'tyre_id',
        'asset_id',
        'from_position',
        'to_position',
        'rotated_at',
        'notes',
    ];

    protected $casts = [
        'rotated_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function tyre()
    {
        return $this->belongsTo(Tyre::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }
}
