<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class Vehicle extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'asset_id',
        'site_id',
        'name',
        'type',
        'license_plate',
        'status',
        'telemetry_data',
        'maintenance_schedule',
        'odometer',
        'engine_hours',
    ];

    protected $casts = [
        'telemetry_data' => 'array',
        'maintenance_schedule' => 'array',
        'odometer' => 'float',
        'engine_hours' => 'float',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    public function maintenanceRecords()
    {
        return $this->hasMany(Maintenance::class);
    }

    public function trips()
    {
        return $this->hasMany(Trip::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    public function ingestTelemetryData(array $data)
    {
        // Logic to process and store telemetry data
    }

    public function scheduleMaintenance($date, $details)
    {
        // Logic to create a maintenance record
    }
}
