<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Concerns\BelongsToTenant;

class VendorQuote extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'vendor_id',
        'part_id',
        'price',
        'currency',
        'lead_time_days',
        'valid_until',
    ];

    protected $casts = [
        'price' => 'float',
        'lead_time_days' => 'integer',
        'valid_until' => 'date',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function part()
    {
        return $this->belongsTo(Part::class);
    }
}
