<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WaterLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'house_id',
        'date',
        'water_l',
        'note',
    ];

    protected $casts = [
        'date' => 'date',
    ];

    public function house()
    {
        return $this->belongsTo(House::class);
    }
}
