<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WeeklyReport extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'report_week',
        'period_start',
        'period_end',
        'generated_at',
        'pdf_path',
        'summary_json',
        'status',
    ];

    protected $casts = [
        'period_start' => 'datetime',
        'period_end' => 'datetime',
        'generated_at' => 'datetime',
        'summary_json' => 'array',
    ];

    public function sections()
    {
        return $this->hasMany(WeeklyReportSection::class);
    }
}
