<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WeeklyReportSection extends Model
{
    use HasFactory;

    protected $fillable = [
        'weekly_report_id',
        'section_code',
        'title',
        'content_json',
    ];

    protected $casts = [
        'content_json' => 'array',
    ];

    public function report()
    {
        return $this->belongsTo(WeeklyReport::class, 'weekly_report_id');
    }
}
