<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WeightSample extends Model
{
    use HasFactory;

    protected $fillable = [
        'house_id',
        'source_device_id',
        'ts',
        'avg_weight_g',
        'sample_count',
        'meta_json',
    ];

    protected $casts = [
        'ts' => 'datetime',
        'meta_json' => 'array',
    ];

    public function house()
    {
        return $this->belongsTo(House::class);
    }

    public function device()
    {
        return $this->belongsTo(Device::class, 'source_device_id');
    }
}
