<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Concerns\BelongsToTenant;

class WorkOrder extends Model
{
    use HasFactory, SoftDeletes, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'reference_code',
        'source',
        'asset_id',
        'checklist_id',
        'alarm_id',
        'reported_by',
        'assigned_to',
        'downtime_reason_id',
        'type',
        'status',
        'priority',
        'description',
        'cause',
        'resolution',
        'meter_reading',
        'due_at',
        'started_at',
        'accepted_at',
        'completed_at',
        'progress_percent',
        'auto_generated',
        'total_cost',
        'estimated_cost',
        'requires_approval',
        'approval_status',
        'approved_by',
        'approved_at',
        'planned_start',
        'last_reminded_at',
    ];

    protected $casts = [
        'meter_reading' => 'float',
        'auto_generated' => 'boolean',
        'total_cost' => 'float',
        'estimated_cost' => 'float',
        'progress_percent' => 'float',
        'requires_approval' => 'boolean',
        'due_at' => 'datetime',
        'started_at' => 'datetime',
        'accepted_at' => 'datetime',
        'completed_at' => 'datetime',
        'approved_at' => 'datetime',
        'planned_start' => 'datetime',
        'last_reminded_at' => 'datetime',
    ];

    public function tenant()
    {
        return $this->belongsTo(Tenant::class);
    }

    public function asset()
    {
        return $this->belongsTo(Asset::class);
    }

    public function checklist()
    {
        return $this->belongsTo(Checklist::class);
    }

    public function reportedBy()
    {
        return $this->belongsTo(User::class, 'reported_by');
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function downtimeReason()
    {
        return $this->belongsTo(DowntimeReasonCode::class, 'downtime_reason_id');
    }

    public function costs()
    {
        return $this->hasMany(WorkOrderCost::class);
    }

    public function parts()
    {
        return $this->hasMany(WorkOrderPart::class);
    }

    public function notes()
    {
        return $this->hasMany(WorkOrderNote::class);
    }

    public function documents()
    {
        return $this->hasMany(WorkOrderDocument::class);
    }

    public function alarm()
    {
        return $this->belongsTo(Alarm::class, 'alarm_id');
    }
}
