<?php

namespace App\Models;

use App\Models\Concerns\BelongsToTenant;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkOrderDocument extends Model
{
    use HasFactory, BelongsToTenant;

    protected $fillable = [
        'tenant_id',
        'work_order_id',
        'storage_path',
        'original_name',
        'uploaded_by',
        'source',
    ];

    public function workOrder()
    {
        return $this->belongsTo(WorkOrder::class);
    }
}
