<?php

namespace App\Observers;

use App\Jobs\RunOpsNotifierComplianceScan;
use App\Models\ComplianceRecord;

class ComplianceRecordObserver
{
    public function created(ComplianceRecord $record): void
    {
        RunOpsNotifierComplianceScan::dispatch($record->tenant_id);
    }

    public function updated(ComplianceRecord $record): void
    {
        RunOpsNotifierComplianceScan::dispatch($record->tenant_id);
    }
}
