<?php

namespace App\Observers;

use App\Jobs\RunCostControlAgent;
use App\Models\FuelLog;

class FuelLogObserver
{
    public function created(FuelLog $log): void
    {
        RunCostControlAgent::dispatch($log->tenant_id, 'fuel_log', $log->id);
    }

    public function updated(FuelLog $log): void
    {
        RunCostControlAgent::dispatch($log->tenant_id, 'fuel_log', $log->id);
    }
}
