<?php

namespace App\Observers;

use App\Jobs\RunCostControlAgent;
use App\Models\WorkOrderCost;

class WorkOrderCostObserver
{
    public function created(WorkOrderCost $cost): void
    {
        RunCostControlAgent::dispatch($cost->tenant_id, 'work_order_cost', $cost->id);
    }

    public function updated(WorkOrderCost $cost): void
    {
        RunCostControlAgent::dispatch($cost->tenant_id, 'work_order_cost', $cost->id);
    }
}
