<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\ComplianceRecord;
use App\Models\FuelLog;
use App\Models\WorkOrderCost;
use App\Observers\ComplianceRecordObserver;
use App\Observers\FuelLogObserver;
use App\Observers\WorkOrderCostObserver;

class AppServiceProvider extends ServiceProvider
{
    public function register()
    {
        //
    }

    public function boot()
    {
        ComplianceRecord::observe(ComplianceRecordObserver::class);
        FuelLog::observe(FuelLogObserver::class);
        WorkOrderCost::observe(WorkOrderCostObserver::class);
    }
}
