<?php

namespace App\Services;

use App\Models\NotificationLog;
use App\Models\NotificationRoute;

class NotificationService
{
    public function dispatchEvent(int $tenantId, string $eventType, array $payload): void
    {
        $routes = NotificationRoute::query()
            ->where('tenant_id', $tenantId)
            ->where('event_type', $eventType)
            ->get();

        foreach ($routes as $route) {
            $channels = $route->channel_order ?? [];
            $recipients = $route->recipients ?? [];

            foreach ($channels as $channel) {
                foreach ($recipients as $recipient) {
                    NotificationLog::create([
                        'tenant_id' => $tenantId,
                        'channel' => $channel,
                        'recipient' => $recipient,
                        'payload' => $payload,
                        'status' => 'queued',
                    ]);
                }
            }
        }
    }
}
