<?php

namespace App\Services\Notify;

use App\Jobs\SendTelegramMessage;
use App\Models\Alert;

class TelegramNotifier
{
    public function sendMessage(string $chatId, string $text): void
    {
        SendTelegramMessage::dispatch($chatId, $text);
    }

    public function sendAlert(Alert $alert): void
    {
        $chatId = $alert->house?->telegram_chat_id ?: env('TELEGRAM_DEFAULT_CHAT_ID');
        if (!$chatId) {
            return;
        }

        $lines = [
            'PoultryOps Alert (' . strtoupper($alert->severity) . ')',
            $alert->title,
            $alert->message,
        ];

        if (!empty($alert->suggested_actions_json)) {
            $lines[] = 'Actions: ' . implode('; ', $alert->suggested_actions_json);
        }

        $this->sendMessage($chatId, implode("\n", array_filter($lines)));
    }
}
