<?php

namespace App\Services;

use App\Models\AlarmRule;
use Illuminate\Support\Carbon;

class RulesEngineService
{
    public function evaluateMetric(int $tenantId, int $assetId, string $metric, float $value, ?Carbon $occurredAt = null): void
    {
        $rules = AlarmRule::query()
            ->where('tenant_id', $tenantId)
            ->where('metric', $metric)
            ->where('enabled', true)
            ->get();

        foreach ($rules as $rule) {
            if ($this->matchesRule($rule->comparison, $value, $rule->threshold)) {
                app(AlarmService::class)->trigger($rule, [
                    'asset_id' => $assetId,
                    'value' => $value,
                    'metric' => $metric,
                    'occurred_at' => $occurredAt,
                ]);
            }
        }
    }

    protected function matchesRule(?string $comparison, float $value, ?float $threshold): bool
    {
        if ($threshold === null) {
            return false;
        }

        return match ($comparison) {
            '>=' => $value >= $threshold,
            '>' => $value > $threshold,
            '<=' => $value <= $threshold,
            '<' => $value < $threshold,
            '=' => $value == $threshold,
            default => false,
        };
    }
}
