<?php

namespace App\Services;

use App\Jobs\NormalizeSensorEvent;
use App\Models\Device;
use App\Models\SensorEventRaw;
use Illuminate\Support\Carbon;

class SensorIngestionService
{
    public function ingest(array $payload, ?int $tenantId, ?int $deviceId = null, ?string $identifier = null): SensorEventRaw
    {
        $device = $deviceId ? Device::find($deviceId) : null;

        if (!$device && $identifier) {
            $device = Device::where('identifier', $identifier)
                ->where('tenant_id', $tenantId)
                ->first();
        }

        if (!$device) {
            $device = Device::create([
                'tenant_id' => $tenantId,
                'name' => $payload['device_name'] ?? $identifier,
                'type' => $payload['device_type'] ?? null,
                'identifier' => $identifier,
                'meta' => $payload['device_meta'] ?? null,
            ]);
        }

        $event = SensorEventRaw::create([
            'tenant_id' => $tenantId,
            'device_id' => $device->id,
            'payload' => $payload,
            'occurred_at' => Carbon::parse($payload['timestamp'] ?? now()),
        ]);

        NormalizeSensorEvent::dispatch($event->id);

        return $event;
    }
}
