<?php

namespace App\Services;

use App\Models\TelegramEvent;

class TelegramEventEscalationService
{
    public function __construct(private TelegramEventDispatcher $dispatcher)
    {
    }

    public function run(): void
    {
        $events = TelegramEvent::where('status', 'open')
            ->where(function ($query) {
                $query->whereNull('snoozed_until')
                    ->orWhere('snoozed_until', '<', now());
            })
            ->orderBy('created_at')
            ->limit(200)
            ->get();

        foreach ($events as $event) {
            $rules = config('telegram_events.escalation.' . $event->event_type, []);
            if (!$rules) {
                continue;
            }

            $minutesOpen = $event->created_at ? now()->diffInMinutes($event->created_at) : 0;
            $level = (int) ($event->escalation_level ?? 0);

            foreach ($rules as $index => $rule) {
                $threshold = (int) ($rule['after_minutes'] ?? 0);
                if ($minutesOpen < $threshold) {
                    continue;
                }

                $targetLevel = $index + 1;
                if ($targetLevel <= $level) {
                    continue;
                }

                $groups = $rule['groups'] ?? [];
                if ($groups) {
                    $this->dispatcher->dispatch($event, $groups);
                }

                $event->update([
                    'escalation_level' => $targetLevel,
                    'last_escalated_at' => now(),
                ]);

                break;
            }
        }
    }
}
