<?php

namespace App\Services;

use App\Models\Site;
use App\Models\TelegramGroup;

class TelegramGroupService
{
    public function linkGroup(int $tenantId, string $chatId, array $args): string
    {
        $name = $args['name'] ?? null;
        if (!$name) {
            return 'Provide name= for the group.';
        }

        $siteId = null;
        if (!empty($args['site'])) {
            $site = Site::where('tenant_id', $tenantId)
                ->where('name', 'like', '%' . $args['site'] . '%')
                ->first();
            $siteId = $site?->id;
        }

        $group = TelegramGroup::updateOrCreate(
            [
                'tenant_id' => $tenantId,
                'name' => $name,
            ],
            [
                'chat_id' => $chatId,
                'type' => $args['type'] ?? null,
                'site_id' => $siteId,
                'enabled' => true,
            ]
        );

        return "Group linked: {$group->name}.";
    }

    public function listGroups(int $tenantId): string
    {
        $groups = TelegramGroup::where('tenant_id', $tenantId)->get();
        if ($groups->isEmpty()) {
            return 'No Telegram groups linked yet.';
        }

        $lines = $groups->map(function ($group) {
            $site = $group->site?->name ?? '-';
            $status = $group->enabled ? 'enabled' : 'disabled';
            return "{$group->name} ({$site}) - {$status}";
        })->all();

        return "Groups:\n" . implode("\n", $lines);
    }
}
