<?php

namespace App\Services;

use App\Models\Tenant;
use Illuminate\Support\Facades\DB;

class TenancyService
{
    public function createTenant(array $data)
    {
        return Tenant::create($data);
    }

    public function updateTenant(Tenant $tenant, array $data)
    {
        $tenant->update($data);
        return $tenant;
    }

    public function deleteTenant(Tenant $tenant)
    {
        $tenant->delete();
    }

    public function getTenantById($id)
    {
        return Tenant::findOrFail($id);
    }

    public function getAllTenants()
    {
        return Tenant::all();
    }

    public function switchTenant($tenantId)
    {
        // Logic to switch the database connection to the specified tenant
        $tenant = $this->getTenantById($tenantId);
        config(['database.connections.tenant.database' => $tenant->database_name]);
        DB::purge('tenant');
        DB::reconnect('tenant');
    }
}