<?php

return [
    'version' => 'v1',
    'doc_types' => [
        'asset_register' => [
            'label' => 'Asset Register',
            'required' => ['asset_tag', 'name'],
            'optional' => ['make', 'model', 'category', 'location', 'serial_number', 'purchase_date', 'current_value'],
            'asset_fields' => ['asset_tag', 'serial_number', 'name'],
        ],
        'purchase_request' => [
            'label' => 'Purchase Request',
            'required' => ['item_ordered'],
            'optional' => [
                'quantity',
                'purpose_cost_centre',
                'date_initiated',
                'suppliers',
                'quote_number',
                'quote_amount_usd',
                'quote_amount_zwl',
                'selected_supplier',
                'comments',
            ],
        ],
        'invoice' => [
            'label' => 'Invoice',
            'required' => ['amount'],
            'optional' => [
                'work_order_ref',
                'asset_tag',
                'asset_name',
                'cost_type',
                'description',
                'invoice_number',
                'vendor',
                'po_number',
                'grn_reference',
                'invoice_date',
                'due_date',
                'paid_at',
                'currency',
            ],
            'asset_fields' => ['asset_tag', 'asset_name'],
        ],
        'service_sheet' => [
            'label' => 'Service Sheet',
            'required' => ['description'],
            'optional' => ['asset_tag', 'asset_name', 'completed_at', 'meter_reading', 'labor_cost', 'parts_cost', 'contractor_cost', 'work_order_ref', 'root_cause'],
            'asset_fields' => ['asset_tag', 'asset_name'],
        ],
        'fuel_sheet' => [
            'label' => 'Fuel Sheet',
            'required' => ['quantity'],
            'optional' => ['asset_tag', 'asset_name', 'source', 'fuel_type', 'unit_cost', 'total_cost', 'logged_at'],
            'asset_fields' => ['asset_tag', 'asset_name'],
        ],
        'meter_readings' => [
            'label' => 'Meter Readings',
            'required' => ['reading'],
            'optional' => ['asset_tag', 'asset_name', 'meter_type', 'reading_at'],
            'asset_fields' => ['asset_tag', 'asset_name'],
        ],
        'grn' => [
            'label' => 'Goods Received Note',
            'required' => ['reference'],
            'optional' => ['supplier', 'received_at', 'items'],
        ],
        'issue_voucher' => [
            'label' => 'Issue Voucher',
            'required' => ['reference'],
            'optional' => ['issued_to', 'issued_at', 'items'],
        ],
    ],
    'routing' => [
        'asset_register' => ['asset tag', 'asset id', 'asset name', 'make', 'model'],
        'purchase_request' => ['item ordered', 'purpose', 'quote amount', 'suppliers'],
        'invoice' => ['invoice', 'work order', 'amount', 'cost type'],
        'service_sheet' => ['service', 'work done', 'completed', 'meter'],
        'fuel_sheet' => ['fuel', 'litre', 'qty', 'source'],
        'meter_readings' => ['meter reading', 'hours', 'km', 'odometer'],
    ],
];
