<?php

return [
    'enabled' => env('MULTI_TENANCY', false),

    'tenant_model' => App\Models\Tenant::class,

    'database' => [
        'connection' => env('TENANT_DATABASE_CONNECTION', 'mysql'),
        'prefix' => env('TENANT_DB_PREFIX', 'tenant_'),
    ],

    'identification' => [
        'driver' => env('TENANT_IDENTIFICATION_DRIVER', 'subdomain'),
        'subdomain' => [
            'default' => env('TENANT_DEFAULT_SUBDOMAIN', 'www'),
        ],
    ],

    'routes' => [
        'prefix' => env('TENANT_ROUTE_PREFIX', 'tenant'),
        'middleware' => ['web', 'tenant'],
    ],

    'maintenance' => [
        'default_schedule' => env('TENANT_MAINTENANCE_SCHEDULE', 'daily'),
        'notification' => [
            'enabled' => env('TENANT_MAINTENANCE_NOTIFY', true),
            'channels' => ['email', 'sms'],
        ],
    ],

    'telematics' => [
        'enabled' => env('TELEMATICS_ENABLED', true),
        'data_sources' => ['gps', 'sensor', 'api'],
    ],

    'ai_automation' => [
        'enabled' => env('AI_AUTOMATION_ENABLED', true),
        'models' => [
            'asset' => App\Services\AiAutomationService::class,
            'maintenance' => App\Services\AiAutomationService::class,
        ],
    ],
];
