<?php

return [
    'thresholds' => [
        'pm_due_hours' => (int) env('PM_DUE_SOON_HOURS', 24),
        'pm_overdue_hours' => (int) env('PM_OVERDUE_HOURS', 0),
        'stock_low_multiplier' => (float) env('STOCK_LOW_MULTIPLIER', 1.0),
        'stock_critical_qty' => (float) env('STOCK_CRITICAL_QTY', 0),
        'compliance_due_days' => (int) env('COMPLIANCE_DUE_DAYS', 30),
        'po_overdue_days' => (int) env('PO_OVERDUE_DAYS', 3),
        'alarm_ack_minutes' => (int) env('ALARM_ACK_MINUTES', 10),
        'generator_low_fuel_percent' => (float) env('GENERATOR_LOW_FUEL_PERCENT', 20),
        'fuel_variance_threshold' => (float) env('FUEL_VARIANCE_THRESHOLD', 10),
    ],
    'groups' => [
        'maintenance' => ['FW-Quarry-Maint', 'FW-Concrete-Maint'],
        'procurement' => ['FW-Procurement'],
        'management' => ['FW-Management'],
    ],
    'event_groups' => [
        'pm_due' => ['maintenance'],
        'pm_overdue' => ['maintenance', 'management'],
        'breakdown' => ['maintenance', 'management'],
        'inventory_low' => ['maintenance'],
        'inventory_stockout' => ['maintenance', 'management'],
        'procurement_pr_pending' => ['procurement'],
        'procurement_po_overdue' => ['procurement', 'management'],
        'compliance_due' => ['maintenance', 'management'],
        'generator_alarm' => ['maintenance'],
        'wo_overdue' => ['maintenance', 'management'],
        'fuel_variance' => ['maintenance'],
        'agent.maintenance_compliance' => ['maintenance', 'management'],
        'agent.failure_prediction' => ['maintenance', 'management'],
        'agent.kpi_analyst' => ['management'],
        'agent.cost_control' => ['management', 'maintenance'],
        'agent.ops_notifier' => ['management'],
        'agent.finance_oversight' => ['management', 'procurement'],
        'agent.hr_artisan_performance' => ['management', 'maintenance'],
    ],
    'escalation' => [
        'breakdown' => [
            ['after_minutes' => 10, 'groups' => ['management']],
            ['after_minutes' => 60, 'groups' => ['management']],
        ],
        'inventory_stockout' => [
            ['after_minutes' => 30, 'groups' => ['management']],
        ],
    ],
];
