<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;

class AssetFactory extends Factory
{
    protected $model = Asset::class;

    public function definition()
    {
        return [
            'tenant_id' => Tenant::factory(),
            'name' => $this->faker->words(3, true),
            'asset_tag' => strtoupper($this->faker->bothify('AST-####')),
            'make' => $this->faker->company(),
            'model' => strtoupper($this->faker->bothify('MDL-###')),
            'serial_number' => strtoupper($this->faker->bothify('SN-#####')),
            'year' => (string) $this->faker->year(),
            'category' => $this->faker->randomElement(['Truck', 'Loader', 'Crusher', 'Genset', 'Plant']),
            'asset_type' => $this->faker->randomElement(['vehicle', 'mobile', 'fixed', 'tool']),
            'lifecycle_status' => $this->faker->randomElement(['active', 'standby', 'down', 'retired']),
            'commissioned_at' => $this->faker->dateTimeBetween('-5 years', '-1 year'),
            'description' => $this->faker->sentence(),
            'status' => $this->faker->randomElement(['active', 'inactive']),
            'purchase_date' => $this->faker->dateTimeBetween('-2 years', 'now'),
            'warranty_expiry' => $this->faker->dateTimeBetween('now', '+2 years'),
            'location' => $this->faker->city(),
            'current_value' => $this->faker->randomFloat(2, 1000, 50000),
            'maintenance_interval' => $this->faker->numberBetween(50, 500),
            'meter_type' => $this->faker->randomElement(['hours', 'km']),
            'meter_reading' => $this->faker->randomFloat(2, 100, 5000),
        ];
    }
}
