<?php

namespace Database\Factories;

use App\Models\Asset;
use App\Models\Maintenance;
use Illuminate\Database\Eloquent\Factories\Factory;

class MaintenanceFactory extends Factory
{
    protected $model = Maintenance::class;

    public function definition()
    {
        return [
            'asset_id' => Asset::factory(),
            'tenant_id' => function (array $attributes) {
                $asset = Asset::find($attributes['asset_id']);
                return $asset ? $asset->tenant_id : null;
            },
            'scheduled_date' => $this->faker->dateTimeBetween('now', '+1 month'),
            'completed_date' => null,
            'status' => $this->faker->randomElement(['pending', 'scheduled', 'completed']),
            'description' => $this->faker->sentence(),
            'notes' => $this->faker->optional()->sentence(),
            'usage_hours' => $this->faker->randomFloat(2, 0, 5000),
            'meter_reading' => $this->faker->randomFloat(2, 0, 5000),
        ];
    }
}
