<?php

namespace Database\Factories;

use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class TenantFactory extends Factory
{
    protected $model = Tenant::class;

    public function definition()
    {
        $name = $this->faker->company();

        return [
            'name' => $name,
            'email' => $this->faker->unique()->safeEmail(),
            'password' => bcrypt('password'),
            'subdomain' => Str::slug($name) . '-' . $this->faker->unique()->numberBetween(100, 999),
            'database_name' => null,
            'subscription_plan' => $this->faker->randomElement(['basic', 'pro', 'enterprise']),
            'status' => 'active',
        ];
    }
}
