<?php

namespace Database\Factories;

use App\Models\Tenant;
use App\Models\Trip;
use App\Models\Vehicle;
use Illuminate\Database\Eloquent\Factories\Factory;

class TripFactory extends Factory
{
    protected $model = Trip::class;

    public function definition()
    {
        $start = $this->faker->dateTimeBetween('-1 month', 'now');
        $end = $this->faker->dateTimeBetween($start, '+1 day');

        return [
            'tenant_id' => Tenant::factory(),
            'vehicle_id' => Vehicle::factory(),
            'start_location' => $this->faker->city(),
            'end_location' => $this->faker->city(),
            'start_time' => $start,
            'end_time' => $end,
            'distance' => $this->faker->randomFloat(2, 1, 500),
            'status' => $this->faker->randomElement(['active', 'completed']),
        ];
    }
}
