<?php

namespace Database\Factories;

use App\Models\Tenant;
use App\Models\Vehicle;
use Illuminate\Database\Eloquent\Factories\Factory;

class VehicleFactory extends Factory
{
    protected $model = Vehicle::class;

    public function definition()
    {
        return [
            'tenant_id' => Tenant::factory(),
            'asset_id' => null,
            'name' => $this->faker->words(2, true),
            'type' => $this->faker->randomElement(['truck', 'excavator', 'loader']),
            'license_plate' => strtoupper($this->faker->unique()->bothify('??###??')),
            'status' => $this->faker->randomElement(['active', 'inactive']),
            'telemetry_data' => null,
            'maintenance_schedule' => null,
            'odometer' => $this->faker->randomFloat(2, 1000, 90000),
            'engine_hours' => $this->faker->randomFloat(2, 100, 8000),
        ];
    }
}
