-- MySQL-compatible dump (source: SQLite)
SET FOREIGN_KEY_CHECKS=0;
START TRANSACTION;

-- Table: agent_notifications
DROP TABLE IF EXISTS `agent_notifications`;
CREATE TABLE `agent_notifications` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `agent_key` TEXT NOT NULL,
    `agent_name` TEXT NOT NULL,
    `severity` VARCHAR(100) NOT NULL DEFAULT 'info',
    `title` TEXT NOT NULL,
    `summary` TEXT,
    `payload` TEXT,
    `recipients` TEXT,
    `status` VARCHAR(100) NOT NULL DEFAULT 'queued',
    `sent_at` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (1, 31, 'maintenance_compliance', 'Maintenance Compliance Agent', 'warn', 'Maintenance Compliance', 'AI Agent: Maintenance Compliance
Overdue assets:
- ME-EXC-01 - Excavator 01 | 12d overdue | Risk: High
- DT-TRK-07 - Dump Truck 07 | 6d overdue | Risk: Medium
- CP-GEN-02 - Generator 02 | 180h overdue | Risk: Medium', '{"prompt":"You are a maintenance compliance AI for assets in the system. Scan all assets. Identify assets overdue for service based on hours or mileage or days. Rank by operational risk. Generate a short alert list.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 16:51:24', '2026-01-24 16:51:24', '2026-01-24 16:51:24');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (2, 31, 'failure_prediction', 'Failure Prediction Agent', 'warn', 'Failure Prediction', 'AI Agent: Failure Prediction
Signals:
- CP-JAW-01 - Jaw Crusher | downtime 9.5h (30d)
- ME-EXC-01 - Excavator 01 | spares spend $5,420
- DT-TRK-07 - Dump Truck 07 | fuel variance 18
Recommendations:
- Schedule inspections for repeat downtime assets.
- Review fuel variance for leaks or training.', '{"prompt":"Analyze downtime, fuel usage, oil usage, spares consumption and service history. Detect abnormal trends. Predict potential failure risks. Recommend preventive action.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 16:51:25', '2026-01-24 16:51:25', '2026-01-24 16:51:25');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (3, 31, 'kpi_analyst', 'KPI Analyst Agent', 'info', 'Weekly KPI Report', 'AI Agent: KPI Analyst
- Availability: 88.2%
- Utilization: 63.5%
- MTBF: 42h
- Fuel efficiency: 18.4 L/hr
Risks: Downtime 3.2h this week.
Wins: Availability near target.', '{"prompt":"Generate a weekly executive report. Calculate availability, utilization, MTBF, and fuel efficiency. Summarize in plain language. Highlight risks and wins.","sample":true}', '["management"]', 'sent', '2026-01-24 16:51:26', '2026-01-24 16:51:26', '2026-01-24 16:51:26');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (4, 31, 'cost_control', 'Cost Control Agent', 'warn', 'Cost Control Alert', 'AI Agent: Cost Control
- Maintenance costs spiked to $12,540 (avg $8,200)
- Fuel costs spiked to $6,440 (avg $4,900)
Recommendation: Investigate recent jobs and fuel usage spikes.', '{"prompt":"Monitor maintenance and fuel costs. Flag spikes exceeding historical average by 20%. Recommend investigation.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 16:51:26', '2026-01-24 16:51:26', '2026-01-24 16:51:26');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (5, 31, 'ops_notifier', 'Ops Notifier Agent', 'alarm', 'Ops Notifier', 'AI Agent: Ops Notifier
Critical findings:
- CP-JAW-01 - Jaw Crusher | High risk downtime trend
- ME-EXC-01 - Excavator 01 | Service overdue 12d
- DT-TRK-07 - Dump Truck 07 | Fuel variance alert', '{"prompt":"Convert critical findings into Telegram alerts. Be concise. Use bullet points. Escalate only high-risk issues.","sample":true}', '["management"]', 'sent', '2026-01-24 16:51:26', '2026-01-24 16:51:26', '2026-01-24 16:51:26');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (6, 31, 'maintenance_compliance', 'Maintenance Compliance Agent', 'warn', 'Maintenance Compliance', 'AI Agent: Maintenance Compliance
Overdue assets:
- ME-EXC-03 - Excavator 03 | 4d overdue | Risk: Medium
- CP-CONV-02 - Conveyor 02 | 220h overdue | Risk: Medium
- DT-TIP-05 - Tipper 05 | 15d overdue | Risk: High', '{"prompt":"You are a maintenance compliance AI for assets in the system. Scan all assets. Identify assets overdue for service based on hours or mileage or days. Rank by operational risk. Generate a short alert list.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 16:56:08', '2026-01-24 16:56:08', '2026-01-24 16:56:08');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (7, 31, 'failure_prediction', 'Failure Prediction Agent', 'alarm', 'Failure Prediction', 'AI Agent: Failure Prediction
Signals:
- CP-JAW-02 - Jaw Crusher 02 | downtime 12.4h (30d)
- ME-LDR-02 - Loader 02 | spares spend $7,980
- BP-GEN-01 - Generator 01 | fuel variance 24
Recommendations:
- Inspect crusher bearings within 48h.
- Review loader hydraulic leaks.
- Check generator fuel sensor calibration.', '{"prompt":"Analyze downtime, fuel usage, oil usage, spares consumption and service history. Detect abnormal trends. Predict potential failure risks. Recommend preventive action.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 16:56:09', '2026-01-24 16:56:09', '2026-01-24 16:56:09');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (8, 31, 'kpi_analyst', 'KPI Analyst Agent', 'warn', 'Weekly KPI Report', 'AI Agent: KPI Analyst
- Availability: 82.6%
- Utilization: 58.3%
- MTBF: 31h
- Fuel efficiency: 19.1 L/hr
Risks: Downtime 6.8h this week.
Wins: PM completion improved by 9%.', '{"prompt":"Generate a weekly executive report. Calculate availability, utilization, MTBF, and fuel efficiency. Summarize in plain language. Highlight risks and wins.","sample":true}', '["management"]', 'sent', '2026-01-24 16:56:09', '2026-01-24 16:56:09', '2026-01-24 16:56:09');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (9, 31, 'cost_control', 'Cost Control Agent', 'alarm', 'Cost Control Alert', 'AI Agent: Cost Control
- Maintenance costs spiked to $18,250 (avg $9,600)
- Fuel costs spiked to $7,890 (avg $4,700)
Recommendation: Validate invoices and review high-cost work orders.', '{"prompt":"Monitor maintenance and fuel costs. Flag spikes exceeding historical average by 20%. Recommend investigation.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 16:56:09', '2026-01-24 16:56:09', '2026-01-24 16:56:09');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (10, 31, 'ops_notifier', 'Ops Notifier Agent', 'alarm', 'Ops Notifier', 'AI Agent: Ops Notifier
Critical findings:
- DT-TIP-05 - Tipper 05 | Service overdue 15d
- CP-JAW-02 - Jaw Crusher 02 | Failure risk high
- BP-GEN-01 - Generator 01 | Fuel variance alert', '{"prompt":"Convert critical findings into Telegram alerts. Be concise. Use bullet points. Escalate only high-risk issues.","sample":true}', '["management"]', 'sent', '2026-01-24 16:56:10', '2026-01-24 16:56:10', '2026-01-24 16:56:10');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (11, 31, 'maintenance_compliance', 'Maintenance Compliance Agent', 'warn', 'Maintenance Compliance', 'AI Agent: Maintenance Compliance
Overdue assets:
- ME-EXC-03 - Excavator 03 | 4d overdue | Risk: Medium
- CP-CONV-02 - Conveyor 02 | 220h overdue | Risk: Medium
- DT-TIP-05 - Tipper 05 | 15d overdue | Risk: High', '{"prompt":"You are a maintenance compliance AI for assets in the system. Scan all assets. Identify assets overdue for service based on hours or mileage or days. Rank by operational risk. Generate a short alert list.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 17:42:53', '2026-01-24 17:42:53', '2026-01-24 17:42:53');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (12, 31, 'failure_prediction', 'Failure Prediction Agent', 'alarm', 'Failure Prediction', 'AI Agent: Failure Prediction
Signals:
- CP-JAW-02 - Jaw Crusher 02 | downtime 12.4h (30d)
- ME-LDR-02 - Loader 02 | spares spend $7,980
- BP-GEN-01 - Generator 01 | fuel variance 24
Recommendations:
- Inspect crusher bearings within 48h.
- Review loader hydraulic leaks.
- Check generator fuel sensor calibration.', '{"prompt":"Analyze downtime, fuel usage, oil usage, spares consumption and service history. Detect abnormal trends. Predict potential failure risks. Recommend preventive action.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 17:42:54', '2026-01-24 17:42:54', '2026-01-24 17:42:54');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (13, 31, 'kpi_analyst', 'KPI Analyst Agent', 'warn', 'Weekly KPI Report', 'AI Agent: KPI Analyst
- Availability: 82.6%
- Utilization: 58.3%
- MTBF: 31h
- Fuel efficiency: 19.1 L/hr
Risks: Downtime 6.8h this week.
Wins: PM completion improved by 9%.', '{"prompt":"Generate a weekly executive report. Calculate availability, utilization, MTBF, and fuel efficiency. Summarize in plain language. Highlight risks and wins.","sample":true}', '["management"]', 'sent', '2026-01-24 17:42:55', '2026-01-24 17:42:55', '2026-01-24 17:42:55');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (14, 31, 'cost_control', 'Cost Control Agent', 'alarm', 'Cost Control Alert', 'AI Agent: Cost Control
- Maintenance costs spiked to $18,250 (avg $9,600)
- Fuel costs spiked to $7,890 (avg $4,700)
Recommendation: Validate invoices and review high-cost work orders.', '{"prompt":"Monitor maintenance and fuel costs. Flag spikes exceeding historical average by 20%. Recommend investigation.","sample":true}', '["maintenance","management"]', 'sent', '2026-01-24 17:42:55', '2026-01-24 17:42:55', '2026-01-24 17:42:55');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (15, 31, 'ops_notifier', 'Ops Notifier Agent', 'alarm', 'Ops Notifier', 'AI Agent: Ops Notifier
Critical findings:
- DT-TIP-05 - Tipper 05 | Service overdue 15d
- CP-JAW-02 - Jaw Crusher 02 | Failure risk high
- BP-GEN-01 - Generator 01 | Fuel variance alert', '{"prompt":"Convert critical findings into Telegram alerts. Be concise. Use bullet points. Escalate only high-risk issues.","sample":true}', '["management"]', 'sent', '2026-01-24 17:42:55', '2026-01-24 17:42:55', '2026-01-24 17:42:55');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (16, 31, 'finance_oversight', 'Finance Oversight Agent', 'alarm', 'Finance Oversight Digest', 'AI Agent: Finance Oversight
- PR aging: 6.4 days | PO aging: 9.8 days | Invoice aging: 18.1 days
- Unpaid total: $42,850 | Spend vs budget: 128%
Findings:
- Duplicate invoice detected (INV-2213)
- Invoice missing PO/GRN link (INV-2291)
- PO overdue delivery (PO-0187)
Suggested action: HOLD_PAYMENT', '{"prompt":"Monitor PRs, POs, GRNs, invoices, payments, and spend. Detect overdue approvals, overdue payments, budget overruns, unauthorized PRs, split PRs, missing PO\/GRN links, duplicate invoices, price variance, and urgent misuse. Summarize findings into finance-friendly bullets and recommend next steps.","sample":true}', '["management","procurement"]', 'sent', '2026-01-24 17:42:55', '2026-01-24 17:42:55', '2026-01-24 17:42:55');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (17, 31, 'hr_artisan_performance', 'HR Artisan Performance Agent', 'warn', 'Artisan Performance Summary', 'AI Agent: HR Artisan Performance
- Tendai Moyo: assigned 12, completed 9, utilization 46%, compliance 62%
- Farai Dube: assigned 8, completed 8, utilization 74%, compliance 91%
- Memory Ncube: assigned 6, completed 3, utilization 29%, compliance 45%
Findings:
- Low utilization (<30%) (Memory Ncube)
- Checklist compliance below 50% (Memory Ncube)
Suggested action: REVIEW_SUPERVISOR', '{"prompt":"Monitor artisan productivity and compliance: assignments, completions, evidence uploads, repeat failures, utilization, and workload balance. Provide coaching-style bullets: top performers, compliance gaps, training needs, and workload balancing recommendations.","sample":true}', '["management","maintenance"]', 'sent', '2026-01-24 17:42:56', '2026-01-24 17:42:56', '2026-01-24 17:42:56');
INSERT INTO `agent_notifications` (`id`, `tenant_id`, `agent_key`, `agent_name`, `severity`, `title`, `summary`, `payload`, `recipients`, `status`, `sent_at`, `created_at`, `updated_at`) VALUES (18, 31, 'ops_notifier', 'Ops Notifier Agent', 'alarm', 'Ops Notifier', 'AI Agent: Ops Notifier
Critical findings:
- DT-TIP-05 - Tipper 05 | Service overdue 15d
- CP-JAW-02 - Jaw Crusher 02 | Failure risk high
- BP-GEN-01 - Generator 01 | Fuel variance alert', '{"prompt":"Convert critical findings into Telegram alerts. Be concise. Use bullet points. Escalate only high-risk issues.","sample":true}', '["management"]', 'sent', '2026-01-24 18:19:40', '2026-01-24 18:19:40', '2026-01-24 18:19:40');

-- Table: ai_insights
DROP TABLE IF EXISTS `ai_insights`;
CREATE TABLE `ai_insights` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT,
    `type` TEXT NOT NULL,
    `payload` TEXT,
    `confidence` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



-- Table: ai_reports
DROP TABLE IF EXISTS `ai_reports`;
CREATE TABLE `ai_reports` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `report_type` VARCHAR(100) NOT NULL DEFAULT 'weekly_kpi',
    `period_start` DATE,
    `period_end` DATE,
    `content` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



-- Table: ai_tool_logs
DROP TABLE IF EXISTS `ai_tool_logs`;
CREATE TABLE `ai_tool_logs` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `user_id` BIGINT,
    `conversation_id` BIGINT,
    `upload_id` BIGINT,
    `tool_name` TEXT NOT NULL,
    `action` TEXT NOT NULL,
    `target_type` TEXT,
    `target_id` BIGINT,
    `input` TEXT,
    `output` TEXT,
    `status` VARCHAR(100) NOT NULL DEFAULT 'success',
    `source` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (1, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"ROLLER IDLERS (BIG)","quantity":"","purpose_cost_centre":"CONVEYOR BELTS","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (2, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"CONE OIL FILTERS","quantity":"2","purpose_cost_centre":"CONE OIL TANK","date_initiated":"46001","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (3, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"ROLLER IDLERS (SMALL)","quantity":"","purpose_cost_centre":"CONVEYOR BELTS","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (4, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"FIRE EXTINGUISHER 9KG","quantity":"8","purpose_cost_centre":"PLANT","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"496","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (5, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"20MM STEEL PLATE","quantity":"1","purpose_cost_centre":"PLANT","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (6, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"CONE PRESSURE GUAGE & REGULATOR","quantity":"1","purpose_cost_centre":"CONE OIL TANK","date_initiated":"46001","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (7, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"CONVEYOR GEARBOX","quantity":"1","purpose_cost_centre":"SCREEN 3","date_initiated":"46011","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (8, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"TYRE PRESSURE GUAGE & PIPE","quantity":"1","purpose_cost_centre":"PLANT","date_initiated":"45689","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (9, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"BELT FASTENERS","quantity":"30","purpose_cost_centre":"CONVEYOR BELTS","date_initiated":"45689","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (10, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"Prepared By:","quantity":"Stores & Procurement: \u2026........................................","purpose_cost_centre":"","date_initiated":"","suppliers":"","quote_number":null,"quote_amount_usd":null,"selected_supplier":null,"quote_amount_zwl":"","comments":null}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');
INSERT INTO `ai_tool_logs` (`id`, `tenant_id`, `user_id`, `conversation_id`, `upload_id`, `tool_name`, `action`, `target_type`, `target_id`, `input`, `output`, `status`, `source`, `created_at`, `updated_at`) VALUES (11, 31, NULL, 5, NULL, 'purchase_request', 'create', 'purchase_request', NULL, '{"item_ordered":"Authorised By:","quantity":"Mine Manager: \u2026........................................","purpose_cost_centre":"","date_initiated":"","suppliers":"","quote_number":null,"quote_amount_usd":null,"selected_supplier":null,"quote_amount_zwl":null,"comments":null}', '{"request_id":3}', 'success', 'ai_intake', '2026-01-18 15:11:48', '2026-01-18 15:11:48');

-- Table: alarm_rules
DROP TABLE IF EXISTS `alarm_rules`;
CREATE TABLE `alarm_rules` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `name` TEXT NOT NULL,
    `metric` TEXT,
    `comparison` TEXT,
    `threshold` TEXT,
    `severity` VARCHAR(100) NOT NULL DEFAULT 'warning',
    `conditions` TEXT,
    `schedule` TEXT,
    `actions` TEXT,
    `enabled` TINYINT NOT NULL DEFAULT '1',
    `created_by` BIGINT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (1, 21, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (2, 22, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (3, 23, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (4, 24, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (5, 25, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (6, 26, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (7, 27, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (8, 28, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (9, 29, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (10, 30, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-11 14:11:01', '2026-01-11 14:11:01');
INSERT INTO `alarm_rules` (`id`, `tenant_id`, `name`, `metric`, `comparison`, `threshold`, `severity`, `conditions`, `schedule`, `actions`, `enabled`, `created_by`, `created_at`, `updated_at`) VALUES (11, 31, 'High coolant temp', 'coolant_temp', '>', 95, 'critical', NULL, NULL, '{"auto_work_order":true}', 1, NULL, '2026-01-13 20:15:03', '2026-01-13 20:15:03');

-- Table: alarms
DROP TABLE IF EXISTS `alarms`;
CREATE TABLE `alarms` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT,
    `rule_id` BIGINT,
    `work_order_id` BIGINT,
    `severity` VARCHAR(100) NOT NULL DEFAULT 'warning',
    `status` VARCHAR(100) NOT NULL DEFAULT 'open',
    `message` TEXT,
    `triggered_at` DATETIME,
    `acknowledged_by` BIGINT,
    `acknowledged_at` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



-- Table: asset_assignments
DROP TABLE IF EXISTS `asset_assignments`;
CREATE TABLE `asset_assignments` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT NOT NULL,
    `user_id` BIGINT NOT NULL,
    `role` TEXT,
    `shift_name` TEXT,
    `starts_at` DATETIME,
    `ends_at` DATETIME,
    `notes` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



-- Table: asset_documents
DROP TABLE IF EXISTS `asset_documents`;
CREATE TABLE `asset_documents` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT NOT NULL,
    `type` TEXT NOT NULL,
    `file_path` TEXT NOT NULL,
    `expiry_date` DATE,
    `metadata` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



-- Table: asset_spares
DROP TABLE IF EXISTS `asset_spares`;
CREATE TABLE `asset_spares` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT NOT NULL,
    `part_id` BIGINT NOT NULL,
    `quantity` TEXT,
    `unit_cost` TEXT,
    `replacement_frequency` TEXT,
    `estimated_replacements_per_year` TEXT,
    `cost_per_year` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;



-- Table: assets
DROP TABLE IF EXISTS `assets`;
CREATE TABLE `assets` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `name` TEXT NOT NULL,
    `description` TEXT,
    `status` VARCHAR(100) NOT NULL DEFAULT 'active',
    `purchase_date` DATE,
    `warranty_expiry` DATE,
    `location` TEXT,
    `current_value` TEXT,
    `maintenance_interval` BIGINT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    `deleted_at` DATETIME,
    `asset_tag` TEXT,
    `make` TEXT,
    `model` TEXT,
    `serial_number` TEXT,
    `year` TEXT,
    `category` TEXT,
    `asset_type` TEXT,
    `lifecycle_status` VARCHAR(100) NOT NULL DEFAULT 'active',
    `commissioned_at` DATE,
    `meter_type` TEXT,
    `meter_reading` TEXT,
    `site_id` BIGINT,
    `fit_for_purpose` TINYINT,
    `plant_restrictions` TEXT,
    `comments` TEXT,
    `service_frequency` TEXT,
    `next_review_at` DATE,
    `source` TEXT,
    `spare_tags` TEXT,
    `top_spares` TEXT,
    `yearly_budget` TEXT,
    `daily_budget` TEXT,
    `weekly_budget` TEXT,
    `monthly_budget` TEXT,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (1, 1, 'omnis aliquam dolor', 'Iste est quia a repellat qui et consequatur accusamus.', 'inactive', '2024-05-20 03:33:20', '2027-04-09 09:26:27', 'Deckowbury', 9915.68, 414, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (2, 1, 'delectus dolore tenetur', 'Dolorem est nemo voluptates qui saepe ullam ea.', 'inactive', '2025-09-27 17:42:38', '2026-02-28 13:37:55', 'New Elenorstad', 41196.81, 452, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (3, 1, 'et et quisquam', 'Ratione aliquid quo porro vel eius veniam.', 'active', '2025-04-06 13:25:24', '2027-10-27 14:53:49', 'Maymouth', 41004.97, 336, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (4, 1, 'eos itaque animi', 'Ut est aliquid laboriosam aut.', 'active', '2024-10-21 14:10:34', '2026-02-10 03:34:28', 'Kuhictown', 34153.1, 285, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (5, 1, 'reprehenderit quasi repudiandae', 'Quasi nostrum in aliquam sit doloribus veritatis nobis.', 'inactive', '2025-10-27 04:09:36', '2026-03-24 22:01:36', 'Jakubowskiburgh', 20821.04, 159, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (6, 2, 'quia in minus', 'Libero eius eaque ut culpa odio.', 'active', '2024-03-23 09:44:12', '2026-08-24 08:01:58', 'Lake Jacklynton', 49808.52, 99, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (7, 2, 'et alias ut', 'Ad rerum aliquid odit.', 'inactive', '2024-08-29 13:29:54', '2026-12-13 08:22:44', 'East Fredrickchester', 32955.53, 409, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (8, 2, 'enim voluptatibus impedit', 'Sit voluptatem maxime perferendis.', 'active', '2024-01-16 13:56:18', '2027-11-10 19:49:02', 'Lake Jaida', 8484.02, 466, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (9, 2, 'perferendis sed ipsam', 'Itaque tenetur fugit pariatur dolores aut.', 'active', '2025-10-27 05:08:40', '2026-07-25 16:41:08', 'Sipesshire', 32010.58, 249, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (10, 2, 'consequatur at vitae', 'Est assumenda nostrum amet delectus reiciendis error dolor.', 'active', '2024-05-16 03:21:58', '2026-11-12 20:04:55', 'Port Bud', 41585.61, 318, '2026-01-11 11:45:20', '2026-01-11 11:45:20', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (11, 3, 'et maiores repellendus', 'Accusamus veritatis alias voluptatem animi tempore velit.', 'active', '2025-01-23 00:04:30', '2027-05-22 16:05:34', 'North Solon', 23697.24, 494, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (12, 3, 'repudiandae ullam eos', 'Delectus corrupti dignissimos laudantium voluptatem.', 'inactive', '2025-07-13 04:05:01', '2026-02-25 01:17:03', 'Jerrellport', 30823.74, 343, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (13, 3, 'ut odio dolores', 'Mollitia placeat est consequatur fuga.', 'inactive', '2025-05-21 18:34:15', '2026-12-15 11:23:43', 'Keyonport', 33032.56, 437, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (14, 3, 'facere totam cumque', 'Nemo dolorem deleniti optio quae.', 'active', '2025-03-03 13:43:46', '2027-12-10 22:14:59', 'South Nickolasfort', 31688.35, 316, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (15, 3, 'et nulla earum', 'Et quae et asperiores explicabo qui nihil ea maiores.', 'inactive', '2024-10-16 17:38:38', '2026-07-31 15:56:57', 'Kingberg', 3821.21, 300, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (16, 4, 'facilis voluptatum et', 'Voluptate quo recusandae veritatis minima eum reiciendis.', 'inactive', '2024-11-23 16:27:45', '2027-11-05 10:03:29', 'Port Lilliemouth', 36913.91, 206, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (17, 4, 'pariatur error dolore', 'Necessitatibus rerum voluptatem vel dolores.', 'inactive', '2024-10-02 15:25:17', '2027-10-15 05:35:28', 'Mossieside', 46091.09, 67, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (18, 4, 'qui minus odit', 'Quisquam nihil mollitia quo aliquam.', 'active', '2025-05-19 19:33:11', '2026-04-04 17:37:40', 'Lake Rosalee', 32713.17, 291, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (19, 4, 'ut at doloribus', 'Molestias necessitatibus quasi eaque iure eos dolorem.', 'inactive', '2024-10-20 23:57:33', '2027-08-22 13:49:59', 'Donavonberg', 45882.64, 143, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (20, 4, 'ut qui omnis', 'Labore qui voluptatum eum omnis quos et.', 'inactive', '2024-02-06 15:24:39', '2027-10-31 20:54:33', 'Morissettebury', 6362.72, 263, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (21, 5, 'est et maxime', 'Consequuntur reiciendis aut odio saepe.', 'inactive', '2024-01-22 05:28:17', '2026-03-12 09:29:48', 'West Cyrilshire', 19369.04, 488, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (22, 5, 'inventore perspiciatis ipsam', 'Minima voluptatem optio velit fuga pariatur quis.', 'inactive', '2025-08-08 07:19:47', '2027-09-07 05:55:49', 'South Oraton', 36664.49, 454, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (23, 5, 'et iusto est', 'Non veniam est incidunt itaque provident omnis error consequuntur.', 'active', '2024-12-13 21:22:28', '2028-01-02 20:12:18', 'Frederikberg', 16774.39, 249, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (24, 5, 'est mollitia voluptatem', 'Non et at et hic magni qui.', 'active', '2025-12-09 21:04:52', '2027-10-16 14:14:41', 'Prudencemouth', 38851.58, 318, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (25, 5, 'quidem nemo commodi', 'Et et aut quod quis.', 'inactive', '2025-07-31 07:10:30', '2027-03-04 04:32:33', 'Omashire', 8804.27, 384, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (26, 6, 'voluptates consectetur et', 'Ut in et illo quos.', 'inactive', '2024-09-30 10:42:58', '2026-03-20 01:53:06', 'Mekhishire', 4434.8, 209, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (27, 6, 'vitae ea dolor', 'Consequatur quaerat et doloremque voluptatem.', 'active', '2024-05-08 08:51:53', '2027-05-07 05:23:40', 'New Kaliville', 29946.35, 496, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (28, 6, 'at perspiciatis adipisci', 'Culpa dicta beatae quibusdam et itaque.', 'active', '2025-06-23 10:35:13', '2026-06-18 06:57:49', 'Port Vanessa', 7434.47, 480, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (29, 6, 'sunt aliquid quisquam', 'Quam non deserunt voluptatum nobis.', 'active', '2024-04-06 06:17:40', '2026-06-23 05:36:35', 'Jermainshire', 20444.68, 469, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (30, 6, 'distinctio ut ipsam', 'Sed eveniet dolores ducimus et aliquam officia.', 'inactive', '2024-05-02 07:24:11', '2026-10-31 00:01:55', 'Rogahnland', 5416.77, 214, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (31, 7, 'deserunt deleniti qui', 'Illo ut in accusamus praesentium aut velit odit.', 'active', '2024-02-24 09:25:07', '2026-08-27 21:43:29', 'Garfieldmouth', 38083.27, 494, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (32, 7, 'enim voluptatem qui', 'Placeat sed harum beatae labore.', 'inactive', '2024-01-17 09:45:34', '2027-01-14 11:43:49', 'West Domenica', 13383.54, 406, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (33, 7, 'voluptas perferendis sunt', 'Quis autem et voluptatem nostrum repellat.', 'active', '2024-09-08 07:03:01', '2027-05-27 15:09:03', 'South Summer', 15424.57, 151, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (34, 7, 'ad sed qui', 'Officiis dicta error id.', 'active', '2024-07-03 08:28:30', '2026-02-04 15:41:06', 'West Addie', 29514.38, 393, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (35, 7, 'eos eligendi ex', 'Libero quod sequi qui.', 'inactive', '2025-04-29 17:02:27', '2027-10-04 18:03:33', 'Wymanshire', 38171.83, 461, '2026-01-11 11:45:21', '2026-01-11 11:45:21', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (36, 8, 'cupiditate dolores delectus', 'Atque omnis consequatur cupiditate ut ab.', 'active', '2025-05-15 04:18:45', '2027-09-14 12:39:18', 'Nicklausmouth', 26189.76, 220, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (37, 8, 'necessitatibus voluptates placeat', 'Tempora dolor molestias aut ipsam nisi doloremque magni.', 'active', '2025-08-04 04:16:34', '2026-10-07 10:48:15', 'North Eldridgeshire', 44535.39, 122, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (38, 8, 'ipsa non eius', 'Ipsa asperiores excepturi omnis debitis qui necessitatibus veniam ab.', 'inactive', '2025-12-04 10:36:18', '2027-11-05 05:06:40', 'New Shayne', 8099.97, 75, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (39, 8, 'magni corporis voluptas', 'Soluta qui aperiam ipsum porro eos.', 'active', '2025-10-05 23:24:31', '2026-02-28 07:10:23', 'Port Krystina', 14366.6, 311, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (40, 8, 'unde nesciunt ipsam', 'Minima recusandae placeat itaque quia rerum aspernatur.', 'active', '2025-11-11 19:01:44', '2026-02-16 02:48:20', 'Wunschmouth', 19965.8, 398, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (41, 9, 'qui quam dolorum', 'Enim exercitationem assumenda enim enim et commodi.', 'inactive', '2024-07-28 04:43:48', '2026-09-27 18:13:52', 'Hackettland', 1057.13, 141, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (42, 9, 'dolorem voluptatem consectetur', 'Eligendi qui necessitatibus autem esse.', 'inactive', '2025-08-04 07:35:53', '2027-09-26 02:50:04', 'North Alexfurt', 48308.17, 147, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (43, 9, 'iste voluptates voluptas', 'Labore adipisci quasi quibusdam amet iure enim.', 'inactive', '2024-03-25 17:04:25', '2027-08-29 22:31:14', 'North Hildegardchester', 8884.97, 118, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (44, 9, 'voluptates quam harum', 'Sed voluptatem minus rerum minus.', 'inactive', '2024-12-31 06:42:21', '2026-06-24 04:07:37', 'Joliefort', 33469.21, 57, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (45, 9, 'facere nulla sed', 'Sunt sapiente ratione sapiente.', 'inactive', '2025-10-28 04:47:11', '2026-11-18 11:22:12', 'Thadhaven', 32555.53, 333, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (46, 10, 'molestiae sapiente consequatur', 'Labore hic in odio ullam nihil.', 'inactive', '2024-02-01 05:02:15', '2026-04-03 04:37:22', 'Heidenreichshire', 21055.08, 264, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (47, 10, 'voluptas numquam molestiae', 'Labore accusamus reiciendis voluptatem optio.', 'inactive', '2025-05-05 15:43:55', '2026-09-25 06:56:19', 'North Ilaland', 6703.5, 417, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (48, 10, 'dolore ab et', 'In nobis quae voluptas iste minima nam quia.', 'active', '2025-09-20 00:28:08', '2026-11-28 09:07:43', 'Lucilefort', 4104.77, 154, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (49, 10, 'minima debitis voluptas', 'Cumque id quia molestiae voluptatem quia repellendus nostrum adipisci.', 'inactive', '2024-02-13 19:03:27', '2026-09-12 01:20:00', 'Bechtelartown', 32382.69, 109, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (50, 10, 'doloremque et repellendus', 'Accusantium quisquam atque enim nobis molestiae in repellendus aut.', 'active', '2025-01-24 17:03:00', '2027-12-09 15:35:50', 'Petemouth', 2747.46, 172, '2026-01-11 11:45:22', '2026-01-11 11:45:22', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'active', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (51, 11, 'ab a corrupti', 'Placeat quo vel saepe qui sapiente minima qui.', 'active', '2024-03-10 08:11:41', '2027-07-24 01:54:56', 'Osinskiburgh', 30023.91, 203, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-7119', 'Marvin, Schowalter and Dooley', 'MDL-687', 'SN-54099', 2018, 'Plant', 'mobile', 'active', '2022-10-04 08:25:40', 'hours', 3720.1, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (52, 11, 'voluptas qui voluptatem', 'Ipsa error tempora commodi soluta doloremque tenetur quam.', 'inactive', '2025-03-30 00:35:01', '2026-09-18 00:38:43', 'Jacklynmouth', 8488.39, 166, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-7067', 'Rau-Mayer', 'MDL-981', 'SN-40266', 2013, 'Crusher', 'tool', 'active', '2022-09-05 12:50:48', 'hours', 3150.24, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (53, 11, 'a ut facere', 'Optio ea repellat in velit tempore.', 'inactive', '2024-02-01 19:45:03', '2026-03-26 18:01:26', 'Normafort', 32063.08, 336, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-0480', 'Hoeger, Trantow and Witting', 'MDL-751', 'SN-53603', 1984, 'Genset', 'fixed', 'standby', '2023-04-05 07:57:30', 'hours', 4166.02, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (54, 11, 'doloribus fugit nobis', 'Culpa repudiandae nihil atque voluptates ducimus occaecati delectus id.', 'inactive', '2025-11-08 15:51:34', '2027-06-11 05:03:09', 'Predovicchester', 11697.18, 325, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-7373', 'Kshlerin Inc', 'MDL-605', 'SN-87287', 2007, 'Truck', 'tool', 'active', '2024-03-20 09:23:08', 'km', 3140.64, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (55, 11, 'sit quae voluptatum', 'Laudantium culpa est non ea sunt voluptatum.', 'inactive', '2026-01-09 16:23:20', '2026-03-21 06:26:17', 'Sadieburgh', 7987.18, 110, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-0167', 'Simonis-Conn', 'MDL-324', 'SN-77421', 1978, 'Crusher', 'mobile', 'standby', '2023-09-01 05:36:38', 'km', 4152.64, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (56, 11, 'quis dolore esse', 'Nobis sed deserunt quos et.', 'active', '2026-01-06 17:22:04', '2027-06-10 09:27:15', 'New Alexhaven', 27060.77, 142, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-9687', 'Hackett Group', 'MDL-556', 'SN-37477', 2014, 'Truck', 'vehicle', 'standby', '2022-12-04 05:58:29', 'km', 2901.29, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (57, 11, 'cumque accusamus eos', 'Perspiciatis beatae tempora omnis et eum harum.', 'inactive', '2025-05-23 00:51:58', '2027-07-03 19:50:33', 'Raynormouth', 37673.57, 359, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-4166', 'Miller-Nicolas', 'MDL-716', 'SN-93329', 1975, 'Crusher', 'fixed', 'down', '2021-09-14 17:24:15', 'hours', 3501.96, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (58, 11, 'quod dolore iusto', 'Delectus voluptatibus soluta dolorum asperiores.', 'active', '2024-06-07 13:03:44', '2027-07-21 20:44:05', 'North Stacy', 2175.35, 321, '2026-01-11 14:10:04', '2026-01-11 14:10:04', NULL, 'AST-1278', 'Deckow-Reinger', 'MDL-007', 'SN-24353', 1976, 'Plant', 'fixed', 'down', '2021-10-30 19:06:46', 'hours', 4134.5, 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (59, 21, 'et animi non', 'Repudiandae nihil atque omnis voluptatum vero.', 'inactive', '2025-06-28 10:45:36', '2026-05-12 23:31:27', 'Elfriedafurt', 36663.29, 343, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-6022', 'Greenfelder, Schmidt and Ankunding', 'MDL-205', 'SN-09099', 2018, 'Loader', 'vehicle', 'active', '2021-11-10 00:09:13', 'hours', 2453.8, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (60, 21, 'quia modi consequatur', 'Ullam et ab dolore enim quia nulla porro.', 'inactive', '2024-12-13 17:44:21', '2026-07-11 00:55:58', 'Sawaynton', 27060.34, 196, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-3580', 'Kerluke, Glover and Murray', 'MDL-267', 'SN-55175', 2008, 'Crusher', 'fixed', 'down', '2024-12-16 18:53:12', 'km', 4465.66, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (61, 21, 'deserunt exercitationem necessitatibus', 'Est facere velit nisi minima.', 'active', '2025-10-08 01:03:27', '2027-02-08 15:38:34', 'Schoenborough', 36589.02, 218, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-3435', 'Hills LLC', 'MDL-333', 'SN-03070', 1995, 'Truck', 'vehicle', 'retired', '2023-07-04 13:02:41', 'km', 765.24, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (62, 21, 'voluptatibus alias reprehenderit', 'Similique quam expedita deleniti et placeat.', 'inactive', '2024-01-28 12:25:08', '2027-01-07 15:37:47', 'North Ariane', 5330.4, 365, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-4413', 'Muller LLC', 'MDL-046', 'SN-96977', 2022, 'Plant', 'vehicle', 'retired', '2023-09-10 14:35:02', 'km', 1312.37, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (63, 21, 'repudiandae facere dolorem', 'Et beatae ducimus esse voluptate reprehenderit quo voluptatem.', 'active', '2024-02-04 17:42:43', '2026-01-25 19:07:05', 'Krystalfort', 36060.7, 474, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-5905', 'Roob-Nienow', 'MDL-541', 'SN-28222', 2019, 'Plant', 'tool', 'standby', '2023-06-20 03:04:26', 'km', 4145.45, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (64, 21, 'qui voluptas deserunt', 'Fugit qui aspernatur ut.', 'inactive', '2025-10-08 09:08:31', '2027-01-21 07:29:38', 'West Kiaraland', 5471.57, 298, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-3072', 'Stroman-Beer', 'MDL-924', 'SN-16468', 1987, 'Genset', 'tool', 'down', '2023-09-10 20:15:43', 'km', 3980.95, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (65, 21, 'in ad nesciunt', 'Quo optio consequatur et aspernatur totam quo porro.', 'inactive', '2025-03-25 10:21:23', '2027-08-05 22:47:52', 'Brianaview', 49313.79, 348, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-6414', 'Stiedemann, Carroll and Dare', 'MDL-734', 'SN-60412', 1998, 'Crusher', 'mobile', 'retired', '2021-11-28 15:44:25', 'km', 2363.35, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (66, 21, 'nulla similique veritatis', 'Consequatur maiores culpa incidunt ratione.', 'active', '2025-02-16 12:59:44', '2027-05-31 10:16:38', 'Port Ceciliabury', 32537.76, 286, '2026-01-11 14:10:53', '2026-01-11 14:10:53', NULL, 'AST-6226', 'Funk LLC', 'MDL-724', 'SN-40039', 1983, 'Plant', 'vehicle', 'standby', '2024-12-31 11:29:17', 'km', 3470.94, 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (67, 22, 'qui quasi cum', 'Sed adipisci perspiciatis cumque autem tenetur amet consectetur.', 'inactive', '2025-03-24 07:18:52', '2027-12-12 02:26:15', 'North Gabe', 40891.36, 353, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-8525', 'Bergstrom, Parisian and Larson', 'MDL-000', 'SN-52995', 1975, 'Crusher', 'fixed', 'standby', '2023-05-19 08:00:26', 'hours', 3658.53, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (68, 22, 'aliquid voluptatem aut', 'Velit et assumenda maiores repellendus explicabo doloribus.', 'active', '2024-05-06 22:11:22', '2027-08-18 21:16:29', 'Zulaufberg', 3233.58, 208, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-2368', 'Ryan Group', 'MDL-099', 'SN-51561', 1998, 'Genset', 'tool', 'down', '2023-04-08 21:12:09', 'km', 4756.54, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (69, 22, 'quia ipsa pariatur', 'Veritatis magni aut est quisquam ea.', 'inactive', '2025-01-09 20:01:24', '2026-05-15 10:36:13', 'North Ahmedmouth', 48234.39, 149, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-4548', 'Hoeger-Littel', 'MDL-905', 'SN-19798', 1987, 'Truck', 'mobile', 'standby', '2024-11-20 11:06:26', 'hours', 3208.58, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (70, 22, 'quo autem est', 'Nesciunt non rerum laborum velit eos.', 'inactive', '2024-09-30 01:46:29', '2026-04-30 18:22:48', 'West Neomaton', 46107.33, 70, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-1971', 'Treutel, Tremblay and Dicki', 'MDL-308', 'SN-63086', 1988, 'Loader', 'vehicle', 'active', '2024-01-11 09:12:02', 'km', 4264.14, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (71, 22, 'neque provident qui', 'Nostrum asperiores ea magni voluptatem.', 'active', '2024-07-04 23:16:15', '2026-10-13 13:15:30', 'Kirstenmouth', 32466.68, 256, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-3610', 'Larkin PLC', 'MDL-630', 'SN-30629', 2011, 'Plant', 'mobile', 'down', '2023-07-22 21:35:47', 'km', 3938.67, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (72, 22, 'qui vel soluta', 'Eum et vel quia.', 'inactive', '2025-10-07 01:14:27', '2026-04-30 20:17:28', 'Ferrymouth', 6135.96, 137, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-2536', 'Hagenes LLC', 'MDL-387', 'SN-81187', 1986, 'Truck', 'vehicle', 'retired', '2022-02-02 07:04:26', 'hours', 3941.44, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (73, 22, 'saepe nostrum ab', 'Vel eveniet velit eos iste consequatur fugit.', 'active', '2025-11-02 21:26:41', '2027-08-18 19:52:11', 'Powlowskimouth', 16467.93, 494, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-1593', 'Adams, Rau and Bernier', 'MDL-881', 'SN-45856', 1980, 'Truck', 'fixed', 'active', '2023-06-22 04:06:14', 'hours', 270.16, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (74, 22, 'facilis sint qui', 'Quidem recusandae omnis et quas a.', 'inactive', '2025-08-19 18:35:15', '2027-08-13 07:18:23', 'Faytown', 8471.61, 112, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-4610', 'Rolfson-Bayer', 'MDL-396', 'SN-23307', 1986, 'Genset', 'tool', 'standby', '2023-11-10 19:45:41', 'hours', 2509.21, 9, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (75, 23, 'dolorem repellendus et', 'Distinctio et numquam aut modi.', 'inactive', '2025-12-09 03:14:10', '2027-08-10 02:49:58', 'Hahnmouth', 3039.69, 477, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-0451', 'Rippin-Cartwright', 'MDL-954', 'SN-05252', 2024, 'Crusher', 'vehicle', 'down', '2024-01-05 04:45:27', 'km', 1863.64, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (76, 23, 'reiciendis delectus deleniti', 'Explicabo aliquid recusandae et.', 'inactive', '2025-05-16 15:16:32', '2026-08-23 17:22:29', 'East Alexandreview', 14254.44, 80, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-2257', 'Bailey LLC', 'MDL-804', 'SN-76112', 1986, 'Plant', 'vehicle', 'retired', '2021-06-12 18:59:06', 'km', 1489.49, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (77, 23, 'voluptas quidem quia', 'Quo dignissimos dolor dolorem quaerat rerum tempore porro.', 'inactive', '2024-05-22 14:15:53', '2026-10-27 21:44:13', 'Adalineport', 2782.06, 105, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-0929', 'Ebert, Gutmann and Altenwerth', 'MDL-223', 'SN-73735', 2016, 'Crusher', 'vehicle', 'active', '2023-11-10 16:36:23', 'km', 4916.88, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (78, 23, 'officia consequatur distinctio', 'Ab reprehenderit nihil et eius sequi.', 'inactive', '2024-04-14 15:31:16', '2027-03-20 15:06:20', 'South Salma', 6286.8, 483, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-0308', 'Johnston, Barrows and Herzog', 'MDL-198', 'SN-29975', 2016, 'Loader', 'fixed', 'standby', '2024-10-03 09:15:14', 'km', 3278.42, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (79, 23, 'et blanditiis ut', 'Nihil numquam voluptas omnis cum fugit sed est.', 'inactive', '2025-12-13 05:02:24', '2027-07-12 08:12:25', 'Effertzhaven', 29462.8, 351, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-3135', 'Carroll, Rodriguez and Rowe', 'MDL-471', 'SN-52782', 2025, 'Truck', 'fixed', 'standby', '2023-06-26 00:57:05', 'km', 1956.56, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (80, 23, 'quo modi quia', 'Laudantium laborum minima repudiandae aut repellendus blanditiis.', 'inactive', '2024-02-27 22:19:19', '2026-10-22 17:47:01', 'East Kaleport', 7295.03, 382, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-3537', 'Stark, Anderson and Bruen', 'MDL-085', 'SN-97110', 2007, 'Plant', 'tool', 'down', '2023-09-03 00:11:46', 'km', 3741.95, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (81, 23, 'iste eum sed', 'Dolores asperiores eligendi magnam sit saepe est quaerat.', 'active', '2025-12-08 17:21:44', '2027-06-24 10:33:47', 'Hermanport', 10017.8, 408, '2026-01-11 14:10:54', '2026-01-11 14:10:54', NULL, 'AST-8811', 'Brakus, Dietrich and Hane', 'MDL-292', 'SN-22459', 1974, 'Truck', 'vehicle', 'down', '2022-10-21 16:41:34', 'km', 1036.59, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (82, 23, 'facere qui velit', 'Est voluptatem libero nihil alias et voluptas laudantium corrupti.', 'inactive', '2025-09-17 17:36:04', '2026-11-11 21:30:19', 'McCulloughstad', 10836.42, 132, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-8306', 'Rath, Huels and Waters', 'MDL-047', 'SN-40611', 2002, 'Genset', 'vehicle', 'active', '2024-01-14 16:44:37', 'km', 4869.65, 12, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (83, 24, 'tempore itaque quia', 'Dolorem soluta voluptatem corporis quia et.', 'inactive', '2024-10-25 09:11:53', '2027-03-22 10:32:18', 'South Ellenborough', 45089.86, 201, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-8699', 'Wunsch-Ferry', 'MDL-161', 'SN-20293', 1996, 'Crusher', 'fixed', 'active', '2024-02-27 06:45:32', 'hours', 1011.3, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (84, 24, 'qui consequatur quod', 'Quos dolorem et voluptates aspernatur aut nostrum sit aut.', 'active', '2025-06-30 01:51:37', '2026-01-26 05:52:49', 'Braedenborough', 14137.83, 305, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-9099', 'Stanton-Will', 'MDL-218', 'SN-58222', 2008, 'Plant', 'fixed', 'retired', '2024-01-12 09:54:08', 'km', 4813.52, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (85, 24, 'quod eos exercitationem', 'Eum ut corporis expedita aut assumenda.', 'inactive', '2025-05-25 06:08:21', '2026-05-09 18:20:51', 'Mooremouth', 32007.47, 124, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-5810', 'Cormier, Reichert and Kessler', 'MDL-793', 'SN-54715', 1999, 'Truck', 'tool', 'retired', '2023-05-21 03:42:28', 'hours', 3226.14, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (86, 24, 'rerum in suscipit', 'Nisi ea distinctio quia.', 'active', '2025-08-31 06:58:17', '2026-08-28 06:54:56', 'Port Tyree', 29677.77, 220, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-7501', 'Raynor-Keeling', 'MDL-493', 'SN-68813', 1991, 'Crusher', 'fixed', 'active', '2021-09-04 23:01:01', 'km', 2646.46, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (87, 24, 'repellendus molestiae quasi', 'Sapiente voluptatem sequi dolore vitae est occaecati sunt neque.', 'active', '2024-12-20 22:16:41', '2027-12-19 20:13:03', 'Lake Odell', 35024.99, 58, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-0094', 'Sporer, Mosciski and Fahey', 'MDL-637', 'SN-70908', 2005, 'Crusher', 'fixed', 'down', '2024-09-06 19:55:51', 'hours', 3175.12, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (88, 24, 'consequatur excepturi sit', 'Nam quis neque commodi quidem nihil similique.', 'inactive', '2024-02-08 00:11:54', '2027-12-19 21:01:47', 'Tristonborough', 43200.47, 371, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-5803', 'Corwin, Conroy and Bogan', 'MDL-850', 'SN-08420', 1998, 'Truck', 'tool', 'standby', '2023-11-03 12:14:06', 'hours', 1839.45, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (89, 24, 'eius sint odio', 'Autem fugit cupiditate alias debitis adipisci eligendi nemo enim.', 'inactive', '2025-03-21 11:08:46', '2026-03-28 12:20:18', 'North Meda', 17958.29, 80, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-1314', 'Pouros, Cummings and Rolfson', 'MDL-694', 'SN-67459', 2001, 'Loader', 'mobile', 'active', '2024-10-24 14:58:00', 'km', 4400.54, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (90, 24, 'suscipit aut id', 'Id minima accusantium repudiandae est eveniet omnis sunt.', 'active', '2024-03-15 23:31:06', '2026-12-19 10:01:37', 'Lake Sheila', 15832.81, 338, '2026-01-11 14:10:55', '2026-01-11 14:10:55', NULL, 'AST-8464', 'Ruecker-Leannon', 'MDL-186', 'SN-46457', 1987, 'Truck', 'vehicle', 'standby', '2022-09-08 06:45:01', 'km', 923.68, 13, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (91, 25, 'doloribus natus quas', 'Delectus libero ratione eos aut.', 'active', '2025-03-11 15:56:01', '2027-04-05 05:23:37', 'Shieldsbury', 39410.09, 253, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-2531', 'Collins PLC', 'MDL-376', 'SN-09721', 2009, 'Truck', 'vehicle', 'down', '2022-12-29 07:00:43', 'hours', 4717.2, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (92, 25, 'nostrum quia nihil', 'Voluptate voluptates quibusdam similique velit tenetur distinctio veritatis accusantium.', 'active', '2024-05-15 19:38:33', '2026-11-19 22:14:47', 'Schillermouth', 38580.46, 409, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-5739', 'Kunde, Muller and Crist', 'MDL-528', 'SN-01559', 1987, 'Plant', 'tool', 'down', '2024-02-19 22:03:04', 'km', 1335.23, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (93, 25, 'necessitatibus in placeat', 'Necessitatibus sed mollitia itaque et placeat at.', 'inactive', '2024-02-17 22:46:02', '2027-08-07 01:33:11', 'North Idaberg', 15756.95, 494, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-4054', 'Rempel, Conroy and Emard', 'MDL-773', 'SN-95290', 1992, 'Plant', 'mobile', 'active', '2024-10-14 07:54:47', 'hours', 3638.12, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (94, 25, 'tempore nam ex', 'Quod esse cum et alias libero.', 'active', '2025-11-15 10:47:05', '2026-01-25 21:24:51', 'Zboncakshire', 6343.03, 99, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-1925', 'Lemke Inc', 'MDL-264', 'SN-06804', 2015, 'Loader', 'fixed', 'standby', '2021-10-16 13:30:37', 'hours', 386.54, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (95, 25, 'maiores tempora consequuntur', 'Esse nam natus quam qui sed est possimus.', 'inactive', '2025-01-26 10:07:41', '2026-07-05 21:41:09', 'Port Mckennaberg', 33556.76, 357, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-1236', 'Ward, Pollich and Osinski', 'MDL-383', 'SN-00177', 2018, 'Plant', 'fixed', 'active', '2021-03-23 20:43:40', 'hours', 482.39, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (96, 25, 'dolor consequatur at', 'Inventore incidunt nam corporis porro magnam.', 'active', '2024-06-05 03:58:21', '2026-01-15 05:22:14', 'Langside', 1116.02, 147, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-0227', 'Bartell Group', 'MDL-298', 'SN-14059', 1981, 'Crusher', 'vehicle', 'down', '2021-09-21 16:24:19', 'hours', 1472.49, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (97, 25, 'totam exercitationem placeat', 'Dolorum occaecati ab ut excepturi nisi omnis nemo.', 'active', '2025-03-25 12:02:49', '2027-12-08 04:45:37', 'New Leta', 41415.55, 61, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-4959', 'Schaden-Bechtelar', 'MDL-339', 'SN-62621', 1992, 'Plant', 'mobile', 'retired', '2023-04-06 15:43:02', 'hours', 2435.81, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (98, 25, 'dolorem architecto qui', 'Doloremque vitae neque perferendis occaecati nisi excepturi itaque.', 'inactive', '2025-10-23 18:55:14', '2027-09-15 10:57:50', 'East Ryder', 37021.87, 430, '2026-01-11 14:10:56', '2026-01-11 14:10:56', NULL, 'AST-4535', 'Little-Donnelly', 'MDL-702', 'SN-21326', 2025, 'Loader', 'tool', 'active', '2022-08-18 10:59:49', 'km', 1755.14, 16, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (99, 26, 'molestiae fuga minima', 'Officiis expedita veritatis similique est deleniti ex debitis.', 'active', '2024-11-28 18:49:22', '2027-08-29 16:00:08', 'Dasiaville', 45288.17, 424, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-3845', 'Renner-Kreiger', 'MDL-680', 'SN-59299', 2020, 'Loader', 'tool', 'active', '2021-05-07 08:56:35', 'hours', 1363.13, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (100, 26, 'doloribus quo fugiat', 'Alias qui possimus iusto harum aliquam.', 'active', '2025-12-06 12:29:53', '2027-04-19 05:03:43', 'Lake Ceciliaborough', 35035.56, 475, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-6687', 'Boyle, Rutherford and Feeney', 'MDL-476', 'SN-49384', 1995, 'Crusher', 'fixed', 'standby', '2021-12-19 09:32:28', 'hours', 4479.22, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (101, 26, 'unde provident repudiandae', 'Quasi ad aliquam esse ut quam aut est.', 'active', '2024-06-24 07:48:35', '2026-07-25 10:43:06', 'Juniormouth', 16577.84, 126, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-8922', 'Pagac, Gaylord and Smith', 'MDL-720', 'SN-49572', 1981, 'Truck', 'mobile', 'standby', '2024-04-27 10:28:25', 'hours', 4069.83, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (102, 26, 'delectus et et', 'Odio nihil eos nemo.', 'active', '2025-10-16 06:45:54', '2026-03-29 19:52:14', 'South Royberg', 17645.16, 330, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-4961', 'Thompson, Cummerata and Dicki', 'MDL-394', 'SN-95611', 2019, 'Plant', 'tool', 'down', '2023-09-02 17:22:10', 'hours', 2563.79, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (103, 26, 'culpa officiis autem', 'Voluptate et maiores et veritatis.', 'active', '2024-04-03 01:41:39', '2026-06-21 21:58:42', 'East Bernard', 32920.87, 171, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-9718', 'Deckow, Stamm and Schiller', 'MDL-184', 'SN-38250', 1984, 'Loader', 'fixed', 'active', '2022-08-31 11:55:14', 'km', 3410.19, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (104, 26, 'quidem natus voluptas', 'Laudantium totam omnis officiis sint voluptas eos cum nulla.', 'active', '2024-05-03 22:30:54', '2027-10-16 02:38:11', 'East Meaghanburgh', 28768.34, 343, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-0110', 'Gaylord-Bauch', 'MDL-082', 'SN-50407', 1987, 'Genset', 'tool', 'down', '2024-10-01 09:43:38', 'km', 1940.68, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (105, 26, 'dolores ut molestias', 'Hic voluptas quia culpa.', 'active', '2024-12-01 13:43:25', '2026-11-18 20:59:19', 'Kennedymouth', 47322.95, 320, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-3572', 'Hills Ltd', 'MDL-052', 'SN-85332', 1974, 'Truck', 'tool', 'standby', '2022-01-03 14:06:16', 'hours', 113.15, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (106, 26, 'nulla dolores officiis', 'Iure consequatur asperiores quo soluta dicta.', 'active', '2024-02-14 09:29:51', '2026-02-14 22:03:23', 'Port Archton', 49588.79, 347, '2026-01-11 14:10:57', '2026-01-11 14:10:57', NULL, 'AST-4791', 'Goodwin-Turner', 'MDL-013', 'SN-29887', 1998, 'Crusher', 'tool', 'down', '2023-04-16 14:06:05', 'km', 406.61, 19, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (107, 27, 'repellendus et at', 'Nulla reiciendis rerum et voluptatum quia numquam nobis.', 'active', '2024-02-28 10:19:02', '2027-07-05 14:02:43', 'Port Cornelius', 47096.92, 237, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-0602', 'Dicki, Rice and Wuckert', 'MDL-616', 'SN-34712', 2014, 'Plant', 'vehicle', 'down', '2023-11-20 05:09:29', 'km', 1598.17, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (108, 27, 'ea facilis quia', 'Aut quia hic dolore itaque suscipit.', 'inactive', '2025-06-27 12:41:21', '2026-04-16 10:47:01', 'New Annamarie', 46887.65, 382, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-8696', 'Flatley-Hodkiewicz', 'MDL-652', 'SN-57235', 1989, 'Plant', 'vehicle', 'down', '2024-02-03 09:53:55', 'km', 3214.88, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (109, 27, 'voluptatem porro esse', 'Quo numquam et ducimus distinctio sapiente et molestiae.', 'inactive', '2024-05-17 10:11:37', '2026-08-14 21:05:04', 'East Bette', 48262.01, 470, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-8673', 'Wolf LLC', 'MDL-316', 'SN-82162', 2022, 'Genset', 'mobile', 'standby', '2023-05-19 07:50:07', 'hours', 3716.24, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (110, 27, 'maiores aut corrupti', 'Rem unde architecto totam praesentium ipsum quas.', 'inactive', '2025-06-25 18:24:05', '2026-01-14 04:06:24', 'Bartonside', 48464.85, 225, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-6559', 'Runte PLC', 'MDL-472', 'SN-21704', 1988, 'Truck', 'tool', 'active', '2024-03-19 19:10:16', 'hours', 4907.42, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (111, 27, 'aut ducimus veniam', 'Voluptatibus aspernatur similique quia sit.', 'inactive', '2025-07-07 11:01:28', '2027-11-02 23:08:13', 'East Cesar', 34469.93, 424, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-2487', 'Grimes PLC', 'MDL-119', 'SN-19804', 1996, 'Genset', 'tool', 'active', '2023-01-01 23:52:02', 'hours', 837.75, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (112, 27, 'non quod quo', 'Mollitia sit reiciendis sit praesentium earum temporibus.', 'active', '2024-07-22 05:23:03', '2026-02-20 02:45:31', 'Darrickshire', 4358.56, 169, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-2289', 'Kiehn Inc', 'MDL-224', 'SN-39792', 1982, 'Loader', 'fixed', 'active', '2021-05-26 21:18:22', 'hours', 2094.6, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (113, 27, 'sit molestiae eius', 'Quisquam qui architecto dolor nesciunt quibusdam.', 'active', '2025-12-13 18:10:05', '2027-03-13 09:19:12', 'Cristobalville', 21327.88, 192, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-5674', 'Botsford-Kuhlman', 'MDL-555', 'SN-38349', 1997, 'Genset', 'vehicle', 'down', '2022-08-31 05:53:12', 'hours', 1878.43, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (114, 27, 'animi pariatur incidunt', 'Autem ut ab impedit eos harum.', 'active', '2025-12-28 10:46:19', '2026-02-02 01:53:33', 'Barneyborough', 24108.28, 391, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-0903', 'Little Group', 'MDL-625', 'SN-66391', 2013, 'Plant', 'fixed', 'active', '2022-12-10 16:51:03', 'hours', 493.37, 24, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (115, 28, 'adipisci ut amet', 'Adipisci blanditiis quam autem autem neque.', 'active', '2025-03-15 04:31:01', '2027-12-09 17:38:39', 'Davonteport', 34901.57, 226, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-1577', 'Lang PLC', 'MDL-816', 'SN-15961', 2022, 'Genset', 'vehicle', 'retired', '2024-11-06 19:32:12', 'hours', 191.44, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (116, 28, 'aliquid maxime autem', 'Necessitatibus et adipisci in occaecati.', 'inactive', '2026-01-01 09:24:50', '2026-03-27 06:01:18', 'Aufderharchester', 6465.38, 446, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-5292', 'Hauck LLC', 'MDL-322', 'SN-06187', 1977, 'Plant', 'mobile', 'standby', '2021-08-06 15:05:05', 'hours', 3208.38, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (117, 28, 'itaque omnis sunt', 'Omnis qui delectus qui qui temporibus et voluptate.', 'inactive', '2025-01-15 23:53:40', '2026-05-10 19:51:34', 'Valentinaport', 43918.63, 453, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-7688', 'Strosin PLC', 'MDL-541', 'SN-84340', 2005, 'Loader', 'mobile', 'standby', '2023-10-10 11:47:40', 'km', 2905.58, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (118, 28, 'quis dignissimos ab', 'Quidem culpa est ut optio.', 'active', '2025-11-25 11:25:57', '2026-10-01 15:45:02', 'Purdyland', 3532, 153, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-7056', 'Hahn-Padberg', 'MDL-342', 'SN-17137', 1992, 'Plant', 'tool', 'down', '2024-12-13 03:59:13', 'km', 3672.56, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (119, 28, 'omnis sit quod', 'Ut dolorem voluptatem modi nobis reiciendis quidem qui.', 'active', '2025-03-21 23:17:20', '2027-02-15 03:15:34', 'West Sigmundmouth', 46829.6, 438, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-3820', 'Bradtke-Kshlerin', 'MDL-890', 'SN-68239', 2022, 'Crusher', 'tool', 'down', '2022-01-12 11:52:18', 'km', 3603.97, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (120, 28, 'aut et beatae', 'Quasi iste qui sed delectus tempora nesciunt.', 'inactive', '2025-08-12 15:26:18', '2026-07-09 21:52:19', 'Schmidtfort', 24679.96, 131, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-5473', 'Collier, Von and Williamson', 'MDL-324', 'SN-50240', 2011, 'Truck', 'mobile', 'down', '2021-07-31 16:36:10', 'km', 2086.35, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (121, 28, 'sed aliquam voluptas', 'Et voluptate iusto ex minima eaque similique.', 'active', '2025-03-03 13:49:13', '2026-07-15 11:28:01', 'Rathmouth', 8972.13, 193, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-6201', 'Schoen, Nikolaus and Schaden', 'MDL-235', 'SN-65320', 1989, 'Plant', 'vehicle', 'active', '2022-11-15 15:59:35', 'km', 4569.74, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (122, 28, 'qui veniam assumenda', 'Fuga ut aut ratione non fuga itaque.', 'inactive', '2025-02-11 05:59:44', '2027-12-31 14:56:49', 'North Pietroport', 16079.56, 243, '2026-01-11 14:10:58', '2026-01-11 14:10:58', NULL, 'AST-3669', 'Towne-Feeney', 'MDL-901', 'SN-99336', 2004, 'Truck', 'fixed', 'down', '2021-03-08 10:10:01', 'hours', 2929.2, 26, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (123, 29, 'pariatur dolorum corporis', 'Sed debitis sed id ut incidunt.', 'active', '2024-12-13 09:42:59', '2026-03-29 15:05:19', 'New Drewmouth', 21085.88, 146, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-2166', 'Paucek PLC', 'MDL-753', 'SN-82901', 1982, 'Truck', 'vehicle', 'standby', '2021-05-03 18:44:22', 'hours', 4595.89, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (124, 29, 'dolores unde quia', 'Consectetur quisquam sunt qui aut quidem voluptate voluptas.', 'active', '2024-04-27 06:24:04', '2027-09-18 23:14:21', 'Lake Shawn', 3550.99, 108, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-9250', 'Miller, Gaylord and Fahey', 'MDL-294', 'SN-52183', 1999, 'Loader', 'mobile', 'down', '2024-01-29 10:15:30', 'hours', 2751.7, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (125, 29, 'quod labore tempore', 'Voluptatem et ut totam dolor alias nemo.', 'active', '2025-11-17 06:41:10', '2026-02-11 05:40:19', 'Port Lula', 16063.31, 197, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-4729', 'Medhurst-Stracke', 'MDL-718', 'SN-52244', 2018, 'Loader', 'tool', 'retired', '2022-05-22 22:31:57', 'km', 1527.46, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (126, 29, 'et ullam enim', 'Voluptas repudiandae quae et est.', 'active', '2025-08-28 13:00:55', '2027-01-16 11:42:20', 'North Jamarcus', 43082.75, 341, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-5338', 'Wolff, Hilpert and Stehr', 'MDL-455', 'SN-00470', 2001, 'Truck', 'mobile', 'down', '2024-03-09 03:51:08', 'km', 4026.59, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (127, 29, 'reprehenderit placeat laudantium', 'Iusto laudantium praesentium placeat eveniet excepturi.', 'active', '2025-11-05 04:08:46', '2027-06-19 14:25:06', 'Brionnabury', 14526.7, 67, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-1692', 'Hammes and Sons', 'MDL-045', 'SN-74961', 2016, 'Genset', 'mobile', 'retired', '2021-01-26 15:49:17', 'km', 2485.16, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (128, 29, 'magni est aut', 'Modi est numquam iusto nihil magnam dolores distinctio expedita.', 'active', '2025-01-20 01:30:51', '2027-12-26 00:32:53', 'Port Elwin', 19219.28, 499, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-0255', 'Mills and Sons', 'MDL-547', 'SN-90552', 1970, 'Loader', 'vehicle', 'active', '2024-06-20 08:01:01', 'hours', 4109.12, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (129, 29, 'nulla ut nihil', 'Sunt minus dolore assumenda aut dolorem nostrum.', 'active', '2024-11-20 13:54:43', '2027-02-23 17:38:38', 'Christiansenburgh', 29889.09, 132, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-5137', 'Little-Bednar', 'MDL-799', 'SN-14848', 2000, 'Genset', 'vehicle', 'active', '2024-08-20 09:00:26', 'km', 2643.58, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (130, 29, 'totam enim sint', 'Placeat sint minima nihil voluptatum.', 'active', '2025-12-18 00:03:31', '2026-03-08 11:45:45', 'East Demetriusmouth', 43597.97, 219, '2026-01-11 14:10:59', '2026-01-11 14:10:59', NULL, 'AST-3992', 'Schimmel PLC', 'MDL-386', 'SN-23348', 2005, 'Plant', 'mobile', 'standby', '2024-08-11 23:43:15', 'km', 2088.17, 28, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (131, 30, 'beatae molestiae officiis', 'Dolor quod corrupti ipsam porro quis et eius earum.', 'inactive', '2025-12-21 14:20:30', '2027-12-28 20:18:18', 'North Eladio', 41339.98, 465, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-8511', 'Ullrich Inc', 'MDL-544', 'SN-60742', 1999, 'Truck', 'mobile', 'down', '2021-03-14 18:55:27', 'hours', 3028.15, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (132, 30, 'enim et quis', 'Tenetur est voluptate non est magni optio aperiam.', 'inactive', '2025-06-22 03:35:59', '2026-10-30 02:24:34', 'West Enos', 6659.96, 370, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-0839', 'Schumm Group', 'MDL-029', 'SN-40018', 1975, 'Truck', 'tool', 'active', '2022-12-19 02:43:32', 'hours', 475.76, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (133, 30, 'cumque quisquam quaerat', 'Omnis veniam autem qui quia.', 'inactive', '2025-07-23 18:03:02', '2026-01-15 22:35:08', 'Veumbury', 39391.97, 178, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-0523', 'Russel, Deckow and Lueilwitz', 'MDL-551', 'SN-90158', 2013, 'Plant', 'vehicle', 'retired', '2024-07-22 19:58:34', 'hours', 4308.07, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (134, 30, 'qui quaerat quia', 'Quasi dolor non dicta laboriosam enim dolor iure.', 'active', '2025-04-27 20:56:38', '2027-10-24 22:35:45', 'Carrollborough', 49100.23, 280, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-8451', 'Bailey-Lemke', 'MDL-869', 'SN-40699', 1996, 'Loader', 'fixed', 'standby', '2022-09-29 13:13:50', 'km', 3023.5, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (135, 30, 'voluptatem et totam', 'Vel rerum veniam tempora.', 'inactive', '2025-01-17 05:28:37', '2026-10-30 15:39:57', 'New Jaydenbury', 33555.27, 227, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-8013', 'Keeling Inc', 'MDL-100', 'SN-46976', 2004, 'Genset', 'vehicle', 'retired', '2021-11-09 12:11:40', 'km', 1882.06, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (136, 30, 'aut molestiae sed', 'Voluptatem rerum repudiandae ut ipsam corporis ut labore.', 'inactive', '2024-07-12 16:41:01', '2026-04-12 10:19:42', 'Port Elvieborough', 44302.61, 290, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-1604', 'Goldner-Grady', 'MDL-501', 'SN-83191', 1999, 'Crusher', 'vehicle', 'standby', '2022-10-20 10:35:58', 'hours', 2072.25, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (137, 30, 'voluptas perspiciatis quia', 'Nisi fuga et expedita quasi est ut veniam est.', 'inactive', '2024-08-15 10:11:47', '2026-10-11 09:19:45', 'Lake Einar', 48360.08, 349, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-3546', 'Schaden-Hessel', 'MDL-956', 'SN-95046', 1995, 'Truck', 'mobile', 'down', '2023-03-08 21:20:49', 'km', 4280.92, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (138, 30, 'dolorum ipsam hic', 'Voluptatem minima soluta dignissimos repudiandae modi praesentium.', 'active', '2024-01-31 00:40:29', '2027-02-14 23:19:59', 'Nestorland', 29163.38, 66, '2026-01-11 14:11:00', '2026-01-11 14:11:00', NULL, 'AST-5332', 'Hyatt Group', 'MDL-168', 'SN-71579', 1977, 'Plant', 'mobile', 'retired', '2024-03-14 04:42:07', 'hours', 4400.4, 31, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (139, 31, 'Excavator EX-12', 'Mobile Plant asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:11', '2027-01-13 20:11:11', 'Fourways Quarry', 1240000, 250, '2026-01-13 20:11:11', '2026-01-13 20:11:11', NULL, 'EX-12', 'Caterpillar', '320D', 'SN-EX12', 2018, 'Mobile Plant', 'mobile', 'active', '2021-01-13 20:11:11', 'hours', 4820, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (140, 31, 'Excavator EX-09', 'Mobile Plant asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:11', '2027-01-13 20:11:11', 'Fourways Quarry', 980000, 250, '2026-01-13 20:11:11', '2026-01-13 20:11:11', NULL, 'EX-09', 'Komatsu', 'PC210', 'SN-EX09', 2017, 'Mobile Plant', 'mobile', 'active', '2021-01-13 20:11:11', 'hours', 5160, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (141, 31, 'Loader L-07', 'Mobile Plant asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:11', '2027-01-13 20:11:11', 'Fourways Quarry', 880000, 200, '2026-01-13 20:11:11', '2026-01-13 20:11:11', NULL, 'L-07', 'Volvo', 'L120H', 'SN-L07', 2019, 'Mobile Plant', 'mobile', 'active', '2021-01-13 20:11:11', 'hours', 3920, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (142, 31, 'Dozer D-04', 'Mobile Plant asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:11', '2027-01-13 20:11:11', 'Fourways Quarry', 740000, 200, '2026-01-13 20:11:11', '2026-01-13 20:11:11', NULL, 'D-04', 'Caterpillar', 'D6T', 'SN-D04', 2016, 'Mobile Plant', 'mobile', 'active', '2021-01-13 20:11:11', 'hours', 6200, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (143, 31, 'Grader GR-02', 'Mobile Plant asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:11', '2027-01-13 20:11:11', 'Fourways Quarry', 690000, 250, '2026-01-13 20:11:11', '2026-01-13 20:11:11', NULL, 'GR-02', 'John Deere', '770G', 'SN-GR02', 2018, 'Mobile Plant', 'mobile', 'active', '2021-01-13 20:11:11', 'hours', 4100, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (144, 31, 'Drill Rig DR-01', 'Mobile Plant asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:11', '2027-01-13 20:11:11', 'Fourways Quarry', 1320000, 200, '2026-01-13 20:11:11', '2026-01-13 20:11:11', NULL, 'DR-01', 'Sandvik', 'DP1100i', 'SN-DR01', 2020, 'Mobile Plant', 'mobile', 'active', '2021-01-13 20:11:11', 'hours', 1880, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (145, 31, 'Hauler H-44', 'Truck asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Fourways Quarry', 1750000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'H-44', 'Caterpillar', '777G', 'SN-H44', 2019, 'Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'hours', 3600, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (146, 31, 'Hauler H-32', 'Truck asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Fourways Quarry', 1620000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'H-32', 'Komatsu', 'HD325', 'SN-H32', 2017, 'Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'hours', 4480, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (147, 31, 'Water Bowser WB-03', 'Support Truck asset operating at Fourways Quarry', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Fourways Quarry', 320000, 150, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'WB-03', 'Hino', 500, 'SN-WB03', 2020, 'Support Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'km', 68220, 34, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (148, 31, 'Primary Crusher CR-01', 'Crushing Plant asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 2100000, 300, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'CR-01', 'Metso', 'C120', 'SN-CR01', 2018, 'Crushing Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 6400, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (149, 31, 'Secondary Crusher CR-02', 'Crushing Plant asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 1800000, 300, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'CR-02', 'Sandvik', 'CH440', 'SN-CR02', 2018, 'Crushing Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 5980, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (150, 31, 'Screen SC-01', 'Crushing Plant asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 820000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'SC-01', 'Terex', 'TSW2060', 'SN-SC01', 2019, 'Crushing Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 4320, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (151, 31, 'Conveyor CV-03', 'Crushing Plant asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 410000, 300, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'CV-03', 'Superior', '36x80', 'SN-CV03', 2017, 'Crushing Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 7200, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (152, 31, 'Feeder FD-01', 'Crushing Plant asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 460000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'FD-01', 'Telsmith', 'H3248', 'SN-FD01', 2018, 'Crushing Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 5010, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (153, 31, 'Stacker ST-02', 'Crushing Plant asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 620000, 200, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'ST-02', 'McCloskey', 'TS4080', 'SN-ST02', 2021, 'Crushing Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 1880, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (154, 31, 'Generator GEN-200', 'Generator asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 180000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'GEN-200', 'Cummins', 'C200', 'SN-GEN200', 2019, 'Generator', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 3120, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (155, 31, 'Generator GEN-110', 'Generator asset operating at Crushing Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Crushing Plant', 140000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'GEN-110', 'Perkins', '1104C', 'SN-GEN110', 2018, 'Generator', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 2900, 35, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (156, 31, 'Batch Plant BP-01', 'Concrete Plant asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 1600000, 300, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'BP-01', 'Liebherr', 'Betomix', 'SN-BP01', 2020, 'Concrete Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 2200, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (157, 31, 'Cement Silo CS-01', 'Concrete Plant asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 220000, 300, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'CS-01', 'SiloPro', 'CS50', 'SN-CS01', 2020, 'Concrete Plant', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 1400, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (158, 31, 'Mixer Truck MT-04', 'Truck asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 520000, 150, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'MT-04', 'Mercedes', 'Arocs', 'SN-MT04', 2019, 'Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'km', 82000, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (159, 31, 'Mixer Truck MT-09', 'Truck asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 490000, 150, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'MT-09', 'Volvo', 'FMX', 'SN-MT09', 2018, 'Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'km', 91000, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (160, 31, 'Tipper TP-12', 'Truck asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 380000, 150, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'TP-12', 'Scania', 'P410', 'SN-TP12', 2017, 'Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'km', 120000, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (161, 31, 'Tipper TP-24', 'Truck asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 410000, 150, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'TP-24', 'MAN', 'TGS', 'SN-TP24', 2019, 'Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'km', 98000, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (162, 31, 'Concrete Pump CP-01', 'Concrete Plant asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 780000, 200, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'CP-01', 'Putzmeister', 'M42', 'SN-CP01', 2021, 'Concrete Plant', 'mobile', 'active', '2021-01-13 20:11:12', 'hours', 980, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (163, 31, 'Generator GEN-075', 'Generator asset operating at Concrete Plant', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Concrete Plant', 120000, 250, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'GEN-075', 'Cummins', 'C75', 'SN-GEN075', 2020, 'Generator', 'fixed', 'active', '2021-01-13 20:11:12', 'hours', 1600, 36, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (164, 31, 'Service Truck ST-06', 'Support Truck asset operating at Central Workshop', 'active', '2020-01-13 20:11:12', '2027-01-13 20:11:12', 'Central Workshop', 210000, 150, '2026-01-13 20:11:12', '2026-01-13 20:11:12', NULL, 'ST-06', 'Isuzu', 'N-Series', 'SN-ST06', 2018, 'Support Truck', 'vehicle', 'active', '2021-01-13 20:11:12', 'km', 76000, 37, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (165, 31, 'AGJ 0885 M07 Mixer Truck', 'AGJ 0885 M07 Mixer Truck', 'active', '2023-06-30 00:00:00', NULL, '4083/SUNW/SLDT', 83890.1, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0001', NULL, 'Mixer Truck', 'AGJ 0885', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (166, 31, 'AGB 1219 M01 FAW', 'AGB 1219 M01 FAW', 'active', '2023-02-28 00:00:00', NULL, '4083/SUNW/SLDT', 88141.36, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0002', NULL, NULL, 'AGB 1219', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (167, 31, 'AFQ 8368 M02 FAW', 'AFQ 8368 M02 FAW', 'active', '2023-02-28 00:00:00', NULL, '4083/SUNW/SLDT', 88141.36, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0003', NULL, 'Mixer Truck', 'AFQ 8368', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (168, 31, 'AFJ0355 M09 FUSO Mixer Truck (AFX 9668 Ford Ranger Wildtrack)', 'AFJ0355 M09 FUSO Mixer Truck (AFX 9668 Ford Ranger Wildtrack)', 'active', '2022-10-31 00:00:00', NULL, '4083/SUNW/SLDT', 44353.27, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0004', NULL, NULL, 'AFJ 0355', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (169, 31, 'AFQ 5127 M15 Faw', 'AFQ 5127 M15 Faw', 'active', '2022-08-31 00:00:00', NULL, '4083/SUNW/SLDT', 87254.89, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0005', NULL, 'Mixer Truck', 'AFQ 5127', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (170, 31, 'AFQ 5126 M16 Faw', 'AFQ 5126 M16 Faw', 'active', '2022-08-31 00:00:00', NULL, '4083/SUNW/SLDT', 87254.89, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0006', NULL, 'Mixer Truck', 'AFQ 5126', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (171, 31, 'AFQ 5100 M14 Faw', 'AFQ 5100 M14 Faw', 'active', '2022-08-31 00:00:00', NULL, '4083/SUNW/SLDT', 87254.89, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0007', NULL, 'Mixer Truck', 'AFQ 5100', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (172, 31, 'AFQ 2272 M13 Powerstar', 'AFQ 2272 M13 Powerstar', 'active', '2022-02-28 00:00:00', NULL, '4083/SUNW/SLDT', 53528.2, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0008', NULL, NULL, 'AFQ 2272', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (173, 31, 'AFJ9910 M08 Powerstar', 'AFJ9910 M08 Powerstar', 'active', '2021-09-01 00:00:00', NULL, '4083/SUNW/SLDT', 57364.151773533, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0009', NULL, NULL, 'AFJ 9910', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (174, 31, 'AEX0917 Nissan NP300', 'AEX0917 Nissan NP300', 'active', '2021-08-01 00:00:00', NULL, '4083/SUNW/SLDT', 15000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0010', NULL, NULL, 'AEX 0917', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (175, 31, 'AFJ 5645 M11 Howo', 'AFJ 5645 M11 Howo', 'active', '2021-08-01 00:00:00', NULL, '4083/SUNW/SLDT', 98550.690428571, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0011', NULL, 'Mixer Truck', 'AFJ 5645', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (176, 31, 'M04 FAW', 'M04 FAW', 'active', '2024-01-01 00:00:00', NULL, 5400, 97923.31, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0012', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 44, NULL, NULL, '5400 | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (177, 31, 'M05 FAW', 'M05 FAW', 'active', '2024-01-01 00:00:00', NULL, 5400, 97923.31, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0013', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 44, NULL, NULL, '5400 | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (178, 31, 'AFT1988 Hino Dutro', 'AFT1988 Hino Dutro', 'active', '2022-01-06 00:00:00', NULL, 5400, 15500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0014', NULL, NULL, 'AFT 1988', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 44, NULL, NULL, '5400 | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (179, 31, 'AFJ0991 Man Tiper', 'AFJ0991 Man Tiper', 'active', '2020-10-01 00:00:00', NULL, '4083/SUNW/CONV', 96276.309, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0015', NULL, 'Tipper - Horse', 'AFJ 0991', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (180, 31, 'AEZ5851 Howo Tiper', 'AEZ5851 Howo Tiper', 'active', '2019-11-01 00:00:00', NULL, '4083/SUNW/CONV', 75613.300492611, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0016', NULL, 'Tipper', 'AEZ 5851', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (181, 31, 'LW300KN Loader Long Boom', 'LW300KN Loader Long Boom', 'active', '2021-05-31 00:00:00', NULL, '4083/SUNW/CONV', 50000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0017', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (182, 31, 'Liugong Loader', 'Liugong Loader', 'active', '2021-01-02 00:00:00', NULL, '4083/SUNW/CONV', 31331.679341251, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0018', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (183, 31, 'AGA 8820 Faw Dropside 8.140FL Dropside Truck', 'AGA 8820 Faw Dropside 8.140FL Dropside Truck', 'active', '2023-06-30 00:00:00', NULL, '4083/SUNW/CONV', 32205.3, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0019', NULL, 'Truck - D/SIDE WORKSHOP', 'AGA 8820', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (184, 31, 'AFQ 8084 Faw Dropside Truck 8 Series', 'AFQ 8084 Faw Dropside Truck 8 Series', 'active', '2022-08-31 00:00:00', NULL, '4083/SUNW/CONV', 27660.28, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0020', NULL, 'Truck - D/SIDE QUARRY', 'AFQ 8084', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (185, 31, 'AER 9165 ACE110 Honda Motor Bike', 'AER 9165 ACE110 Honda Motor Bike', 'active', '2022-07-04 00:00:00', NULL, '4083/SUNW/CONV', 1554.59, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0021', NULL, 'Motor Bike', 'AER 9165', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 45, NULL, NULL, '4083/SUNW/CONV | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (186, 31, 'AAY 5565 Concrete Static Pump', 'AAY 5565 Concrete Static Pump', 'active', '2023-06-30 00:00:00', NULL, '4083/SUNW/SLDT', 86425.53, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0022', NULL, 'Concrete Trailer Pump Static', 'AAY 5565', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (187, 31, 'AFQ 9824 Static Pump', 'AFQ 9824 Static Pump', 'active', '2022-10-31 00:00:00', NULL, '4083/SUNW/SLDT', 82837.19, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0023', NULL, NULL, 'AFQ 9824', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 43, NULL, NULL, '4083/SUNW/SLDT | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (188, 31, 'TOYOTA Hilux D/Cab', 'TOYOTA Hilux D/Cab', 'active', '2024-10-03 00:00:00', NULL, 8010, 44000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0024', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 46, NULL, NULL, '8010 | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (189, 31, 'TOYOTA Hilux S/Cab', 'TOYOTA Hilux S/Cab', 'active', '2024-04-30 00:00:00', NULL, '4083/HDOF/FINA', 35000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0025', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 47, NULL, NULL, '4083/HDOF/FINA | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (190, 31, 'Ford Ranger -AGE2431', 'Ford Ranger -AGE2431', 'active', '2024-01-03 00:00:00', NULL, '4083/HDOF/HQOF', 65000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0026', NULL, NULL, 'AGE 2431', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 48, NULL, NULL, '4083/HDOF/HQOF | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (191, 31, 'AGA 3744 Toyota Fortuner', 'AGA 3744 Toyota Fortuner', 'active', '2023-02-28 00:00:00', NULL, '4083/HDOF/FINA', 55808, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0027', 'Toyota Fortuner SUV', 'Toyota Fortuner SUV', 'AGA 3744', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 47, NULL, NULL, '4083/HDOF/FINA | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (192, 31, 'AGD 0019 Toyota Aqua', 'AGD 0019 Toyota Aqua', 'active', '2023-02-28 00:00:00', NULL, '4083/HDOF/FINA', 7550, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0028', 'Toyota Aqua', 'Toyota Aqua', 'AGD 0019', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 47, NULL, NULL, '4083/HDOF/FINA | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (193, 31, 'AFX 6240 Toyota Hilux Revo S/Cab', 'AFX 6240 Toyota Hilux Revo S/Cab', 'active', '2022-08-31 00:00:00', NULL, '4083/HDOF/CONV', 33901.78, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0029', NULL, 'S/cab Revo', 'AFX 6240', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 49, NULL, NULL, '4083/HDOF/CONV | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (194, 31, 'AEC 5171 S/Cab Ford Ranger', 'AEC 5171 S/Cab Ford Ranger', 'active', '2021-10-01 00:00:00', NULL, '4083/HDOF/CONV', 15000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0030', NULL, 'Ford Ranger XLT S/CAB', 'AEC 5171', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 49, NULL, NULL, '4083/HDOF/CONV | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (195, 31, 'AFN 6077 Ford Ranger', 'AFN 6077 Ford Ranger', 'active', '2021-08-01 00:00:00', NULL, '4083/HDOF/CONV', 45867.602857143, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0031', NULL, 'Ford Ranger Wildtrack 02', 'AFN 6077', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 49, NULL, NULL, '4083/HDOF/CONV | Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (196, 31, 'Shacman Mixer Truck', 'Shacman Mixer Truck', 'active', '2025-11-30 00:00:00', NULL, '4086/SUNW/HQOF', 111032.33, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0032', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, 50, NULL, NULL, '4086/SUNW/HQOF | Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (197, 31, 'TOTALS: MOTOR VEHICLES', 'TOTALS: MOTOR VEHICLES', 'active', NULL, NULL, NULL, 1899144.3138931, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0033', NULL, NULL, NULL, NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (198, 31, 'Ablution Container', 'Ablution Container', 'active', '2018-09-26 00:00:00', NULL, 8010, 14500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0034', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 46, NULL, NULL, '8010 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (199, 31, 'Office Container 1', 'Office Container 1', 'active', '2018-09-26 00:00:00', NULL, 8010, 9500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0035', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 46, NULL, NULL, '8010 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (200, 31, 'Office Container 2', 'Office Container 2', 'active', '2018-09-26 00:00:00', NULL, 8010, 9500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0036', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 46, NULL, NULL, '8010 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (201, 31, 'Procurement Container', 'Procurement Container', 'active', '2018-10-24 00:00:00', NULL, '4085/SUNW/CONV', 11250, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0037', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (202, 31, 'Staff Quarters Container', 'Staff Quarters Container', 'active', '2018-10-24 00:00:00', NULL, '4085/SUNW/CONV', 11250, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0038', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (203, 31, 'Borehole', 'Borehole', 'active', '2019-06-12 00:00:00', NULL, '4085/SUNW/CONV', 3517.62, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0039', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (204, 31, '5000L Jumbo Water Tank 01', '5000L Jumbo Water Tank 01', 'active', '2019-07-01 00:00:00', NULL, '4085/SUNW/CONV', 436.68122270742, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0040', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (205, 31, 'Lab Equipment', 'Lab Equipment', 'active', '2019-07-15 00:00:00', NULL, '4085/SUNW/CONV', 1340.5018007853, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0041', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (206, 31, 'Generator P165-1/83807 100KVA 290257/002', 'Generator P165-1/83807 100KVA 290257/002', 'active', '2019-09-01 00:00:00', NULL, '4085/SUNW/CONV', 13000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0042', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (207, 31, '120 Tonne Cement Silo', '120 Tonne Cement Silo', 'active', '2019-11-01 00:00:00', NULL, 5400, 31670.311508382, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0043', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 44, NULL, NULL, '5400 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (208, 31, 'Karoo Batching Plant', 'Karoo Batching Plant', 'active', '2019-11-01 00:00:00', NULL, '4085/SUNW/CONV', 98113.622978723, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0044', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (209, 31, 'Fuel Tank  8000L', 'Fuel Tank  8000L', 'active', '2020-01-01 00:00:00', NULL, 8010, 6299.96, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0045', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 46, NULL, NULL, '8010 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (210, 31, 'Fuel Tank  15000L', 'Fuel Tank  15000L', 'active', '2020-01-01 00:00:00', NULL, '4085/SUNW/CONV', 10000, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0046', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (211, 31, 'Electricity Switch Box', 'Electricity Switch Box', 'active', '2020-01-31 00:00:00', NULL, '4085/SUNW/CONV', 1531.7073170732, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0047', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (212, 31, 'Karoo 60 Tonne Cement Silo', 'Karoo 60 Tonne Cement Silo', 'active', '2020-02-29 00:00:00', NULL, '4085/SUNW/CONV', 13604.4, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0048', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (213, 31, 'Plant Generator 294399/001', 'Plant Generator 294399/001', 'active', '2020-02-29 00:00:00', NULL, '4085/SUNW/CONV', 12500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0049', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (214, 31, '2 X 5000L Jumbo Water Tank 02-03', '2 X 5000L Jumbo Water Tank 02-03', 'active', '2020-03-10 00:00:00', NULL, '4085/SUNW/CONV', 843.40525, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0050', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (215, 31, 'Borehole Pump 1', 'Borehole Pump 1', 'active', '2020-03-23 00:00:00', NULL, '4085/SUNW/CONV', 1140, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0051', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (216, 31, 'Borehole 1', 'Borehole 1', 'active', '2020-03-25 00:00:00', NULL, '4085/SUNW/CONV', 4900, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0052', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (217, 31, '2 X 10 000L Larmasat Water Tank 01-02', '2 X 10 000L Larmasat Water Tank 01-02', 'active', '2020-03-26 00:00:00', NULL, '4085/SUNW/CONV', 1453.587, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0053', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (218, 31, 'Borehole Pump 2', 'Borehole Pump 2', 'active', '2020-03-26 00:00:00', NULL, '4085/SUNW/CONV', 2643.719, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0054', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (219, 31, '10000l Lamasat Water Tank 03-08', '10000l Lamasat Water Tank 03-08', 'active', '2020-06-10 00:00:00', NULL, '4085/SUNW/CONV', 5580, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0055', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (220, 31, 'Container - Office And Storage', 'Container - Office And Storage', 'active', '2020-06-30 00:00:00', NULL, '4085/SUNW/CONV', 345, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0056', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (221, 31, 'Karoo Plant 120 Cement Silo', 'Karoo Plant 120 Cement Silo', 'active', '2020-10-02 00:00:00', NULL, '4085/SUNW/CONV', 9347.83, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0057', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (222, 31, 'Borehole 2', 'Borehole 2', 'active', '2020-10-05 00:00:00', NULL, '4085/SUNW/CONV', 2400, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0058', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (223, 31, 'Water Pump And Accessories', 'Water Pump And Accessories', 'active', '2020-11-10 00:00:00', NULL, '4085/SUNW/CONV', 466, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0059', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (224, 31, 'Borehole Drilling And Fittings', 'Borehole Drilling And Fittings', 'active', '2020-11-19 00:00:00', NULL, '4085/SUNW/CONV', 12374.39, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0060', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (225, 31, 'Electrical cable Borehole', 'Electrical cable Borehole', 'active', '2021-01-11 00:00:00', NULL, '4085/SUNW/CONV', 4950, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0061', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (226, 31, 'Karoo Batch Plant', 'Karoo Batch Plant', 'active', '2021-01-20 00:00:00', NULL, 8010, 112997.93215727, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0062', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 46, NULL, NULL, '8010 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (227, 31, 'Aircon New Office Container', 'Aircon New Office Container', 'active', '2021-03-09 00:00:00', NULL, '4085/SUNW/CONV', 785, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0063', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (228, 31, 'Fire Extiquishers', 'Fire Extiquishers', 'active', '2021-03-17 00:00:00', NULL, '4085/SUNW/CONV', 70, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0064', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (229, 31, 'Test Scales 20kg*10', 'Test Scales 20kg*10', 'active', '2021-04-30 00:00:00', NULL, '4085/SUNW/CONV', 485.02139800285, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0065', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (230, 31, 'Mobile Batching Plant', 'Mobile Batching Plant', 'active', '2021-05-31 00:00:00', NULL, '4085/HDOF/CONV', 17300, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0066', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 52, NULL, NULL, '4085/HDOF/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (231, 31, 'Mobile Batching Plant', 'Mobile Batching Plant', 'active', '2021-06-29 00:00:00', NULL, '4085/HDOF/CONV', 150, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0067', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 52, NULL, NULL, '4085/HDOF/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (232, 31, 'Karoo Batch Plant', 'Karoo Batch Plant', 'active', '2021-08-31 00:00:00', NULL, 5400, 127100.54, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0068', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 44, NULL, NULL, '5400 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (233, 31, 'Container Office Sunway City', 'Container Office Sunway City', 'active', '2021-08-31 00:00:00', NULL, '4085/SUNW/CONV', 7368, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0069', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (234, 31, 'Container Office Zimplats', 'Container Office Zimplats', 'active', '2021-08-31 00:00:00', NULL, '4085/SUNW/CONV', 12185.570666667, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0070', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (235, 31, '40FT Container', '40FT Container', 'active', '2021-12-10 00:00:00', NULL, '4085/SUNW/CONV', 4500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0071', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (236, 31, 'Generator Tdg28Fs3 25Kva', 'Generator Tdg28Fs3 25Kva', 'active', '2021-12-17 00:00:00', NULL, '4085/SUNW/CONV', 6113.54, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0072', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (237, 31, '40Ft Container', '40Ft Container', 'active', '2022-01-26 00:00:00', NULL, '4085/SUNW/CONV', 5100, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0073', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (238, 31, '3M Tank Stand For 10000L', '3M Tank Stand For 10000L', 'active', '2022-03-04 00:00:00', NULL, '4085/SUNW/CONV', 500, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0074', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (239, 31, '5000L  Water Tank', '5000L  Water Tank', 'active', '2022-03-31 00:00:00', NULL, '4085/SUNW/CONV', 350, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0075', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (240, 31, 'Borehole Sunway', 'Borehole Sunway', 'active', '2022-04-11 00:00:00', NULL, '4085/SUNW/CONV', 4454.15, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0076', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (241, 31, 'Generator 5Kv - Nexus', 'Generator 5Kv - Nexus', 'active', '2022-07-19 00:00:00', NULL, '4085/SUNW/CONV', 300, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0077', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (242, 31, '5Kv Generator - Tech Africa Tde6700S', '5Kv Generator - Tech Africa Tde6700S', 'active', '2022-07-26 00:00:00', NULL, '4085/SUNW/CONV', 1135.37, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0078', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (243, 31, '20Ft Container', '20Ft Container', 'active', '2022-09-23 00:00:00', NULL, '4085/SUNW/CONV', 3200, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0079', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (244, 31, 'Diesel Engine Air Compressor', 'Diesel Engine Air Compressor', 'active', '2023-01-31 00:00:00', NULL, '4085/SUNW/CONV', 3996.67, NULL, '2026-01-14 11:53:26', '2026-01-25 13:50:18', NULL, 'VR-0080', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (245, 31, 'Poker & Vibrator', 'Poker & Vibrator', 'active', '2023-01-31 00:00:00', NULL, '4085/SUNW/CONV', 637.55, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0081', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (246, 31, 'Crusher', 'Crusher', 'active', '2023-01-31 00:00:00', NULL, '4085/SUNW/CONV', 9429.98, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0082', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (247, 31, 'High Pressure Washer', 'High Pressure Washer', 'active', '2023-01-31 00:00:00', NULL, '4085/SUNW/CONV', 1677.41, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0083', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (248, 31, 'Damsack (Water Reservoir)', 'Damsack (Water Reservoir)', 'active', '2023-03-31 00:00:00', NULL, '4085/SUNW/CONV', 1760, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0084', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (249, 31, 'Generator Bundu', 'Generator Bundu', 'active', '2023-03-31 00:00:00', NULL, '4085/SUNW/CONV', 1874.4130769231, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0085', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (250, 31, 'Concrete Bucket', 'Concrete Bucket', 'active', '2023-04-30 00:00:00', NULL, '4085/SUNW/CONV', 6349.9, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0086', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (251, 31, '2 X 5000L Tanks', '2 X 5000L Tanks', 'active', '2023-06-30 00:00:00', NULL, '4085/SUNW/CONV', 1790.11, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0087', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (252, 31, 'Co2 Welding Machine', 'Co2 Welding Machine', 'active', '2023-07-19 00:00:00', NULL, '4085/SUNW/CONV', 800, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0088', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (253, 31, 'Aircon TCL 18 000BTU', 'Aircon TCL 18 000BTU', 'active', '2023-09-30 00:00:00', NULL, '4085/SUNW/CONV', 1522, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0089', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (254, 31, 'Container Office Sunway City FIN', 'Container Office Sunway City FIN', 'active', '2023-11-30 00:00:00', NULL, '4085/SUNW/CONV', 7372.36, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0090', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (255, 31, 'Borehole', 'Borehole', 'active', '2024-02-01 00:00:00', NULL, '4085/SUNW/CONV', 1916.14, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0091', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (256, 31, 'Compressor', 'Compressor', 'active', '2024-06-30 00:00:00', NULL, '4085/SUNW/CONV', 1848.37, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0092', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (257, 31, 'Concrete Hopper Sunway', 'Concrete Hopper Sunway', 'active', '2024-07-31 00:00:00', NULL, '4085/SUNW/CONV', 37741.315423729, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0093', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (258, 31, 'Generator Kunzvi Project', 'Generator Kunzvi Project', 'active', '2024-11-01 00:00:00', NULL, 5400, 16878, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0094', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 44, NULL, NULL, '5400 | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (259, 31, 'Generator Sunway', 'Generator Sunway', 'active', '2025-01-31 00:00:00', NULL, '4085/SUNW/CONV', 6950, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0095', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, 51, NULL, NULL, '4085/SUNW/CONV | Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (260, 31, 'Generator Muchekeranwa', 'Generator Muchekeranwa', 'active', '2025-11-13 00:00:00', NULL, NULL, 7800, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0096', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (261, 31, 'Generator', 'Generator', 'active', '2019-07-01 00:00:00', NULL, NULL, 1563.92, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0097', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (262, 31, 'Jack Hummer Hilti 01-03', 'Jack Hummer Hilti 01-03', 'active', '2020-04-30 00:00:00', NULL, NULL, 450, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0098', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (263, 31, 'Generators Solar Equipment', 'Generators Solar Equipment', 'active', '2020-10-01 00:00:00', NULL, NULL, 160, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0099', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (264, 31, 'Jack Hammer 03 - 04', 'Jack Hammer 03 - 04', 'active', '2021-06-14 00:00:00', NULL, NULL, 228, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0100', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (265, 31, 'Angle Irons Grid', 'Angle Irons Grid', 'active', '2021-06-16 00:00:00', NULL, NULL, 135, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0101', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (266, 31, 'Jack Hammer R1700W Total TH2 01- 02', 'Jack Hammer R1700W Total TH2 01- 02', 'active', '2021-09-15 00:00:00', NULL, NULL, 335.22, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0102', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (267, 31, '8Tonne Trolly Jack', '8Tonne Trolly Jack', 'active', '2021-09-25 00:00:00', NULL, NULL, 908.2, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0103', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (268, 31, 'Baby Grinder 1100W', 'Baby Grinder 1100W', 'active', '2022-01-11 00:00:00', NULL, NULL, 40, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0104', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (269, 31, 'Welding Machine', 'Welding Machine', 'active', '2022-01-11 00:00:00', NULL, NULL, 160, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0105', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (270, 31, 'Angle/Baby Grinder - Forge', 'Angle/Baby Grinder - Forge', 'active', '2022-03-20 00:00:00', NULL, NULL, 32.23, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0106', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (271, 31, 'Water Booster Pump 5000L', 'Water Booster Pump 5000L', 'active', '2022-03-31 00:00:00', NULL, NULL, 80, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0107', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (272, 31, 'Tarpaulin 9X18 01', 'Tarpaulin 9X18 01', 'active', '2022-04-08 00:00:00', NULL, NULL, 508.73, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0108', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (273, 31, 'Tarpaulin 9X19 02', 'Tarpaulin 9X19 02', 'active', '2022-04-08 00:00:00', NULL, NULL, 508.73, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0109', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (274, 31, 'Tarpaulin 9X20 03', 'Tarpaulin 9X20 03', 'active', '2022-04-08 00:00:00', NULL, NULL, 508.73, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0110', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (275, 31, 'Tarpaulin 9X21 04', 'Tarpaulin 9X21 04', 'active', '2022-04-08 00:00:00', NULL, NULL, 508.73, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0111', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (276, 31, 'Welding Machine Boss-600', 'Welding Machine Boss-600', 'active', '2022-08-01 00:00:00', NULL, NULL, 320, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0112', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (277, 31, 'TOTALS: PLANT AND EQUIPMENT', 'TOTALS: PLANT AND EQUIPMENT', 'active', NULL, NULL, NULL, 715345.56880026, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0113', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (278, 31, 'GRAND TOTAL', 'GRAND TOTAL', 'active', NULL, NULL, NULL, 2614489.8826934, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0114', NULL, NULL, NULL, NULL, 'Plant & Equipment', 'fixed', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (279, 31, 'AGL 4764 Mixer Truck', 'AGL 4764 Mixer Truck', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0115', NULL, 'Mixer Truck', 'AGL 4764', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (280, 31, 'AGL 2048 Mixer Truck', 'AGL 2048 Mixer Truck', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0116', NULL, 'Mixer Truck', 'AGL 2048', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (281, 31, 'AGL 2049 Mixer Truck', 'AGL 2049 Mixer Truck', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0117', NULL, 'Mixer Truck', 'AGL 2049', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (282, 31, 'AHA 1464 Mixer Truck', 'AHA 1464 Mixer Truck', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0118', NULL, 'Mixer Truck', 'AHA 1464', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (283, 31, 'AFJ 0792 Tipper - Trailer', 'AFJ 0792 Tipper - Trailer', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0119', NULL, 'Tipper - Trailer', 'AFJ 0792', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (284, 31, 'AGZ 7264 Shacman Tipper', 'AGZ 7264 Shacman Tipper', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0120', NULL, 'Shacman Tipper', 'AGZ 7264', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 2', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (285, 31, 'AFG 8566 Benz GL350 D (1)', 'AFG 8566 Benz GL350 D (1)', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0121', NULL, 'Benz GL350 D (1)', 'AFG 8566', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (286, 31, 'AFU 8231 Benz GL350 D (2)', 'AFU 8231 Benz GL350 D (2)', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0122', NULL, 'Benz GL350 D (2)', 'AFU 8231', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (287, 31, 'AFF 8007 Jeep Wrangler', 'AFF 8007 Jeep Wrangler', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0123', NULL, 'Jeep Wrangler', 'AFF 8007', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (288, 31, 'AGA 5454 Nissan NP300 WORKSHOP', 'AGA 5454 Nissan NP300 WORKSHOP', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0124', NULL, 'Nissan NP300 WORKSHOP', 'AGA 5454', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (289, 31, 'AGE 2432 Ford Ranger Twin Cab', 'AGE 2432 Ford Ranger Twin Cab', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0125', NULL, 'Ford Ranger Twin Cab', 'AGE 2432', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (290, 31, 'AGP 6784 Toyota Hilux  S/CAB', 'AGP 6784 Toyota Hilux  S/CAB', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0126', NULL, 'Toyota Hilux  S/CAB', 'AGP 6784', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (291, 31, 'AGO 3521 Honda Vezel', 'AGO 3521 Honda Vezel', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0127', NULL, 'Honda Vezel', 'AGO 3521', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (292, 31, 'AGP 6794 Toyota Hilux GD6', 'AGP 6794 Toyota Hilux GD6', 'active', NULL, NULL, NULL, NULL, NULL, '2026-01-14 11:53:27', '2026-01-25 13:50:18', NULL, 'VR-0128', NULL, 'Toyota Hilux GD6', 'AGP 6794', NULL, 'Motor Vehicles', 'vehicle', 'active', NULL, NULL, NULL, NULL, NULL, NULL, 'Criticality: Tier 3', NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (293, 31, 'Arc welding machine', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 1, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (294, 31, 'MIG welding machine', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 2, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (295, 31, 'Angle Grinder', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 3, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (296, 31, 'Cone Crusher 1', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 4, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 4670.4761904762, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (297, 31, 'Cone Crusher 2', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 5, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 4670.4761904762, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (298, 31, 'Converyor 1', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 6, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (299, 31, 'Converyor 2', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 7, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (300, 31, 'Converyor 3', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 8, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (301, 31, 'Converyor 4', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 9, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (302, 31, 'Control room', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 10, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (303, 31, 'Diesel tank', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 11, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (304, 31, 'Dump-truck', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 12, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (305, 31, 'Excavator', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 13, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (306, 31, 'Feeder', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 14, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (307, 31, 'Front End Loader (FEL)', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 15, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (308, 31, 'Gas torches', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 16, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (309, 31, 'Greasegun', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 17, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (310, 31, 'Generator', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 18, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (311, 31, 'Hoists', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 19, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (312, 31, 'Jaw', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 20, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 14972.857142857, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (313, 31, 'Magnet Converyor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 21, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (314, 31, 'Portable drills', NULL, 'active', NULL, NULL, 'Mobile Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 22, NULL, NULL, NULL, NULL, 'Mobile Plant', NULL, 'active', NULL, NULL, NULL, 41, NULL, NULL, 'Criticality: Tier 1', 'TBA', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (315, 31, 'Screen 1', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 23, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 40747.857142857, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (316, 31, 'Screen 2', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 24, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 24547.857142857, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (317, 31, 'Screen 3', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 25, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'Regular inspection', NULL, NULL, NULL, NULL, 7447.8571428571, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (318, 31, 'VSI', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 26, NULL, NULL, NULL, NULL, 'Stationary Plant', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', 'TBA', NULL, NULL, NULL, NULL, 12917.142857143, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (319, 31, 'JAW Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 27, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 14972.857142857, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (320, 31, 'FEEDER Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 28, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (321, 31, 'Cv1 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 29, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (322, 31, 'Cv2 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 30, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (323, 31, 'SCREEN 1 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 31, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 40747.857142857, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (324, 31, 'Cv3 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 32, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (325, 31, 'Cv4 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 33, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (326, 31, 'Cv5 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 34, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (327, 31, 'Cv6 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 35, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (328, 31, 'VSI Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 36, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 12917.142857143, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (329, 31, 'Cv7 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 37, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (330, 31, 'SCREEN 2 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 38, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 24547.857142857, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (331, 31, 'Cv8 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 39, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (332, 31, 'SCREEN 3 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 40, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 7447.8571428571, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (333, 31, 'Cv9 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 41, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (334, 31, 'Cv10 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 42, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (335, 31, 'OIL PUMPS x2 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 43, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 677.14285714286, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (336, 31, 'CONES x2 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 44, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 4670.4761904762, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (337, 31, 'New Cv x3 Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 45, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (338, 31, '900mm new Motor', NULL, 'active', NULL, NULL, 'Stationary Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 46, NULL, NULL, NULL, NULL, 'Crushing Plant Motors', NULL, 'active', NULL, NULL, NULL, 42, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (339, 31, 'Concrete Batching Plant', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 47, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (340, 31, 'AGGREGATE BIN x2', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 48, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (341, 31, 'CEMENT WEIGH BATCHER', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 49, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (342, 31, 'WATER WEIGH BATCHER', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 50, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (343, 31, 'ADDITIVE WEIGH BATCHER', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 51, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (344, 31, 'BELT CONVEYOR', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 52, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 549.35714285714, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (345, 31, 'ELECTRIC DRIVE', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 53, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (346, 31, 'WATER PUMP', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 54, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, 677.14285714286, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (347, 31, 'COMPRESSOR', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 55, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `assets` (`id`, `tenant_id`, `name`, `description`, `status`, `purchase_date`, `warranty_expiry`, `location`, `current_value`, `maintenance_interval`, `created_at`, `updated_at`, `deleted_at`, `asset_tag`, `make`, `model`, `serial_number`, `year`, `category`, `asset_type`, `lifecycle_status`, `commissioned_at`, `meter_type`, `meter_reading`, `site_id`, `fit_for_purpose`, `plant_restrictions`, `comments`, `service_frequency`, `next_review_at`, `source`, `spare_tags`, `top_spares`, `yearly_budget`, `daily_budget`, `weekly_budget`, `monthly_budget`) VALUES (348, 31, 'CEMENT SILO 1', NULL, 'active', NULL, NULL, 'Concrete Plant', NULL, NULL, '2026-01-25 13:50:15', '2026-01-25 13:50:18', NULL, 56, NULL, NULL, NULL, NULL, 'Concrete Plant', NULL, 'active', NULL, NULL, NULL, 36, NULL, NULL, 'Criticality: Tier 1', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);

-- Table: audit_logs
DROP TABLE IF EXISTS `audit_logs`;
CREATE TABLE `audit_logs` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT,
    `user_id` BIGINT,
    `action` TEXT NOT NULL,
    `entity_type` TEXT,
    `entity_id` BIGINT,
    `changes` TEXT,
    `ip_address` TEXT,
    `user_agent` TEXT,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `channel` TEXT,
    `payload_json` TEXT,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (1, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:07:25', 'telegram', '{"update_id":123457,"update_type":"message","chat_id":111,"telegram_user_id":222,"has_attachments":false,"raw":{"message_id":2,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (2, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:09:36', 'telegram', '{"update_id":123458,"update_type":"message","chat_id":111,"telegram_user_id":222,"has_attachments":false,"raw":{"message_id":3,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (3, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:29:33', 'telegram', '{"update_id":143852826,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":10,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (4, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:29:36', 'telegram', '{"update_id":143852827,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":11,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (5, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:29:40', 'telegram', '{"update_id":143852828,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":12,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (6, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:30:01', 'telegram', '{"update_id":143852829,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":13,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (7, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:30:09', 'telegram', '{"update_id":143852830,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":14,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (8, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:33:44', 'telegram', '{"update_id":143852831,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":15,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (9, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:37:33', 'telegram', '{"update_id":143852832,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":17,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (10, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:39:22', 'telegram', '{"update_id":143852833,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":18,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (11, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:40:45', 'telegram', '{"update_id":123459,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":4,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (12, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:41:47', 'telegram', '{"update_id":143852834,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":20,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (13, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:41:51', 'telegram', '{"update_id":143852835,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":21,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (14, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:42:14', 'telegram', '{"update_id":143852836,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":22,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (15, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:42:19', 'telegram', '{"update_id":143852837,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":23,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (16, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:42:46', 'telegram', '{"update_id":143852838,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":24,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (17, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:48:06', 'telegram', '{"update_id":123460,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":5,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (18, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:53:15', 'telegram', '{"update_id":123461,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":6,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (19, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 19:58:26', 'telegram', '{"update_id":123462,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":7,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (20, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:03:00', 'telegram', '{"update_id":143852839,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":28,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (21, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:03:02', 'telegram', '{"update_id":143852840,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":29,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (22, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:03:14', 'telegram', '{"update_id":143852841,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":32,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (23, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:03:22', 'telegram', '{"update_id":143852842,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":34,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (24, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:03:33', 'telegram', '{"update_id":143852843,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":36,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (25, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:03:59', 'telegram', '{"update_id":143852844,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":38,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (26, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:04:14', 'telegram', '{"update_id":143852845,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":40,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (27, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:18', 'telegram', '{"update_id":143852846,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":42,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (28, 31, 1, 'telegram.link', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:18', 'telegram', '{"telegram_user_id":"6161130318","telegram_chat_id":"6161130318"}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (29, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:27', 'telegram', '{"update_id":143852847,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":44,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (30, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:41', 'telegram', '{"update_id":143852848,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":46,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (31, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:51', 'telegram', '{"update_id":143852849,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":48,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (32, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:51', 'telegram', '{"input":[],"output":{"message":"Assets:\nBP-01 - Batch Plant BP-01 (Concrete Plant)\nCP-01 - Concrete Pump CP-01 (Concrete Plant)\nCR-01 - Primary Crusher CR-01 (Crushing Plant)\nCR-02 - Secondary Crusher CR-02 (Crushing Plant)\nCS-01 - Cement Silo CS-01 (Concrete Plant)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (33, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:31:51', 'telegram', '{"input":[],"output":{"message":"Assets:\nBP-01 - Batch Plant BP-01 (Concrete Plant)\nCP-01 - Concrete Pump CP-01 (Concrete Plant)\nCR-01 - Primary Crusher CR-01 (Crushing Plant)\nCR-02 - Secondary Crusher CR-02 (Crushing Plant)\nCS-01 - Cement Silo CS-01 (Concrete Plant)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (34, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:32:38', 'telegram', '{"update_id":143852850,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":50,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (35, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:32:38', 'telegram', '{"input":[],"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (36, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:32:38', 'telegram', '{"input":[],"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (37, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:32:58', 'telegram', '{"update_id":143852851,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":52,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (38, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:33:09', 'telegram', '{"update_id":143852852,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":54,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (39, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:57:53', 'telegram', '{"update_id":143852853,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":56,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (40, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:57:55', 'telegram', '{"input":{"q":"Fourways Quarry"},"output":{"message":"No assets found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (41, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:57:55', 'telegram', '{"input":{"q":"Fourways Quarry"},"output":{"message":"No assets found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (42, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:58:16', 'telegram', '{"update_id":143852854,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":58,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (43, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:58:18', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (44, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:58:18', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (45, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:58:31', 'telegram', '{"update_id":143852855,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":60,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (46, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:58:49', 'telegram', '{"update_id":143852856,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":62,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (47, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:59:04', 'telegram', '{"update_id":143852857,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":64,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (48, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:59:35', 'telegram', '{"update_id":143852858,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":66,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (49, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 20:59:48', 'telegram', '{"update_id":143852859,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":68,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (50, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:00:06', 'telegram', '{"update_id":143852860,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":70,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (51, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:00:22', 'telegram', '{"update_id":143852861,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":72,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (52, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:00:47', 'telegram', '{"update_id":143852862,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":74,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (53, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:02:00', 'telegram', '{"update_id":143852863,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":76,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (54, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:02:28', 'telegram', '{"update_id":143852864,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":78,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (55, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:02:41', 'telegram', '{"update_id":143852865,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":80,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (56, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:02:57', 'telegram', '{"update_id":143852866,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":82,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (57, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:02:59', 'telegram', '{"input":{"tag":""},"output":{"message":"Assets:\nBP-01 - Batch Plant BP-01 (Concrete Plant)\nCP-01 - Concrete Pump CP-01 (Concrete Plant)\nCR-01 - Primary Crusher CR-01 (Crushing Plant)\nCR-02 - Secondary Crusher CR-02 (Crushing Plant)\nCS-01 - Cement Silo CS-01 (Concrete Plant)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (58, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:02:59', 'telegram', '{"input":{"tag":""},"output":{"message":"Assets:\nBP-01 - Batch Plant BP-01 (Concrete Plant)\nCP-01 - Concrete Pump CP-01 (Concrete Plant)\nCR-01 - Primary Crusher CR-01 (Crushing Plant)\nCR-02 - Secondary Crusher CR-02 (Crushing Plant)\nCS-01 - Cement Silo CS-01 (Concrete Plant)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (59, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:03:24', 'telegram', '{"update_id":143852867,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":84,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (60, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:03:38', 'telegram', '{"update_id":143852868,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":86,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (61, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:03:58', 'telegram', '{"update_id":143852869,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":88,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (62, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:04:26', 'telegram', '{"update_id":143852870,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":90,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (63, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:56:26', 'telegram', '{"input":{"module":"assets","limit":3},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (64, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:56:32', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":3},"output":{"message":"Export ready: assets_20260119_215627.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260119_215627.pdf","filename":"assets_20260119_215627.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (65, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:57:39', 'telegram', '{"update_id":143852871,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":92,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (66, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:58:48', 'telegram', '{"update_id":123470,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":10,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (67, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:58:48', 'telegram', '{"input":{"module":"assets","limit":"2"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (68, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:58:48', 'telegram', '{"input":{"module":"assets","limit":"2"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (69, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:58:50', 'telegram', '{"update_id":143852871,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":92,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (70, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:59:20', 'telegram', '{"update_id":123471,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":11,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (71, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:59:21', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260119_215920.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260119_215920.pdf","filename":"assets_20260119_215920.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (72, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-19 21:59:21', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260119_215920.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260119_215920.pdf","filename":"assets_20260119_215920.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (73, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 05:18:52', 'telegram', '{"update_id":143852872,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":97,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (74, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 05:19:20', 'telegram', '{"update_id":143852873,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":99,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (75, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 05:19:41', 'telegram', '{"update_id":143852874,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":101,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (76, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:34:58', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (77, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:34:58', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (78, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:35:02', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (79, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:35:02', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (80, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:35:12', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_133502.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_133502.pdf","filename":"assets_20260120_133502.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (81, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:35:12', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_133502.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_133502.pdf","filename":"assets_20260120_133502.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (82, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:35:12', 'telegram', '{"input":{"asset":"ME-EXC-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (83, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:35:12', 'telegram', '{"input":{"asset":"ME-EXC-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (84, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:51', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (85, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:51', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (86, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (87, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (88, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_133655.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_133655.pdf","filename":"assets_20260120_133655.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (89, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_133655.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_133655.pdf","filename":"assets_20260120_133655.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (90, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"asset":"ME-EXC-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (91, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"asset":"ME-EXC-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (92, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (93, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:55', 'telegram', '{"input":{"asset":"ME-EXC-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (94, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:56', 'telegram', '{"input":{"q":"filter","module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (95, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:56', 'telegram', '{"input":{"q":"filter","module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (96, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:56', 'telegram', '{"input":{"status":"open","module":"alerts"},"output":{"title":"Alerts","headers":["Asset","Severity","Status","Message","Time"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (97, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:36:56', 'telegram', '{"input":{"status":"open","module":"alerts"},"output":{"title":"Alerts","headers":["Asset","Severity","Status","Message","Time"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (98, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (99, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (100, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"module":"assets","tag":"AST-6022"},"output":{"message":"Asset not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (101, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"module":"assets","tag":"AST-6022"},"output":{"message":"Asset not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (102, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"asset":"AST-6022","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (103, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"asset":"AST-6022","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-0209 - CP-01 (open)\nWO-0210 - CR-01 (open)\nWO-0211 - CR-02 (open)\nWO-0212 - CS-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (104, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"asset":"AST-6022","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (105, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"asset":"AST-6022","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (106, 31, 1, 'parts.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"q":"filter"},"output":{"message":"Parts:\nFLT-100 - Hydraulic Filter"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (107, 31, 1, 'parts.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"q":"filter"},"output":{"message":"Parts:\nFLT-100 - Hydraulic Filter"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (108, 31, 1, 'stock.balance', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"sku":"OIL-FILTER-001"},"output":{"message":"Stock item not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (109, 31, 1, 'stock.balance', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"sku":"OIL-FILTER-001"},"output":{"message":"Stock item not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (110, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"limit":"3","module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (111, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:20', 'telegram', '{"input":{"limit":"3","module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (112, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:21', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",34,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 34 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (113, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:21', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",34,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 34 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (114, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:21', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_134321.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_134321.pdf","filename":"assets_20260120_134321.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (115, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:21', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_134321.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_134321.pdf","filename":"assets_20260120_134321.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (116, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:34', 'telegram', '{"input":{"module":"assets","format":"xlsx","limit":"2"},"output":{"message":"Export ready: assets_20260120_134321.xlsx","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_134321.xlsx","filename":"assets_20260120_134321.xlsx"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (117, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:34', 'telegram', '{"input":{"module":"assets","format":"xlsx","limit":"2"},"output":{"message":"Export ready: assets_20260120_134321.xlsx","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_134321.xlsx","filename":"assets_20260120_134321.xlsx"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (118, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:36', 'telegram', '{"input":{"q":"status:active"},"output":{"message":"No assets found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (119, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:43:36', 'telegram', '{"input":{"q":"status:active"},"output":{"message":"No assets found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (120, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (121, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"module":"assets","limit":"3"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (122, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"module":"assets","tag":"BP-01"},"output":{"title":"Asset Detail","headers":["Field","Value"],"rows":[["Tag","BP-01"],["Name","Batch Plant BP-01"],["Status","active"],["Category","Concrete Plant"],["Location","Concrete Plant"],["Meter Type","hours"],["Meter Reading",2200]],"message":"Asset Detail:\nTag | BP-01\nName | Batch Plant BP-01\nStatus | active\nCategory | Concrete Plant\nLocation | Concrete Plant\nMeter Type | hours\nMeter Reading | 2200"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (123, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"module":"assets","tag":"BP-01"},"output":{"title":"Asset Detail","headers":["Field","Value"],"rows":[["Tag","BP-01"],["Name","Batch Plant BP-01"],["Status","active"],["Category","Concrete Plant"],["Location","Concrete Plant"],["Meter Type","hours"],["Meter Reading",2200]],"message":"Asset Detail:\nTag | BP-01\nName | Batch Plant BP-01\nStatus | active\nCategory | Concrete Plant\nLocation | Concrete Plant\nMeter Type | hours\nMeter Reading | 2200"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (124, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"asset":"BP-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-232 - BP-01 (open)"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (125, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"asset":"BP-01","status":"open"},"output":{"message":"Work Orders:\nWO-0208 - BP-01 (open)\nWO-232 - BP-01 (open)"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (126, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"asset":"BP-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Created work order WO-9SM8SF."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (127, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"asset":"BP-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Created work order WO-9SM8SF."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (128, 31, 1, 'parts.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"q":"filter"},"output":{"message":"Parts:\nFLT-100 - Hydraulic Filter"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (129, 31, 1, 'parts.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"q":"filter"},"output":{"message":"Parts:\nFLT-100 - Hydraulic Filter"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (130, 31, 1, 'stock.balance', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"sku":"FLT-100"},"output":{"message":"FLT-100 (Hydraulic Filter) balance: 28"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (131, 31, 1, 'stock.balance', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"sku":"FLT-100"},"output":{"message":"FLT-100 (Hydraulic Filter) balance: 28"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (132, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"limit":"3","module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (133, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"limit":"3","module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (134, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",35,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 35 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (135, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:14', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",35,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 35 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (136, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:15', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_135614.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_135614.pdf","filename":"assets_20260120_135614.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (137, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:15', 'telegram', '{"input":{"module":"assets","format":"pdf","limit":"2"},"output":{"message":"Export ready: assets_20260120_135614.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_135614.pdf","filename":"assets_20260120_135614.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (138, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:15', 'telegram', '{"input":{"module":"assets","format":"xlsx","limit":"2"},"output":{"message":"Export ready: assets_20260120_135615.xlsx","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_135615.xlsx","filename":"assets_20260120_135615.xlsx"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (139, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:15', 'telegram', '{"input":{"module":"assets","format":"xlsx","limit":"2"},"output":{"message":"Export ready: assets_20260120_135615.xlsx","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260120_135615.xlsx","filename":"assets_20260120_135615.xlsx"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (140, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:18', 'telegram', '{"input":{"module":"assets","status":"active"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (141, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:18', 'telegram', '{"input":{"module":"assets","status":"active"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (142, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:21', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",35,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 35 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (143, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:56:21', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",35,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 35 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (144, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:58:06', 'telegram', '{"input":{"module":"assets","status":"active","limit":2},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (145, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:58:06', 'telegram', '{"input":{"module":"assets","status":"active","limit":2},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (146, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:58:08', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",35,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 35 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (147, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:58:08', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",35,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 35 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (148, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:58:32', 'telegram', '{"input":{"asset":"AST-9999","status":"open"},"output":{"message":"Asset not found. Try \/list module=assets to see available tags."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (149, 31, 1, 'workorders.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 13:58:32', 'telegram', '{"input":{"asset":"AST-9999","status":"open"},"output":{"message":"Asset not found. Try \/list module=assets to see available tags."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (150, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:11', 'telegram', '{"input":{"module":"assets","tag":"BP-01"},"output":{"title":"Asset Detail","headers":["Field","Value"],"rows":[["Tag","BP-01"],["Name","Batch Plant BP-01"],["Status","active"],["Category","Concrete Plant"],["Location","Concrete Plant"],["Meter Type","hours"],["Meter Reading",2200]],"message":"Asset Detail:\nTag | BP-01\nName | Batch Plant BP-01\nStatus | active\nCategory | Concrete Plant\nLocation | Concrete Plant\nMeter Type | hours\nMeter Reading | 2200"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (151, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:11', 'telegram', '{"input":{"module":"assets","tag":"BP-01"},"output":{"title":"Asset Detail","headers":["Field","Value"],"rows":[["Tag","BP-01"],["Name","Batch Plant BP-01"],["Status","active"],["Category","Concrete Plant"],["Location","Concrete Plant"],["Meter Type","hours"],["Meter Reading",2200]],"message":"Asset Detail:\nTag | BP-01\nName | Batch Plant BP-01\nStatus | active\nCategory | Concrete Plant\nLocation | Concrete Plant\nMeter Type | hours\nMeter Reading | 2200"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (152, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:11', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (153, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:11', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (154, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:11', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (155, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:11', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (156, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:12', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (157, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:12', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (158, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:12', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (159, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:12', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (160, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:12', 'telegram', '{"input":{"module":"assets","tag":"AST-9999"},"output":{"message":"Asset not found. Try \/list module=assets."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (161, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 14:09:12', 'telegram', '{"input":{"module":"assets","tag":"AST-9999"},"output":{"message":"Asset not found. Try \/list module=assets."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (162, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"assets","tag":"BP-01"},"output":{"title":"Asset Detail","headers":["Field","Value"],"rows":[["Tag","BP-01"],["Name","Batch Plant BP-01"],["Status","active"],["Category","Concrete Plant"],["Location","Concrete Plant"],["Meter Type","hours"],["Meter Reading",2200]],"message":"Asset Detail:\nTag | BP-01\nName | Batch Plant BP-01\nStatus | active\nCategory | Concrete Plant\nLocation | Concrete Plant\nMeter Type | hours\nMeter Reading | 2200"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (163, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"assets","tag":"BP-01"},"output":{"title":"Asset Detail","headers":["Field","Value"],"rows":[["Tag","BP-01"],["Name","Batch Plant BP-01"],["Status","active"],["Category","Concrete Plant"],["Location","Concrete Plant"],["Meter Type","hours"],["Meter Reading",2200]],"message":"Asset Detail:\nTag | BP-01\nName | Batch Plant BP-01\nStatus | active\nCategory | Concrete Plant\nLocation | Concrete Plant\nMeter Type | hours\nMeter Reading | 2200"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (164, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (165, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (166, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"fuel","asset":"BP-01"},"output":{"title":"Fuel Logs","headers":["Asset","Qty","Fuel Type","Cost","Date"],"rows":[["BP-01",177,"diesel",144,"2026-01-12 20:11"],["BP-01",114,"diesel",144,"2026-01-09 20:15"]],"message":"Fuel Logs:\nBP-01 | 177 | diesel | 144 | 2026-01-12 20:11\nBP-01 | 114 | diesel | 144 | 2026-01-09 20:15"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (167, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"fuel","asset":"BP-01"},"output":{"title":"Fuel Logs","headers":["Asset","Qty","Fuel Type","Cost","Date"],"rows":[["BP-01",177,"diesel",144,"2026-01-12 20:11"],["BP-01",114,"diesel",144,"2026-01-09 20:15"]],"message":"Fuel Logs:\nBP-01 | 177 | diesel | 144 | 2026-01-12 20:11\nBP-01 | 114 | diesel | 144 | 2026-01-09 20:15"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (168, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"tyres","asset":"BP-01"},"output":{"title":"Tyres","headers":["Asset","Position","Brand","Status","Tread"],"rows":[["BP-01","Front Left","Bridgestone","active",22.5]],"message":"Tyres:\nBP-01 | Front Left | Bridgestone | active | 22.5"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (169, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"tyres","asset":"BP-01"},"output":{"title":"Tyres","headers":["Asset","Position","Brand","Status","Tread"],"rows":[["BP-01","Front Left","Bridgestone","active",22.5]],"message":"Tyres:\nBP-01 | Front Left | Bridgestone | active | 22.5"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (170, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"telemetry","asset":"BP-01"},"output":{"title":"Telemetry","headers":["Time","Asset","Hours"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (171, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:05', 'telegram', '{"input":{"module":"telemetry","asset":"BP-01"},"output":{"title":"Telemetry","headers":["Time","Asset","Hours"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (172, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"fuel","format":"pdf","asset":"BP-01"},"output":{"message":"Export ready: fuel-logs_20260120_171006.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\fuel-logs_20260120_171006.pdf","filename":"fuel-logs_20260120_171006.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (173, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"fuel","format":"pdf","asset":"BP-01"},"output":{"message":"Export ready: fuel-logs_20260120_171006.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\fuel-logs_20260120_171006.pdf","filename":"fuel-logs_20260120_171006.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (174, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"assets","site":"Four"},"output":{"message":"Site not found. Did you mean:\nFourways Quarry\nFourways Concrete"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (175, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"assets","site":"Four"},"output":{"message":"Site not found. Did you mean:\nFourways Quarry\nFourways Concrete"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (176, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"assets","location":"Quarr"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"],["GR-02","Grader GR-02","active","Fourways Quarry"],["H-32","Hauler H-32","active","Fourways Quarry"],["H-44","Hauler H-44","active","Fourways Quarry"],["L-07","Loader L-07","active","Fourways Quarry"],["WB-03","Water Bowser WB-03","active","Fourways Quarry"]],"message":"Assets:\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry\nEX-09 | Excavator EX-09 | active | Fourways Quarry\nEX-12 | Excavator EX-12 | active | Fourways Quarry\nGR-02 | Grader GR-02 | active | Fourways Quarry\nH-32 | Hauler H-32 | active | Fourways Quarry\nH-44 | Hauler H-44 | active | Fourways Quarry\nL-07 | Loader L-07 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (177, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"assets","location":"Quarr"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"],["GR-02","Grader GR-02","active","Fourways Quarry"],["H-32","Hauler H-32","active","Fourways Quarry"],["H-44","Hauler H-44","active","Fourways Quarry"],["L-07","Loader L-07","active","Fourways Quarry"],["WB-03","Water Bowser WB-03","active","Fourways Quarry"]],"message":"Assets:\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry\nEX-09 | Excavator EX-09 | active | Fourways Quarry\nEX-12 | Excavator EX-12 | active | Fourways Quarry\nGR-02 | Grader GR-02 | active | Fourways Quarry\nH-32 | Hauler H-32 | active | Fourways Quarry\nH-44 | Hauler H-44 | active | Fourways Quarry\nL-07 | Loader L-07 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (178, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"workorders","wo":"Quarterly"},"output":{"message":"Work order not found. Did you mean:\nWO-0208 - Quarterly inspection and lubrica...\nWO-0209 - Quarterly inspection and lubrica...\nWO-0210 - Quarterly inspection and lubrica...\nWO-0211 - Quarterly inspection and lubrica...\nWO-0212 - Quarterly inspection and lubrica..."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (179, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:10:15', 'telegram', '{"input":{"module":"workorders","wo":"Quarterly"},"output":{"message":"Work order not found. Did you mean:\nWO-0208 - Quarterly inspection and lubrica...\nWO-0209 - Quarterly inspection and lubrica...\nWO-0210 - Quarterly inspection and lubrica...\nWO-0211 - Quarterly inspection and lubrica...\nWO-0212 - Quarterly inspection and lubrica..."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (180, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:20:28', 'telegram', '{"update_id":143852875,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":103,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (181, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:20:28', 'telegram', '{"input":{"module":"fuel","asset":"D-04"},"output":{"title":"Fuel Logs","headers":["Asset","Qty","Fuel Type","Cost","Date"],"rows":[["D-04",219,"diesel",144,"2026-01-12 20:11"],["D-04",143,"diesel",144,"2026-01-09 20:15"]],"message":"Fuel Logs:\nD-04 | 219 | diesel | 144 | 2026-01-12 20:11\nD-04 | 143 | diesel | 144 | 2026-01-09 20:15"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (182, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:20:28', 'telegram', '{"input":{"module":"fuel","asset":"D-04"},"output":{"title":"Fuel Logs","headers":["Asset","Qty","Fuel Type","Cost","Date"],"rows":[["D-04",219,"diesel",144,"2026-01-12 20:11"],["D-04",143,"diesel",144,"2026-01-09 20:15"]],"message":"Fuel Logs:\nD-04 | 219 | diesel | 144 | 2026-01-12 20:11\nD-04 | 143 | diesel | 144 | 2026-01-09 20:15"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (183, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:20:49', 'telegram', '{"update_id":143852876,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":105,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (184, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:20:52', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (185, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:20:52', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (186, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:21:21', 'telegram', '{"update_id":143852877,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":107,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (187, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:21:24', 'telegram', '{"input":{"module":"purchase_requests","id":"PR-GOR-001"},"output":{"message":"Purchase request not found. Try \/list module=purchase_requests."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (188, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:21:24', 'telegram', '{"input":{"module":"purchase_requests","id":"PR-GOR-001"},"output":{"message":"Purchase request not found. Try \/list module=purchase_requests."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (189, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:21:45', 'telegram', '{"update_id":143852878,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":109,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (190, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:21:45', 'telegram', '{"input":{"module":"workorders","asset":"D-04"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0214","D-04","open","medium","2026-01-24"],["WO-252","D-04","open","medium","2026-01-23"]],"message":"Work Orders:\nWO-0214 | D-04 | open | medium | 2026-01-24\nWO-252 | D-04 | open | medium | 2026-01-23"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (191, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:21:45', 'telegram', '{"input":{"module":"workorders","asset":"D-04"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0214","D-04","open","medium","2026-01-24"],["WO-252","D-04","open","medium","2026-01-23"]],"message":"Work Orders:\nWO-0214 | D-04 | open | medium | 2026-01-24\nWO-252 | D-04 | open | medium | 2026-01-23"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (192, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:22:10', 'telegram', '{"update_id":143852879,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":111,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (193, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:22:10', 'telegram', '{"input":{"module":"workorders","asset":"D-04"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0214","D-04","open","medium","2026-01-24"],["WO-252","D-04","open","medium","2026-01-23"]],"message":"Work Orders:\nWO-0214 | D-04 | open | medium | 2026-01-24\nWO-252 | D-04 | open | medium | 2026-01-23"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (194, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:22:10', 'telegram', '{"input":{"module":"workorders","asset":"D-04"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0214","D-04","open","medium","2026-01-24"],["WO-252","D-04","open","medium","2026-01-23"]],"message":"Work Orders:\nWO-0214 | D-04 | open | medium | 2026-01-24\nWO-252 | D-04 | open | medium | 2026-01-23"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (195, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:22:40', 'telegram', '{"update_id":143852880,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":113,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (196, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:23:12', 'telegram', '{"update_id":143852881,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":115,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (197, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:23:12', 'telegram', '{"input":{"asset":"BP-01","title":"Hydraulic leak"},"output":{"message":"Created work order WO-UK3VPT."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (198, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:23:12', 'telegram', '{"input":{"asset":"BP-01","title":"Hydraulic leak"},"output":{"message":"Created work order WO-UK3VPT."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (199, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:23:33', 'telegram', '{"update_id":143852882,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":117,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (200, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:23:33', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (201, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:23:33', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (202, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:43:16', 'telegram', '{"update_id":143852883,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":119,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (203, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:43:43', 'telegram', '{"update_id":143852884,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":121,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (204, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:43:54', 'telegram', '{"update_id":143852885,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":123,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (205, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:44:09', 'telegram', '{"update_id":143852886,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":125,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (206, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:44:35', 'telegram', '{"update_id":143852887,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":127,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (207, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:44:38', 'telegram', '{"input":{"q":"Fourways Quarry"},"output":{"message":"Asset not found. Nearby locations:\nFourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (208, 31, 1, 'assets.search', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:44:38', 'telegram', '{"input":{"q":"Fourways Quarry"},"output":{"message":"Asset not found. Nearby locations:\nFourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (209, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:45:12', 'telegram', '{"update_id":143852888,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":129,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (210, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:45:15', 'telegram', '{"input":{"module":"tenants","limit":100},"output":{"title":"Tenants","headers":["ID","Name","Status","Email"],"rows":[[1,"Dicki, Fritsch and Littel","active","alec37@example.net"],[2,"Volkman-Reinger","active","abigale.volkman@example.net"],[3,"Wuckert Inc","active","tony.nicolas@example.net"],[4,"Marks-Smith","active","paul86@example.org"],[5,"Bashirian-Goyette","active","everette.doyle@example.net"],[6,"Bogan, Mann and Doyle","active","dillon53@example.com"],[7,"Hermiston-Bednar","active","gbeahan@example.com"],[8,"Herzog Group","active","mariano37@example.org"],[9,"Bahringer-Emard","active","heller.raquel@example.org"],[10,"Gorczany, Casper and Moore","active","bkuhn@example.com"],[11,"Jakubowski, Wunsch and Kris","active","xhomenick@example.org"],[12,"Krajcik PLC","active","vvon@example.net"],[13,"Reilly, Rogahn and Heathcote","active","schiller.lura@example.com"],[14,"Price LLC","active","pagac.selmer@example.org"],[15,"Mante LLC","active","breana79@example.org"],[16,"Terry, Beier and Dare","active","gutmann.devon@example.net"],[17,"Oberbrunner and Sons","active","jlubowitz@example.net"],[18,"Wiza Ltd","active","marcia76@example.net"],[19,"Fay and Sons","active","bo40@example.org"],[20,"Marvin-Medhurst","active","cgoyette@example.net"],[21,"Moore-Steuber","active","harber.cleo@example.net"],[22,"Rosenbaum, Prohaska and Prosacco","active","rebekah.larson@example.net"],[23,"Kub-Mann","active","britchie@example.org"],[24,"Bailey, Murphy and Cummings","active","tillman85@example.com"],[25,"Russel-Strosin","active","danielle.hilpert@example.com"],[26,"DuBuque, Hagenes and Ledner","active","palma79@example.net"],[27,"Hill Inc","active","walsh.ed@example.com"],[28,"Zieme, Rowe and Wehner","active","gromaguera@example.com"],[29,"Robel, Conroy and Hill","active","btorp@example.org"],[30,"Cummerata PLC","active","faye25@example.net"],[31,"Fourways Group","active","ops@fourways.example"]],"message":"Tenants:\n1 | Dicki, Fritsch and Littel | active | alec37@example.net\n2 | Volkman-Reinger | active | abigale.volkman@example.net\n3 | Wuckert Inc | active | tony.nicolas@example.net\n4 | Marks-Smith | active | paul86@example.org\n5 | Bashirian-Goyette | active | everette.doyle@example.net\n6 | Bogan, Mann and Doyle | active | dillon53@example.com\n7 | Hermiston-Bednar | active | gbeahan@example.com\n8 | Herzog Group | active | mariano37@example.org"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (211, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:45:15', 'telegram', '{"input":{"module":"tenants","limit":100},"output":{"title":"Tenants","headers":["ID","Name","Status","Email"],"rows":[[1,"Dicki, Fritsch and Littel","active","alec37@example.net"],[2,"Volkman-Reinger","active","abigale.volkman@example.net"],[3,"Wuckert Inc","active","tony.nicolas@example.net"],[4,"Marks-Smith","active","paul86@example.org"],[5,"Bashirian-Goyette","active","everette.doyle@example.net"],[6,"Bogan, Mann and Doyle","active","dillon53@example.com"],[7,"Hermiston-Bednar","active","gbeahan@example.com"],[8,"Herzog Group","active","mariano37@example.org"],[9,"Bahringer-Emard","active","heller.raquel@example.org"],[10,"Gorczany, Casper and Moore","active","bkuhn@example.com"],[11,"Jakubowski, Wunsch and Kris","active","xhomenick@example.org"],[12,"Krajcik PLC","active","vvon@example.net"],[13,"Reilly, Rogahn and Heathcote","active","schiller.lura@example.com"],[14,"Price LLC","active","pagac.selmer@example.org"],[15,"Mante LLC","active","breana79@example.org"],[16,"Terry, Beier and Dare","active","gutmann.devon@example.net"],[17,"Oberbrunner and Sons","active","jlubowitz@example.net"],[18,"Wiza Ltd","active","marcia76@example.net"],[19,"Fay and Sons","active","bo40@example.org"],[20,"Marvin-Medhurst","active","cgoyette@example.net"],[21,"Moore-Steuber","active","harber.cleo@example.net"],[22,"Rosenbaum, Prohaska and Prosacco","active","rebekah.larson@example.net"],[23,"Kub-Mann","active","britchie@example.org"],[24,"Bailey, Murphy and Cummings","active","tillman85@example.com"],[25,"Russel-Strosin","active","danielle.hilpert@example.com"],[26,"DuBuque, Hagenes and Ledner","active","palma79@example.net"],[27,"Hill Inc","active","walsh.ed@example.com"],[28,"Zieme, Rowe and Wehner","active","gromaguera@example.com"],[29,"Robel, Conroy and Hill","active","btorp@example.org"],[30,"Cummerata PLC","active","faye25@example.net"],[31,"Fourways Group","active","ops@fourways.example"]],"message":"Tenants:\n1 | Dicki, Fritsch and Littel | active | alec37@example.net\n2 | Volkman-Reinger | active | abigale.volkman@example.net\n3 | Wuckert Inc | active | tony.nicolas@example.net\n4 | Marks-Smith | active | paul86@example.org\n5 | Bashirian-Goyette | active | everette.doyle@example.net\n6 | Bogan, Mann and Doyle | active | dillon53@example.com\n7 | Hermiston-Bednar | active | gbeahan@example.com\n8 | Herzog Group | active | mariano37@example.org"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (212, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:33', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (213, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:33', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (214, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:33', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open","limit":10},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (215, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:33', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open","limit":10},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (216, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:40', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open","format":"xlsx"},"output":{"message":"Export ready: work-orders_20260120_174933.xlsx","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\work-orders_20260120_174933.xlsx","filename":"work-orders_20260120_174933.xlsx"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (217, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:40', 'telegram', '{"input":{"module":"workorders","asset":"BP-01","status":"open","format":"xlsx"},"output":{"message":"Export ready: work-orders_20260120_174933.xlsx","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\work-orders_20260120_174933.xlsx","filename":"work-orders_20260120_174933.xlsx"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (218, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (219, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (220, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"fuel","asset":"BP-01"},"output":{"title":"Fuel Logs","headers":["Asset","Qty","Fuel Type","Cost","Date"],"rows":[["BP-01",177,"diesel",144,"2026-01-12 20:11"],["BP-01",114,"diesel",144,"2026-01-09 20:15"]],"message":"Fuel Logs:\nBP-01 | 177 | diesel | 144 | 2026-01-12 20:11\nBP-01 | 114 | diesel | 144 | 2026-01-09 20:15"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (221, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"fuel","asset":"BP-01"},"output":{"title":"Fuel Logs","headers":["Asset","Qty","Fuel Type","Cost","Date"],"rows":[["BP-01",177,"diesel",144,"2026-01-12 20:11"],["BP-01",114,"diesel",144,"2026-01-09 20:15"]],"message":"Fuel Logs:\nBP-01 | 177 | diesel | 144 | 2026-01-12 20:11\nBP-01 | 114 | diesel | 144 | 2026-01-09 20:15"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (222, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"tyres","asset":"BP-01"},"output":{"title":"Tyres","headers":["Asset","Position","Brand","Status","Tread"],"rows":[["BP-01","Front Left","Bridgestone","active",22.5]],"message":"Tyres:\nBP-01 | Front Left | Bridgestone | active | 22.5"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (223, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"tyres","asset":"BP-01"},"output":{"title":"Tyres","headers":["Asset","Position","Brand","Status","Tread"],"rows":[["BP-01","Front Left","Bridgestone","active",22.5]],"message":"Tyres:\nBP-01 | Front Left | Bridgestone | active | 22.5"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (224, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"telemetry","asset":"BP-01"},"output":{"title":"Telemetry","headers":["Time","Asset","Hours"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (225, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:49:41', 'telegram', '{"input":{"module":"telemetry","asset":"BP-01"},"output":{"title":"Telemetry","headers":["Time","Asset","Hours"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (226, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:52:08', 'telegram', '{"update_id":143852889,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":131,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (227, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:52:11', 'telegram', '{"input":{"module":"fuel","format":"pdf","asset":"BP-01"},"output":{"message":"Export ready: fuel-logs_20260120_175208.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\fuel-logs_20260120_175208.pdf","filename":"fuel-logs_20260120_175208.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (228, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:52:11', 'telegram', '{"input":{"module":"fuel","format":"pdf","asset":"BP-01"},"output":{"message":"Export ready: fuel-logs_20260120_175208.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\fuel-logs_20260120_175208.pdf","filename":"fuel-logs_20260120_175208.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (229, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:53:00', 'telegram', '{"update_id":143852890,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":134,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (230, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:53:03', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf","limit":5},"output":{"message":"Export ready: purchase-requests_20260120_175302.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260120_175302.pdf","filename":"purchase-requests_20260120_175302.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (231, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:53:03', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf","limit":5},"output":{"message":"Export ready: purchase-requests_20260120_175302.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260120_175302.pdf","filename":"purchase-requests_20260120_175302.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (232, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:54:19', 'telegram', '{"update_id":143852891,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":137,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (233, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:55:05', 'telegram', '{"update_id":143852892,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":139,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (234, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:55:07', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf"},"output":{"message":"Export ready: purchase-requests_20260120_175507.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260120_175507.pdf","filename":"purchase-requests_20260120_175507.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (235, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 17:55:07', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf"},"output":{"message":"Export ready: purchase-requests_20260120_175507.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260120_175507.pdf","filename":"purchase-requests_20260120_175507.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (236, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:38:55', 'telegram', '{"update_id":143852893,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":142,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (237, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:38:56', 'telegram', '{"input":{"wo":"WO-01234","user":"Denford"},"output":{"message":"Work order not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (238, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:38:56', 'telegram', '{"input":{"wo":"WO-01234","user":"Denford"},"output":{"message":"Work order not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (239, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:39:19', 'telegram', '{"update_id":143852894,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":144,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (240, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:39:19', 'telegram', '{"input":{"asset":"BP-01","title":"leaking pipe"},"output":{"error":"SQLSTATE[HY000]: General error: 1 table work_orders has no column named estimated_cost (SQL: insert into \"work_orders\" (\"tenant_id\", \"asset_id\", \"reference_code\", \"source\", \"status\", \"priority\", \"description\", \"reported_by\", \"estimated_cost\", \"requires_approval\", \"approval_status\", \"updated_at\", \"created_at\") values (31, 156, WO-N9EZPY, telegram, open, medium, leaking pipe, 1, ?, 0, ?, 2026-01-20 19:39:19, 2026-01-20 19:39:19))"},"success":false}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (241, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:40:36', 'telegram', '{"update_id":143852895,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":146,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (242, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:40:36', 'telegram', '{"input":{"dept":"Crushing","needed_by":"2026-01-30","priority":"high","reason":"Conveyor reliability"},"output":{"error":"SQLSTATE[HY000]: General error: 1 table purchase_requests has no column named department (SQL: insert into \"purchase_requests\" (\"tenant_id\", \"request_code\", \"title\", \"department\", \"cost_center\", \"status\", \"priority\", \"requested_by\", \"needed_by\", \"currency\", \"notes\", \"updated_at\", \"created_at\") values (31, PR-00001, Conveyor reliability, Crushing, ?, draft, high, 1, 2026-01-30 00:00:00, USD, Conveyor reliability, 2026-01-20 19:40:36, 2026-01-20 19:40:36))"},"success":false}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (243, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:41:22', 'telegram', '{"update_id":143852896,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":148,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (244, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:41:23', 'telegram', '{"input":{"reason":"welding rods"},"output":{"error":"SQLSTATE[HY000]: General error: 1 table purchase_requests has no column named department (SQL: insert into \"purchase_requests\" (\"tenant_id\", \"request_code\", \"title\", \"department\", \"cost_center\", \"status\", \"priority\", \"requested_by\", \"needed_by\", \"currency\", \"notes\", \"updated_at\", \"created_at\") values (31, PR-00001, welding rods, ?, ?, draft, medium, 1, ?, USD, welding rods, 2026-01-20 19:41:23, 2026-01-20 19:41:23))"},"success":false}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (245, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:52:35', 'telegram', '{"update_id":143852897,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":150,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (246, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:52:35', 'telegram', '{"input":{"dept":"Crushing","needed_by":"2026-01-30","priority":"high","reason":"Conveyor reliability"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (247, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:52:35', 'telegram', '{"input":{"dept":"Crushing","needed_by":"2026-01-30","priority":"high","reason":"Conveyor reliability"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (248, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:52:53', 'telegram', '{"update_id":143852898,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":152,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (249, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:05', 'telegram', '{"update_id":143852899,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":154,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (250, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:07', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (251, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:07', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (252, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:17', 'telegram', '{"update_id":143852900,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":156,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (253, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:17', 'telegram', '{"input":{"module":"assets","limit":10},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (254, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:17', 'telegram', '{"input":{"module":"assets","limit":10},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (255, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:34', 'telegram', '{"update_id":143852901,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":158,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (256, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:37', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (257, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:37', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (258, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:53:58', 'telegram', '{"update_id":143852902,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":160,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (259, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:54:01', 'telegram', '{"input":{"module":"assets","q":"BP-01"},"output":{"message":"Asset not found. Try \/list module=assets."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (260, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:54:01', 'telegram', '{"input":{"module":"assets","q":"BP-01"},"output":{"message":"Asset not found. Try \/list module=assets."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (261, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:54:41', 'telegram', '{"update_id":143852903,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":162,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (262, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:54:52', 'telegram', '{"update_id":143852904,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":164,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (263, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:54:53', 'telegram', '{"input":{"module":"vendors"},"output":{"title":"Vendors","headers":["Vendor","Contact","Phone","Email"],"rows":[["Summit Industrial Supplies","Pat Rivera","+1 555 010 433","sales@summit.example"]],"message":"Vendors:\nSummit Industrial Supplies | Pat Rivera | +1 555 010 433 | sales@summit.example"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (264, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:54:53', 'telegram', '{"input":{"module":"vendors"},"output":{"title":"Vendors","headers":["Vendor","Contact","Phone","Email"],"rows":[["Summit Industrial Supplies","Pat Rivera","+1 555 010 433","sales@summit.example"]],"message":"Vendors:\nSummit Industrial Supplies | Pat Rivera | +1 555 010 433 | sales@summit.example"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (265, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:55:11', 'telegram', '{"update_id":143852905,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":166,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (266, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:55:11', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (267, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:55:11', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (268, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:56:04', 'telegram', '{"update_id":143852906,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":168,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (269, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:56:04', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (270, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:56:04', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (271, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:57:30', 'telegram', '{"update_id":143852907,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":170,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (272, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:57:37', 'telegram', '{"update_id":143852908,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":172,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (273, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:58:13', 'telegram', '{"update_id":143852909,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":174,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (274, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:58:18', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf"},"output":{"message":"Export ready: purchase-requests_20260120_195815.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260120_195815.pdf","filename":"purchase-requests_20260120_195815.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (275, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:58:18', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf"},"output":{"message":"Export ready: purchase-requests_20260120_195815.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260120_195815.pdf","filename":"purchase-requests_20260120_195815.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (276, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:58:58', 'telegram', '{"update_id":143852910,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":177,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (277, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:59:05', 'telegram', '{"update_id":143852911,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":179,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (278, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:59:14', 'telegram', '{"update_id":143852912,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":181,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (279, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:59:16', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (280, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 19:59:16', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (281, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:00:07', 'telegram', '{"update_id":143852913,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":183,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (282, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:00:09', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (283, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:00:09', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (284, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:00:29', 'telegram', '{"update_id":143852914,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":185,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (285, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:00:29', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (286, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:00:29', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (287, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:01:16', 'telegram', '{"update_id":143852915,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":187,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (288, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:01:16', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (289, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:01:16', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (290, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:01:31', 'telegram', '{"update_id":143852916,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":189,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (291, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:01:34', 'telegram', '{"input":{"module":"alerts"},"output":{"title":"Alerts","headers":["Asset","Severity","Status","Message","Time"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (292, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-20 20:01:34', 'telegram', '{"input":{"module":"alerts"},"output":{"title":"Alerts","headers":["Asset","Severity","Status","Message","Time"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (293, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-21 12:58:08', 'telegram', '{"update_id":143852917,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":191,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (294, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 12:57:24', 'telegram', '{"update_id":143852918,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":193,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (295, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 12:57:26', 'telegram', '{"input":{"module":"workorders"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-0209","CP-01","open","medium","2026-01-22"],["WO-0210","CR-01","open","medium","2026-01-18"],["WO-0211","CR-02","open","medium","2026-01-25"],["WO-0212","CS-01","open","medium","2026-01-23"],["WO-0213","CV-03","open","medium","2026-01-22"],["WO-0214","D-04","open","medium","2026-01-24"],["WO-0215","DR-01","open","medium","2026-01-24"],["WO-0216","EX-09","open","medium","2026-01-21"],["WO-0217","EX-12","open","medium","2026-01-21"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-0209 | CP-01 | open | medium | 2026-01-22\nWO-0210 | CR-01 | open | medium | 2026-01-18\nWO-0211 | CR-02 | open | medium | 2026-01-25\nWO-0212 | CS-01 | open | medium | 2026-01-23\nWO-0213 | CV-03 | open | medium | 2026-01-22\nWO-0214 | D-04 | open | medium | 2026-01-24\nWO-0215 | DR-01 | open | medium | 2026-01-24"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (296, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 12:57:26', 'telegram', '{"input":{"module":"workorders"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-0209","CP-01","open","medium","2026-01-22"],["WO-0210","CR-01","open","medium","2026-01-18"],["WO-0211","CR-02","open","medium","2026-01-25"],["WO-0212","CS-01","open","medium","2026-01-23"],["WO-0213","CV-03","open","medium","2026-01-22"],["WO-0214","D-04","open","medium","2026-01-24"],["WO-0215","DR-01","open","medium","2026-01-24"],["WO-0216","EX-09","open","medium","2026-01-21"],["WO-0217","EX-12","open","medium","2026-01-21"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-0209 | CP-01 | open | medium | 2026-01-22\nWO-0210 | CR-01 | open | medium | 2026-01-18\nWO-0211 | CR-02 | open | medium | 2026-01-25\nWO-0212 | CS-01 | open | medium | 2026-01-23\nWO-0213 | CV-03 | open | medium | 2026-01-22\nWO-0214 | D-04 | open | medium | 2026-01-24\nWO-0215 | DR-01 | open | medium | 2026-01-24"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (297, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 12:57:30', 'telegram', '{"update_id":143852919,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":194,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (298, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 12:57:39', 'telegram', '{"update_id":1,"update_type":"message","chat_id":123,"telegram_user_id":999,"has_attachments":false,"raw":{"message_id":1,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (299, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:00:54', 'telegram', '{"update_id":143852920,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":197,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (300, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:00:54', 'telegram', '{"input":{"department":"Crushing needed","priority":"high","reason":"Conveyor"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (301, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:00:54', 'telegram', '{"input":{"department":"Crushing needed","priority":"high","reason":"Conveyor"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (302, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:15', 'telegram', '{"update_id":143852921,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":199,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (303, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:16', 'telegram', '{"input":{"sku":"IDLER-SET-650","qty":"10","est":"22.50","pr":"PR-XXXXX"},"output":{"message":"Purchase request not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (304, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:16', 'telegram', '{"input":{"sku":"IDLER-SET-650","qty":"10","est":"22.50","pr":"PR-XXXXX"},"output":{"message":"Purchase request not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (305, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:27', 'telegram', '{"update_id":143852922,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":201,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (306, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:31', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (307, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:31', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (308, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:50', 'telegram', '{"update_id":143852923,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":203,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (309, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:52', 'telegram', '{"input":{"module":"assets","q":"BP-01"},"output":{"message":"Asset not found. Try \/list module=assets."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (310, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:01:52', 'telegram', '{"input":{"module":"assets","q":"BP-01"},"output":{"message":"Asset not found. Try \/list module=assets."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (311, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:12', 'telegram', '{"update_id":143852924,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":205,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (312, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:12', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (313, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:12', 'telegram', '{"input":{"module":"assets"},"output":{"title":"Assets","headers":["Tag","Name","Status","Location"],"rows":[["BP-01","Batch Plant BP-01","active","Concrete Plant"],["CP-01","Concrete Pump CP-01","active","Concrete Plant"],["CR-01","Primary Crusher CR-01","active","Crushing Plant"],["CR-02","Secondary Crusher CR-02","active","Crushing Plant"],["CS-01","Cement Silo CS-01","active","Concrete Plant"],["CV-03","Conveyor CV-03","active","Crushing Plant"],["D-04","Dozer D-04","active","Fourways Quarry"],["DR-01","Drill Rig DR-01","active","Fourways Quarry"],["EX-09","Excavator EX-09","active","Fourways Quarry"],["EX-12","Excavator EX-12","active","Fourways Quarry"]],"message":"Assets:\nBP-01 | Batch Plant BP-01 | active | Concrete Plant\nCP-01 | Concrete Pump CP-01 | active | Concrete Plant\nCR-01 | Primary Crusher CR-01 | active | Crushing Plant\nCR-02 | Secondary Crusher CR-02 | active | Crushing Plant\nCS-01 | Cement Silo CS-01 | active | Concrete Plant\nCV-03 | Conveyor CV-03 | active | Crushing Plant\nD-04 | Dozer D-04 | active | Fourways Quarry\nDR-01 | Drill Rig DR-01 | active | Fourways Quarry"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (314, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:35', 'telegram', '{"update_id":143852925,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":207,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (315, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:35', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (316, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:35', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (317, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:50', 'telegram', '{"update_id":143852926,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":209,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (318, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:50', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (319, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:02:50', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (320, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:03:13', 'telegram', '{"update_id":143852927,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":211,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (321, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:03:13', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (322, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:03:13', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (323, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:04:09', 'telegram', '{"update_id":143852928,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":213,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (324, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:04:09', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (325, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:04:09', 'telegram', '{"input":{"module":"reports","format":"pdf"},"output":{"message":"No data available to export."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (326, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:18:57', 'telegram', '{"update_id":143852929,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":215,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (327, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:18:57', 'telegram', '{"input":{"needed_by":"Friday"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (328, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:18:57', 'telegram', '{"input":{"needed_by":"Friday"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (329, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:16', 'telegram', '{"update_id":143852930,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":217,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (330, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:16', 'telegram', '{"input":{"needed_by":"Friday"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (331, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:16', 'telegram', '{"input":{"needed_by":"Friday"},"output":{"message":"Database schema is out of date. Please run migrations: php artisan migrate."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (332, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:36', 'telegram', '{"update_id":143852931,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":219,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (333, 31, 1, 'purchase_requests.approve', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:37', 'telegram', '{"input":{"pr":"PR-00451"},"output":{"message":"Purchase request not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (334, 31, 1, 'purchase_requests.approve', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:37', 'telegram', '{"input":{"pr":"PR-00451"},"output":{"message":"Purchase request not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (335, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:53', 'telegram', '{"update_id":143852932,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":221,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (336, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:56', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (337, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:20:56', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (338, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:21:36', 'telegram', '{"update_id":143852933,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":223,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (339, 31, 1, 'purchase_requests.approve', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:21:36', 'telegram', '{"input":{"pr":"PR-00451"},"output":{"message":"Purchase request not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (340, 31, 1, 'purchase_requests.approve', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:21:36', 'telegram', '{"input":{"pr":"PR-00451"},"output":{"message":"Purchase request not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (341, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:21:44', 'telegram', '{"update_id":143852934,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":225,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (342, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:21:46', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",36,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 36 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (343, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:21:46', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",36,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 36 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (344, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:22:57', 'telegram', '{"update_id":143852935,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":227,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (345, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:23:03', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",36,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 36 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (346, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:23:03', 'telegram', '{"input":{"module":"kpi"},"output":{"title":"KPI Summary","headers":["KPI","Value","Notes"],"rows":[["Total Assets",154,"All registered assets"],["Active Assets",154,"Status = active"],["Open Work Orders",36,"Status = open"],["Pending Maintenance",35,"Status = pending"],["Open Alerts",0,"Status = open"]],"message":"KPI Summary:\nTotal Assets | 154 | All registered assets\nActive Assets | 154 | Status = active\nOpen Work Orders | 36 | Status = open\nPending Maintenance | 35 | Status = pending\nOpen Alerts | 0 | Status = open"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (347, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:23:16', 'telegram', '{"update_id":143852936,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":229,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (348, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:23:16', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (349, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:23:16', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (350, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:48', 'telegram', '{"update_id":143852937,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":231,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (351, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:48', 'telegram', '{"input":{"needed_by":"Friday"},"output":{"message":"PR-00001 created. Reply \/pr add PR-00001 sku=... qty=... est=... or SUBMIT PR-00001."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (352, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:48', 'telegram', '{"input":{"needed_by":"Friday"},"output":{"message":"PR-00001 created. Reply \/pr add PR-00001 sku=... qty=... est=... or SUBMIT PR-00001."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (353, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:49', 'telegram', '{"input":{"pr":"PR-00001","description":"idlers 650mm","qty":10},"output":{"message":"Line added to PR-00001. Reply SUBMIT PR-00001 when ready."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (354, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:49', 'telegram', '{"input":{"pr":"PR-00001","description":"idlers 650mm","qty":10},"output":{"message":"Line added to PR-00001. Reply SUBMIT PR-00001 when ready."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (355, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:49', 'telegram', '{"input":{"pr":"PR-00001","description":"bearings 22220 needed by Friday","qty":2},"output":{"message":"Line added to PR-00001. Reply SUBMIT PR-00001 when ready."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (356, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:24:49', 'telegram', '{"input":{"pr":"PR-00001","description":"bearings 22220 needed by Friday","qty":2},"output":{"message":"Line added to PR-00001. Reply SUBMIT PR-00001 when ready."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (357, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:25:27', 'telegram', '{"update_id":143852938,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":233,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (358, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:25:28', 'telegram', '{"input":{"pr":"PR-00001"},"output":{"message":"PR PR-00001 submitted for approval."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (359, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:25:28', 'telegram', '{"input":{"pr":"PR-00001"},"output":{"message":"PR PR-00001 submitted for approval."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (360, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:25:45', 'telegram', '{"update_id":143852939,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":235,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (361, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:25:48', 'telegram', '{"input":{"module":"purchase_requests","id":"PR-00001"},"output":{"message":"Purchase request not found. Try \/list module=purchase_requests."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (362, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:25:48', 'telegram', '{"input":{"module":"purchase_requests","id":"PR-00001"},"output":{"message":"Purchase request not found. Try \/list module=purchase_requests."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (363, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:26:16', 'telegram', '{"update_id":143852940,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":237,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (364, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:26:19', 'telegram', '{"input":{"module":"purchase_requests","id":"PR-00001"},"output":{"message":"Purchase request not found. Try \/list module=purchase_requests."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (365, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:26:19', 'telegram', '{"input":{"module":"purchase_requests","id":"PR-00001"},"output":{"message":"Purchase request not found. Try \/list module=purchase_requests."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (366, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:26:33', 'telegram', '{"update_id":143852941,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":239,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (367, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:26:33', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-00001","Telegram PR","-","submitted","medium"],["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-00001 | Telegram PR | - | submitted | medium\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (368, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 13:26:33', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-00001","Telegram PR","-","submitted","medium"],["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-00001 | Telegram PR | - | submitted | medium\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (369, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:33:19', 'telegram', '{"update_id":143852942,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":241,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (370, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:33:21', 'telegram', '{"input":{"asset":"EXC-01","title":"EXC-01 hydraulic hose leak near boom"},"output":{"message":"Asset not found. Try \/list module=assets to see available tags."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (371, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:33:21', 'telegram', '{"input":{"asset":"EXC-01","title":"EXC-01 hydraulic hose leak near boom"},"output":{"message":"Asset not found. Try \/list module=assets to see available tags."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (372, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:34:38', 'telegram', '{"update_id":143852943,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":243,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (373, 31, 1, 'parts.search', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:34:38', 'telegram', '{"input":{"q":"oil filter"},"output":{"message":"No parts found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (374, 31, 1, 'parts.search', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:34:38', 'telegram', '{"input":{"q":"oil filter"},"output":{"message":"No parts found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (375, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:35:35', 'telegram', '{"update_id":143852944,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":245,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (376, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:35:35', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (377, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:35:35', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (378, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:37:05', 'telegram', '{"update_id":143852945,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":247,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (379, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:37:05', 'telegram', '{"input":{"module":"maintenance","asset":"EXC-01"},"output":{"message":"Asset not found. Try \/list module=assets."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (380, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:37:05', 'telegram', '{"input":{"module":"maintenance","asset":"EXC-01"},"output":{"message":"Asset not found. Try \/list module=assets."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (381, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:38:21', 'telegram', '{"update_id":143852946,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":249,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (382, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:38:21', 'telegram', '{"input":{"module":"maintenance","asset":"EXC-01"},"output":{"message":"Asset not found. Try \/list module=assets."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (383, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:38:21', 'telegram', '{"input":{"module":"maintenance","asset":"EXC-01"},"output":{"message":"Asset not found. Try \/list module=assets."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (384, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:38:54', 'telegram', '{"update_id":143852947,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":251,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (385, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:38:54', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (386, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:38:54', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (387, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:39:13', 'telegram', '{"update_id":143852948,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":253,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (388, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:39:13', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (389, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:39:13', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (390, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:41:04', 'telegram', '{"update_id":143852949,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":255,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (391, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:42:14', 'telegram', '{"update_id":143852950,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":257,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (392, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:45:25', 'telegram', '{"update_id":143852951,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":259,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (393, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:45:25', 'telegram', '{"input":{"asset":"BP-01","title":"Hydraulic leak"},"output":{"message":"WO created: WO-P0DXIB. Reply: ASSIGN WO-P0DXIB @TechName or ADD PARTS WO-P0DXIB."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (394, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:45:25', 'telegram', '{"input":{"asset":"BP-01","title":"Hydraulic leak"},"output":{"message":"WO created: WO-P0DXIB. Reply: ASSIGN WO-P0DXIB @TechName or ADD PARTS WO-P0DXIB."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (395, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:45:48', 'telegram', '{"update_id":143852952,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":261,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (396, 31, 1, 'workorders.add_parts', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:45:49', 'telegram', '{"input":{"wo":"WO-P0DXIB","sku":"WO-P0DXIB","qty":null},"output":{"message":"Part not found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (397, 31, 1, 'workorders.add_parts', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:45:49', 'telegram', '{"input":{"wo":"WO-P0DXIB","sku":"WO-P0DXIB","qty":null},"output":{"message":"Part not found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (398, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:46:57', 'telegram', '{"update_id":143852953,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":263,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (399, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:46:57', 'telegram', '{"input":{"wo":"WO-P0DXIB"},"output":{"message":"Provide user= for assignment."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (400, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:46:57', 'telegram', '{"input":{"wo":"WO-P0DXIB"},"output":{"message":"Provide user= for assignment."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (401, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:47:07', 'telegram', '{"update_id":143852954,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":265,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (402, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:47:07', 'telegram', '{"input":{"wo":"WO-P0DXIB"},"output":{"message":"Provide user= for assignment."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (403, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:47:07', 'telegram', '{"input":{"wo":"WO-P0DXIB"},"output":{"message":"Provide user= for assignment."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (404, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:47:19', 'telegram', '{"update_id":143852955,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":267,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (405, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:47:19', 'telegram', '{"input":{"wo":"WO-P0DXIB"},"output":{"message":"Provide user= for assignment."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (406, 31, 1, 'workorders.assign', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:47:19', 'telegram', '{"input":{"wo":"WO-P0DXIB"},"output":{"message":"Provide user= for assignment."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (407, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:49:25', 'telegram', '{"update_id":143852956,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":269,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (408, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:49:50', 'telegram', '{"update_id":143852957,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":271,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (409, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:50:50', 'telegram', '{"update_id":143852958,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":273,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (410, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:50:58', 'telegram', '{"input":{"module":"assets","format":"pdf"},"output":{"message":"Export ready: assets_20260122_175053.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260122_175053.pdf","filename":"assets_20260122_175053.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (411, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:50:58', 'telegram', '{"input":{"module":"assets","format":"pdf"},"output":{"message":"Export ready: assets_20260122_175053.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\assets_20260122_175053.pdf","filename":"assets_20260122_175053.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (412, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:54:04', 'telegram', '{"update_id":143852959,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":276,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (413, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:54:04', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-P0DXIB","BP-01","open","medium","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-P0DXIB | BP-01 | open | medium | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (414, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:54:04', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-P0DXIB","BP-01","open","medium","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-P0DXIB | BP-01 | open | medium | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (415, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:54:53', 'telegram', '{"update_id":143852960,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":278,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (416, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:54:56', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf"},"output":{"message":"Export ready: purchase-requests_20260122_175456.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260122_175456.pdf","filename":"purchase-requests_20260122_175456.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (417, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:54:56', 'telegram', '{"input":{"module":"purchase_requests","format":"pdf"},"output":{"message":"Export ready: purchase-requests_20260122_175456.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase-requests_20260122_175456.pdf","filename":"purchase-requests_20260122_175456.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (418, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:56:35', 'telegram', '{"update_id":143852961,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":281,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (419, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:56:35', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-P0DXIB","BP-01","open","medium","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-P0DXIB | BP-01 | open | medium | -\nWO-UK3VPT | BP-01 | open | medium | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (420, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:56:35', 'telegram', '{"input":{"module":"workorders","asset":"BP-01"},"output":{"title":"Work Orders","headers":["Ref","Asset","Status","Priority","Due"],"rows":[["WO-0208","BP-01","open","medium","2026-01-20"],["WO-232","BP-01","open","medium","2026-01-19"],["WO-9SM8SF","BP-01","open","high","-"],["WO-P0DXIB","BP-01","open","medium","-"],["WO-UK3VPT","BP-01","open","medium","-"]],"message":"Work Orders:\nWO-0208 | BP-01 | open | medium | 2026-01-20\nWO-232 | BP-01 | open | medium | 2026-01-19\nWO-9SM8SF | BP-01 | open | high | -\nWO-P0DXIB | BP-01 | open | medium | -\nWO-UK3VPT | BP-01 | open | medium | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (421, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:56:49', 'telegram', '{"update_id":143852962,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":283,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (422, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:56:49', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (423, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:56:49', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (424, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:57:45', 'telegram', '{"update_id":143852963,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":285,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (425, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:57:45', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (426, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:57:45', 'telegram', '{"input":{"module":"inventory"},"output":{"title":"Inventory","headers":["SKU","Part","Location","Qty","Min","Max"],"rows":[["FLT-100","Hydraulic Filter","Main Store",28,6,50],["OIL-80W","Engine Oil 80W","Main Store",28,6,50],["BRG-220","Conveyor Bearing","Main Store",28,6,50]],"message":"Inventory:\nFLT-100 | Hydraulic Filter | Main Store | 28 | 6 | 50\nOIL-80W | Engine Oil 80W | Main Store | 28 | 6 | 50\nBRG-220 | Conveyor Bearing | Main Store | 28 | 6 | 50"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (427, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:58:33', 'telegram', '{"update_id":143852964,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":287,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (428, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:58:33', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (429, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-22 17:58:33', 'telegram', '{"input":{"module":"maintenance","asset":"BP-01"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nBP-01 | pending | 2026-01-23 | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (430, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:36:06', 'telegram', '{"update_id":143852965,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":289,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (431, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:36:06', 'telegram', '{"input":{"module":"maintenance","format":"pdf"},"output":{"message":"Export ready: maintenance_20260122_223606.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\maintenance_20260122_223606.pdf","filename":"maintenance_20260122_223606.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (432, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:36:06', 'telegram', '{"input":{"module":"maintenance","format":"pdf"},"output":{"message":"Export ready: maintenance_20260122_223606.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\maintenance_20260122_223606.pdf","filename":"maintenance_20260122_223606.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (433, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:37:27', 'telegram', '{"update_id":143852966,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":292,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (434, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:37:27', 'telegram', '{"input":{"module":"inventory","to":"ry format","format":"pdf"},"output":{"message":"Export ready: inventory_20260122_223727.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\inventory_20260122_223727.pdf","filename":"inventory_20260122_223727.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (435, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:37:28', 'telegram', '{"input":{"module":"inventory","to":"ry format","format":"pdf"},"output":{"message":"Export ready: inventory_20260122_223727.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\inventory_20260122_223727.pdf","filename":"inventory_20260122_223727.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (436, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:38:55', 'telegram', '{"update_id":143852967,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":295,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (437, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:38:55', 'telegram', '{"input":{"module":"workorders","format":"pdf"},"output":{"message":"Export ready: work-orders_20260122_223855.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\work-orders_20260122_223855.pdf","filename":"work-orders_20260122_223855.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (438, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:38:55', 'telegram', '{"input":{"module":"workorders","format":"pdf"},"output":{"message":"Export ready: work-orders_20260122_223855.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\work-orders_20260122_223855.pdf","filename":"work-orders_20260122_223855.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (439, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:42:31', 'telegram', '{"update_id":143852968,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":298,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (440, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:42:31', 'telegram', '{"input":{"module":"inventory","to":"ck pdf","format":"pdf"},"output":{"message":"Export ready: inventory_20260122_224231.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\inventory_20260122_224231.pdf","filename":"inventory_20260122_224231.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (441, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:42:31', 'telegram', '{"input":{"module":"inventory","to":"ck pdf","format":"pdf"},"output":{"message":"Export ready: inventory_20260122_224231.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\inventory_20260122_224231.pdf","filename":"inventory_20260122_224231.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (442, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:43:32', 'telegram', '{"update_id":143852969,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":301,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (443, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:43:32', 'telegram', '{"input":{"reason":"2 paint tins"},"output":{"message":"PR-00002 created. Reply \/pr add PR-00002 sku=... qty=... est=... or SUBMIT PR-00002."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (444, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:43:32', 'telegram', '{"input":{"reason":"2 paint tins"},"output":{"message":"PR-00002 created. Reply \/pr add PR-00002 sku=... qty=... est=... or SUBMIT PR-00002."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (445, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:43:32', 'telegram', '{"input":{"pr":"PR-00002","description":"paint tins","qty":2},"output":{"message":"Line added to PR-00002. Reply SUBMIT PR-00002 when ready."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (446, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:43:32', 'telegram', '{"input":{"pr":"PR-00002","description":"paint tins","qty":2},"output":{"message":"Line added to PR-00002. Reply SUBMIT PR-00002 when ready."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (447, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:45:04', 'telegram', '{"update_id":143852970,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":303,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (448, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:45:35', 'telegram', '{"update_id":143852971,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":305,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (449, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:45:35', 'telegram', '{"input":{"pr":"PR-00002"},"output":{"message":"PR PR-00002 submitted for approval."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (450, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-22 22:45:35', 'telegram', '{"input":{"pr":"PR-00002"},"output":{"message":"PR PR-00002 submitted for approval."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (451, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 09:56:35', 'telegram', '{"update_id":143852972,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":307,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (452, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 09:56:41', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-00001","Telegram PR","-","submitted","medium"],["PR-00002","2 paint tins","-","submitted","medium"],["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-00001 | Telegram PR | - | submitted | medium\nPR-00002 | 2 paint tins | - | submitted | medium\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (453, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 09:56:41', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-00001","Telegram PR","-","submitted","medium"],["PR-00002","2 paint tins","-","submitted","medium"],["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-00001 | Telegram PR | - | submitted | medium\nPR-00002 | 2 paint tins | - | submitted | medium\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (454, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:05:44', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (455, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:05:50', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (456, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:05:55', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (457, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:06:03', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (458, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:06:15', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (459, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:06:43', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (460, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:07:20', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (461, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:08:28', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (462, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:10:01', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (463, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:11:20', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (464, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:13:23', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (465, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:15:05', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (466, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:16:58', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (467, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:19:07', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (468, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:20:15', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (469, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:22:17', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (470, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:24:07', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (471, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:25:44', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (472, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:27:49', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (473, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:28:55', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (474, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:30:11', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (475, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:32:03', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (476, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:33:46', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (477, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:35:42', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (478, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:37:18', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (479, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:38:43', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (480, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:40:29', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (481, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:42:06', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (482, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:43:53', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (483, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:45:51', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (484, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:47:22', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (485, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:49:09', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (486, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:50:53', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (487, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:52:08', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (488, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:53:27', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (489, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:55:17', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (490, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:56:52', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (491, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 10:58:55', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (492, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:00:06', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (493, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:02:07', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (494, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:03:56', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (495, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:05:07', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (496, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:06:29', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (497, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:08:18', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (498, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:09:42', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (499, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:11:33', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (500, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:13:04', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (501, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:14:52', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (502, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:16:16', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (503, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:17:35', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (504, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:19:30', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (505, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:20:49', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (506, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:22:54', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (507, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:24:50', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (508, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:26:11', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (509, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:27:54', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (510, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:29:13', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (511, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:31:03', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (512, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:33:05', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (513, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:34:21', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (514, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:35:40', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (515, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:37:43', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (516, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:38:59', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (517, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:40:32', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (518, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:42:02', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (519, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:43:52', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (520, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:45:37', 'telegram', '{"update_id":143852973,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":309,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (521, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:47:29', 'telegram', '{"update_id":143852985,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":321,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (522, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:47:32', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-00001","Telegram PR","-","submitted","medium"],["PR-00002","2 paint tins","-","submitted","medium"],["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-00001 | Telegram PR | - | submitted | medium\nPR-00002 | 2 paint tins | - | submitted | medium\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (523, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:47:32', 'telegram', '{"input":{"module":"purchase_requests"},"output":{"title":"Purchase Requests","headers":["Code","Title","Site","Status","Priority"],"rows":[["PR-00001","Telegram PR","-","submitted","medium"],["PR-00002","2 paint tins","-","submitted","medium"],["PR-AI-3","Chatbot Intake","-","pending","medium"],["PR-GOR-001","Goromonzi Quarry Procurement - Procurement 8-12-25","Goromonzi Quarry","pending","medium"],["PR-GOR-002","Goromonzi Quarry Procurement - Procurement 8-12-25  (2)","Goromonzi Quarry","pending","medium"]],"message":"Purchase Requests:\nPR-00001 | Telegram PR | - | submitted | medium\nPR-00002 | 2 paint tins | - | submitted | medium\nPR-AI-3 | Chatbot Intake | - | pending | medium\nPR-GOR-001 | Goromonzi Quarry Procurement - Procurement 8-12-25 | Goromonzi Quarry | pending | medium\nPR-GOR-002 | Goromonzi Quarry Procurement - Procurement 8-12-25  (2) | Goromonzi Quarry | pending | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (524, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:48:50', 'telegram', '{"update_id":143852986,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":323,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (525, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:48:54', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (526, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:49:05', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (527, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:49:13', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (528, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:49:20', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (529, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:49:32', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (530, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:49:51', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (531, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:50:27', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (532, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 11:51:38', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (533, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:20:54', 'telegram', '{"update_id":143852987,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":324,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (534, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:22:46', 'telegram', '{"update_id":143852991,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":329,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (535, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:24:17', 'telegram', '{"update_id":143852992,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":331,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (536, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:24:17', 'telegram', '{"input":{"module":"maintenance"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["CP-01","pending","2026-01-31","-"],["CR-01","pending","2026-01-28","-"],["CR-02","pending","2026-02-02","-"],["CS-01","pending","2026-01-18","-"],["CV-03","pending","2026-01-21","-"],["D-04","pending","2026-01-31","-"],["DR-01","pending","2026-01-29","-"],["EX-09","pending","2026-01-18","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nCP-01 | pending | 2026-01-31 | -\nCR-01 | pending | 2026-01-28 | -\nCR-02 | pending | 2026-02-02 | -\nCS-01 | pending | 2026-01-18 | -\nCV-03 | pending | 2026-01-21 | -\nD-04 | pending | 2026-01-31 | -\nDR-01 | pending | 2026-01-29 | -"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (537, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:24:17', 'telegram', '{"input":{"module":"maintenance"},"output":{"title":"Maintenance","headers":["Asset","Status","Scheduled","Completed"],"rows":[["BP-01","pending","2026-01-26","-"],["CP-01","pending","2026-01-31","-"],["CR-01","pending","2026-01-28","-"],["CR-02","pending","2026-02-02","-"],["CS-01","pending","2026-01-18","-"],["CV-03","pending","2026-01-21","-"],["D-04","pending","2026-01-31","-"],["DR-01","pending","2026-01-29","-"],["EX-09","pending","2026-01-18","-"],["BP-01","pending","2026-01-23","-"]],"message":"Maintenance:\nBP-01 | pending | 2026-01-26 | -\nCP-01 | pending | 2026-01-31 | -\nCR-01 | pending | 2026-01-28 | -\nCR-02 | pending | 2026-02-02 | -\nCS-01 | pending | 2026-01-18 | -\nCV-03 | pending | 2026-01-21 | -\nD-04 | pending | 2026-01-31 | -\nDR-01 | pending | 2026-01-29 | -"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (538, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:24:42', 'telegram', '{"update_id":143852993,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":333,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (539, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:24:42', 'telegram', '{"input":{"module":"maintenance","asset":"FW-QUARRY-MAINT"},"output":{"message":"Asset not found. Try \/list module=assets."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (540, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:24:42', 'telegram', '{"input":{"module":"maintenance","asset":"FW-QUARRY-MAINT"},"output":{"message":"Asset not found. Try \/list module=assets."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (541, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:06', 'telegram', '{"update_id":143852994,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":335,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (542, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:12', 'telegram', '{"input":{"module":"alerts","status":"open"},"output":{"title":"Alerts","headers":["Asset","Severity","Status","Message","Time"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (543, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:12', 'telegram', '{"input":{"module":"alerts","status":"open"},"output":{"title":"Alerts","headers":["Asset","Severity","Status","Message","Time"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (544, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:31', 'telegram', '{"update_id":143852995,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":337,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (545, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:36', 'telegram', '{"input":{"department":"Crushing needed","priority":"high","reason":"Conveyor\\"},"output":{"message":"PR-00003 created. Reply \/pr add PR-00003 sku=... qty=... est=... or SUBMIT PR-00003.","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase_request_PR-00003_20260123_172531.pdf","filename":"purchase_request_PR-00003_20260123_172531.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (546, 31, 1, 'purchase_requests.create', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:36', 'telegram', '{"input":{"department":"Crushing needed","priority":"high","reason":"Conveyor\\"},"output":{"message":"PR-00003 created. Reply \/pr add PR-00003 sku=... qty=... est=... or SUBMIT PR-00003.","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\purchase_request_PR-00003_20260123_172531.pdf","filename":"purchase_request_PR-00003_20260123_172531.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (547, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:36', 'telegram', '{"input":{"pr":"PR-00003","description":"priority","qty":30},"output":{"message":"Line added to PR-00003. Reply SUBMIT PR-00003 when ready."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (548, 31, 1, 'purchase_requests.add_line', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:36', 'telegram', '{"input":{"pr":"PR-00003","description":"priority","qty":30},"output":{"message":"Line added to PR-00003. Reply SUBMIT PR-00003 when ready."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (549, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:36', 'telegram', '{"input":{"pr":"PR-00003"},"output":{"message":"PR PR-00003 submitted for approval."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (550, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:25:36', 'telegram', '{"input":{"pr":"PR-00003"},"output":{"message":"PR PR-00003 submitted for approval."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (551, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:26:23', 'telegram', '{"update_id":143852996,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":341,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (552, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:26:24', 'telegram', '{"input":{"pr":"PR-00003"},"output":{"message":"PR PR-00003 submitted for approval."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (553, 31, 1, 'purchase_requests.submit', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:26:24', 'telegram', '{"input":{"pr":"PR-00003"},"output":{"message":"PR PR-00003 submitted for approval."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (554, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:26:56', 'telegram', '{"update_id":143852997,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":344,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (555, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:27:00', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (556, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:27:00', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (557, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:27:35', 'telegram', '{"update_id":143852998,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":346,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (558, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:27:38', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (559, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:27:38', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (560, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:29:12', 'telegram', '{"update_id":143852999,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":348,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (561, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:29:15', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (562, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:29:15', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (563, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:37:28', 'telegram', '{"update_id":143853000,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":350,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (564, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:37:31', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (565, 31, 1, 'data.list', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:37:31', 'telegram', '{"input":{"module":"reports"},"output":{"title":"Reports","headers":["Type","Period","Summary"],"rows":[],"message":"No records found."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (566, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:53:40', 'telegram', '{"update_id":143853001,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":352,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (567, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:53:59', 'telegram', '{"update_id":143853002,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":354,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (568, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:55:00', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (569, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:55:09', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (570, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:55:14', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (571, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:55:22', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (572, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:55:33', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (573, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:55:53', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (574, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:56:27', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (575, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:57:49', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (576, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 17:59:00', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (577, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:00:58', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (578, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:02:27', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (579, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:03:58', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (580, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:06:08', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (581, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:07:46', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (582, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:09:00', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (583, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:10:44', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (584, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:12:00', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (585, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:14:00', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (586, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:15:29', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (587, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:17:31', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (588, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:19:26', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (589, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:07', 'telegram', '{"update_id":143853003,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":true,"raw":{"message_id":356,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (590, 31, 1, 'telegram.intake', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:18', 'telegram', '{"intake_id":96,"batch_id":34,"file":"photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg"}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (591, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:20', 'telegram', '{"update_id":143853004,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":357,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (592, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:24', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (593, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:24', 'telegram', '{"input":{"module":"purchase_requests","q":"PR-00003"},"output":{"title":"Purchase Request Detail","headers":["Field","Value"],"rows":[["Code","PR-00001"],["Title","Telegram PR"],["Site","-"],["Status","submitted"],["Priority","medium"]],"message":"Purchase Request Detail:\nCode | PR-00001\nTitle | Telegram PR\nSite | -\nStatus | submitted\nPriority | medium"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (594, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:26', 'telegram', '{"update_id":143853005,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":358,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (595, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:27', 'telegram', '{"update_id":143853006,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":359,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (596, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:34', 'telegram', '{"input":{"module":"workorders","format":"pdf"},"output":{"message":"Export ready: work-orders_20260123_182127.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\work-orders_20260123_182127.pdf","filename":"work-orders_20260123_182127.pdf"}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (597, 31, 1, 'data.export', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:34', 'telegram', '{"input":{"module":"workorders","format":"pdf"},"output":{"message":"Export ready: work-orders_20260123_182127.pdf","file_path":"C:\\Users\\hp\\Desktop\\AI\\SAAS\\laravel-ai-asset-fleet-saas-1\\storage\\app\/telegram-exports\\work-orders_20260123_182127.pdf","filename":"work-orders_20260123_182127.pdf"},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (598, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:21:37', 'telegram', '{"update_id":143853007,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":360,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (599, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:22:18', 'telegram', '{"update_id":143853008,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":367,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (600, 31, 1, 'telegram.intake.apply', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:22:18', 'telegram', '{"intake_id":96,"batch_id":34,"summary":{"applied":0,"skipped":0,"errors":0}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (601, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:22:35', 'telegram', '{"update_id":143853009,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":369,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (602, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:22:37', 'telegram', '{"input":{"module":"intakes","id":96},"output":{"title":"Unknown Module","headers":[],"rows":[],"message":"Unsupported module. Try \/get module=assets tag=ME-EXC-01."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (603, 31, 1, 'data.get', NULL, NULL, NULL, NULL, NULL, '2026-01-23 18:22:37', 'telegram', '{"input":{"module":"intakes","id":96},"output":{"title":"Unknown Module","headers":[],"rows":[],"message":"Unsupported module. Try \/get module=assets tag=ME-EXC-01."},"success":true}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (604, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-25 15:46:24', 'telegram', '{"update_id":10001,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":1,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (605, NULL, NULL, 'telegram.update', NULL, NULL, NULL, NULL, NULL, '2026-01-25 16:06:24', 'telegram', '{"update_id":10002,"update_type":"message","chat_id":6161130318,"telegram_user_id":6161130318,"has_attachments":false,"raw":{"message_id":2,"edited_message_id":null,"callback_query_id":null}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (606, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-25 16:06:24', 'telegram', '{"input":{"asset":"ME-EXC-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found. Try \/list module=assets to see available tags."}}');
INSERT INTO `audit_logs` (`id`, `tenant_id`, `user_id`, `action`, `entity_type`, `entity_id`, `changes`, `ip_address`, `user_agent`, `created_at`, `channel`, `payload_json`) VALUES (607, 31, 1, 'workorders.create', NULL, NULL, NULL, NULL, NULL, '2026-01-25 16:06:24', 'telegram', '{"input":{"asset":"ME-EXC-01","title":"Hydraulic leak","priority":"high"},"output":{"message":"Asset not found. Try \/list module=assets to see available tags."},"success":true}');

-- Table: chat_conversations
DROP TABLE IF EXISTS `chat_conversations`;
CREATE TABLE `chat_conversations` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `user_id` BIGINT,
    `title` TEXT,
    `status` VARCHAR(100) NOT NULL DEFAULT 'active',
    `context` TEXT,
    `last_message_at` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (1, 31, NULL, 'how many assets are in fourways group', 'active', NULL, '2026-01-14 18:46:50', '2026-01-14 18:46:50', '2026-01-14 18:46:50');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (2, 31, NULL, 'create work order', 'active', NULL, '2026-01-14 18:47:55', '2026-01-14 18:47:55', '2026-01-14 18:47:55');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (3, 31, NULL, 'Process these uploads', 'active', NULL, '2026-01-25 17:35:29', '2026-01-14 18:48:21', '2026-01-25 17:35:29');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (4, 31, NULL, 'Process upload', 'active', NULL, '2026-01-18 15:09:27', '2026-01-18 15:09:27', '2026-01-18 15:09:27');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (5, 31, NULL, 'Process upload', 'active', NULL, '2026-01-18 15:11:31', '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (6, 31, 1, 'Telegram Intake', 'active', NULL, '2026-01-23 11:45:39', '2026-01-23 11:45:39', '2026-01-23 11:45:39');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (7, 31, NULL, 'open assets', 'active', NULL, '2026-01-25 15:30:43', '2026-01-25 15:30:43', '2026-01-25 15:30:43');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (8, 31, NULL, 'open assets', 'active', NULL, '2026-01-25 15:31:22', '2026-01-25 15:31:22', '2026-01-25 15:31:22');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (9, 31, NULL, 'open assets', 'active', NULL, '2026-01-25 15:37:16', '2026-01-25 15:37:13', '2026-01-25 15:37:16');
INSERT INTO `chat_conversations` (`id`, `tenant_id`, `user_id`, `title`, `status`, `context`, `last_message_at`, `created_at`, `updated_at`) VALUES (10, 31, NULL, 'Upload asset register test', 'active', NULL, '2026-01-25 16:02:30', '2026-01-25 16:02:28', '2026-01-25 16:02:30');

-- Table: chat_messages
DROP TABLE IF EXISTS `chat_messages`;
CREATE TABLE `chat_messages` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `conversation_id` BIGINT NOT NULL,
    `user_id` BIGINT,
    `role` TEXT NOT NULL,
    `content` TEXT,
    `payload` TEXT,
    `token_count` BIGINT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (1, 31, 1, NULL, 'user', 'how many assets are in fourways group', '{"uploads":[]}', NULL, '2026-01-14 18:46:50', '2026-01-14 18:46:50');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (2, 31, 2, NULL, 'user', 'create work order', '{"uploads":[]}', NULL, '2026-01-14 18:47:55', '2026-01-14 18:47:55');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (3, 31, 3, NULL, 'user', 'Process these uploads', '{"uploads":[1]}', NULL, '2026-01-14 18:48:22', '2026-01-14 18:48:22');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (4, 31, 4, NULL, 'user', 'Process upload', '{"uploads":[2]}', NULL, '2026-01-18 15:09:27', '2026-01-18 15:09:27');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (5, 31, 5, NULL, 'user', 'Process upload', '{"uploads":[3]}', NULL, '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (6, 31, 7, NULL, 'user', 'open assets', '{"uploads":[]}', NULL, '2026-01-25 15:30:43', '2026-01-25 15:30:43');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (7, 31, 8, NULL, 'user', 'open assets', '{"uploads":[]}', NULL, '2026-01-25 15:31:22', '2026-01-25 15:31:22');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (8, 31, 9, NULL, 'user', 'open assets', '{"uploads":[]}', NULL, '2026-01-25 15:37:13', '2026-01-25 15:37:13');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (9, 31, 9, NULL, 'assistant', 'Navigating to the assets page.', '{"reply":"Navigating to the assets page.","intent":"navigate","route":"\/ui\/assets","action_label":null}', NULL, '2026-01-25 15:37:16', '2026-01-25 15:37:16');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (10, 31, 10, NULL, 'user', 'Upload asset register test', '{"uploads":[35]}', NULL, '2026-01-25 16:02:30', '2026-01-25 16:02:30');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (11, 31, 3, NULL, 'user', 'open assets', '{"uploads":[]}', NULL, '2026-01-25 17:34:53', '2026-01-25 17:34:53');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (12, 31, 3, NULL, 'assistant', '```json
{
  "reply": "Navigating to Assets.",
  "intent": "navigate",
  "route": "/ui/assets",
  "action_label": null
}
```', NULL, NULL, '2026-01-25 17:34:56', '2026-01-25 17:34:56');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (13, 31, 3, NULL, 'user', 'upload asset register', '{"uploads":[]}', NULL, '2026-01-25 17:35:08', '2026-01-25 17:35:08');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (14, 31, 3, NULL, 'assistant', '```json
{
  "reply": "Please provide the asset register file you would like to upload.",
  "intent": "upload",
  "route": "/ui/assets",
  "action_label": "Upload Asset Register"
}
```', NULL, NULL, '2026-01-25 17:35:10', '2026-01-25 17:35:10');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (15, 31, 3, NULL, 'user', 'create work order', '{"uploads":[]}', NULL, '2026-01-25 17:35:26', '2026-01-25 17:35:26');
INSERT INTO `chat_messages` (`id`, `tenant_id`, `conversation_id`, `user_id`, `role`, `content`, `payload`, `token_count`, `created_at`, `updated_at`) VALUES (16, 31, 3, NULL, 'assistant', '```json
{
  "reply": "Please provide the details for the work order you would like to create.",
  "intent": "action",
  "route": "/ui/work-orders",
  "action_label": "Create Work Order"
}
```', NULL, NULL, '2026-01-25 17:35:29', '2026-01-25 17:35:29');

-- Table: chat_uploads
DROP TABLE IF EXISTS `chat_uploads`;
CREATE TABLE `chat_uploads` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `conversation_id` BIGINT NOT NULL,
    `user_id` BIGINT,
    `original_name` TEXT NOT NULL,
    `storage_path` TEXT NOT NULL,
    `mime_type` TEXT,
    `size_bytes` BIGINT,
    `checksum` TEXT,
    `doc_type` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (1, 31, 3, NULL, 'WhatsApp Image 2026-01-05 at 10.17.00.jpeg', 'chat_uploads/31/3/1768416501_whatsapp-image-2026-01-05-at-101700.jpeg', 'image/jpeg', 79417, '34c1ce598effc7c78e69c88d1e9f70b488e4364a', NULL, '2026-01-14 18:48:22', '2026-01-14 18:48:22');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (2, 31, 4, NULL, 'Quarry Procurement.xlsx', 'chat_uploads/31/4/1768748967_quarry-procurement.xlsx', 'application/octet-stream', 143311, '2a1109881f28d3785ae05e80de459125dc456293', NULL, '2026-01-18 15:09:27', '2026-01-18 15:09:27');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (3, 31, 5, NULL, 'Quarry Procurement.xlsx', 'chat_uploads/31/5/1768749091_quarry-procurement.xlsx', 'application/octet-stream', 143311, '2a1109881f28d3785ae05e80de459125dc456293', 'purchase_request', '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (4, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114539_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:45:39', '2026-01-23 11:45:39');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (5, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114904_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:49:05', '2026-01-23 11:49:05');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (6, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114910_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:49:10', '2026-01-23 11:49:10');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (7, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114915_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:49:16', '2026-01-23 11:49:16');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (8, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114923_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:49:23', '2026-01-23 11:49:23');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (9, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114934_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:49:34', '2026-01-23 11:49:34');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (10, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114953_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:49:54', '2026-01-23 11:49:54');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (11, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_115034_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:50:34', '2026-01-23 11:50:34');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (12, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_115142_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 11:51:42', '2026-01-23 11:51:42');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (13, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_172056_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:20:56', '2026-01-23 17:20:56');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (14, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175503_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:55:04', '2026-01-23 17:55:04');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (15, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175511_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:55:11', '2026-01-23 17:55:11');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (16, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175517_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:55:17', '2026-01-23 17:55:17');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (17, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175524_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:55:24', '2026-01-23 17:55:24');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (18, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175535_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:55:35', '2026-01-23 17:55:35');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (19, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175554_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:55:54', '2026-01-23 17:55:54');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (20, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175751_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:57:51', '2026-01-23 17:57:51');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (21, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175904_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 17:59:04', '2026-01-23 17:59:04');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (22, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_180100_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:01:00', '2026-01-23 18:01:00');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (23, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_180230_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:02:30', '2026-01-23 18:02:30');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (24, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_180400_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:04:00', '2026-01-23 18:04:00');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (25, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_180610_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:06:11', '2026-01-23 18:06:11');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (26, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_180748_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:07:48', '2026-01-23 18:07:48');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (27, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_180903_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:09:03', '2026-01-23 18:09:03');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (28, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_181046_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:10:46', '2026-01-23 18:10:46');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (29, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_181202_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:12:02', '2026-01-23 18:12:02');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (30, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_181402_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:14:02', '2026-01-23 18:14:02');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (31, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_181531_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:15:31', '2026-01-23 18:15:31');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (32, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_181733_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:17:33', '2026-01-23 18:17:33');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (33, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_181927_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:19:27', '2026-01-23 18:19:27');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (34, 31, 6, 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_182112_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', 103617, '8acfc3066892f07a5fe9d86531c63383f27c448e', NULL, '2026-01-23 18:21:12', '2026-01-23 18:21:12');
INSERT INTO `chat_uploads` (`id`, `tenant_id`, `conversation_id`, `user_id`, `original_name`, `storage_path`, `mime_type`, `size_bytes`, `checksum`, `doc_type`, `created_at`, `updated_at`) VALUES (35, 31, 10, NULL, 'qa-upload.txt', 'chat_uploads/31/10/1769356948_qa-upload.txt', 'text/plain', 16, '7a0c999f9c77d4f7dfd1a7ce559ebb0f94fc5ab4', NULL, '2026-01-25 16:02:29', '2026-01-25 16:02:29');

-- Table: checklists
DROP TABLE IF EXISTS `checklists`;
CREATE TABLE `checklists` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `name` TEXT NOT NULL,
    `type` TEXT,
    `items` TEXT,
    `active` TINYINT NOT NULL DEFAULT '1',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (1, 11, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:04', '2026-01-11 14:10:04');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (2, 11, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:04', '2026-01-11 14:10:04');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (3, 21, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:53', '2026-01-11 14:10:53');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (4, 21, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:53', '2026-01-11 14:10:53');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (5, 22, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (6, 22, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (7, 23, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (8, 23, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (9, 24, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (10, 24, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (11, 25, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (12, 25, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (13, 26, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (14, 26, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (15, 27, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (16, 27, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (17, 28, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (18, 28, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (19, 29, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (20, 29, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (21, 30, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (22, 30, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test"]', 1, '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (23, 31, 'Pre-start Checks', 'pre-start', '["Visual inspection","Fluid levels","Brake test","Hydraulic lines"]', 1, '2026-01-13 20:11:11', '2026-01-13 20:11:11');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (24, 31, 'Safety Inspection', 'safety', '["Visual inspection","Fluid levels","Brake test","Hydraulic lines"]', 1, '2026-01-13 20:11:11', '2026-01-13 20:11:11');
INSERT INTO `checklists` (`id`, `tenant_id`, `name`, `type`, `items`, `active`, `created_at`, `updated_at`) VALUES (25, 31, 'Concrete Dispatch', 'inspection', '["Visual inspection","Fluid levels","Brake test","Hydraulic lines"]', 1, '2026-01-13 20:11:11', '2026-01-13 20:11:11');

-- Table: compliance_records
DROP TABLE IF EXISTS `compliance_records`;
CREATE TABLE `compliance_records` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT,
    `vehicle_id` BIGINT,
    `compliance_type` TEXT NOT NULL,
    `expiry_date` DATE,
    `status` VARCHAR(100) NOT NULL DEFAULT 'active',
    `last_notified_at` DATETIME,
    `meta_json` TEXT,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (1, 31, 165, NULL, 'ZINARA', '2025-07-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (2, 31, 165, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (3, 31, 165, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (4, 31, 165, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (5, 31, 166, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (6, 31, 166, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (7, 31, 166, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (8, 31, 166, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (9, 31, 167, NULL, 'ZINARA', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (10, 31, 167, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (11, 31, 167, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (12, 31, 167, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (13, 31, 168, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (14, 31, 168, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (15, 31, 168, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (16, 31, 168, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (17, 31, 169, NULL, 'ZINARA', '2026-03-31 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (18, 31, 169, NULL, 'INSURANCE', '2026-04-01 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (19, 31, 169, NULL, 'RADIO', '2026-03-31 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (20, 31, 169, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (21, 31, 170, NULL, 'ZINARA', '2025-10-31 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (22, 31, 170, NULL, 'INSURANCE', '2025-12-31 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (23, 31, 170, NULL, 'RADIO', '2025-10-31 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (24, 31, 170, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (25, 31, 171, NULL, 'ZINARA', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (26, 31, 171, NULL, 'INSURANCE', '2026-03-06 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (27, 31, 171, NULL, 'RADIO', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (28, 31, 171, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (29, 31, 172, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (30, 31, 172, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (31, 31, 172, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (32, 31, 172, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (33, 31, 173, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (34, 31, 173, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (35, 31, 173, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (36, 31, 173, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (37, 31, 174, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (38, 31, 174, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (39, 31, 174, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (40, 31, 174, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (41, 31, 175, NULL, 'ZINARA', '2025-11-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (42, 31, 175, NULL, 'INSURANCE', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (43, 31, 175, NULL, 'RADIO', '2025-11-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (44, 31, 175, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (45, 31, 176, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (46, 31, 176, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (47, 31, 176, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (48, 31, 176, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (49, 31, 177, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (50, 31, 177, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (51, 31, 177, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (52, 31, 177, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (53, 31, 178, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (54, 31, 178, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (55, 31, 178, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (56, 31, 178, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (57, 31, 179, NULL, 'ZINARA', '2025-07-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (58, 31, 179, NULL, 'INSURANCE', '2025-08-31 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:18');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (59, 31, 179, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (60, 31, 179, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (61, 31, 180, NULL, 'ZINARA', '2025-06-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (62, 31, 180, NULL, 'INSURANCE', '2025-12-31 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (63, 31, 180, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (64, 31, 180, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (65, 31, 181, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (66, 31, 181, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (67, 31, 181, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (68, 31, 181, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (69, 31, 182, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (70, 31, 182, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (71, 31, 182, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (72, 31, 182, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (73, 31, 183, NULL, 'ZINARA', '2025-06-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (74, 31, 183, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (75, 31, 183, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (76, 31, 183, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (77, 31, 184, NULL, 'ZINARA', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (78, 31, 184, NULL, 'INSURANCE', '2026-02-01 00:00:00', 'due_soon', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (79, 31, 184, NULL, 'RADIO', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (80, 31, 184, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (81, 31, 185, NULL, 'ZINARA', '2025-11-30 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (82, 31, 185, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (83, 31, 185, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (84, 31, 185, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (85, 31, 186, NULL, 'ZINARA', '2025-07-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (86, 31, 186, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (87, 31, 186, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (88, 31, 186, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (89, 31, 187, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (90, 31, 187, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (91, 31, 187, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (92, 31, 187, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (93, 31, 188, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (94, 31, 188, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (95, 31, 188, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (96, 31, 188, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (97, 31, 189, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (98, 31, 189, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (99, 31, 189, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (100, 31, 189, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (101, 31, 190, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (102, 31, 190, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (103, 31, 190, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (104, 31, 190, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (105, 31, 191, NULL, 'ZINARA', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (106, 31, 191, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (107, 31, 191, NULL, 'RADIO', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (108, 31, 191, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (109, 31, 192, NULL, 'ZINARA', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (110, 31, 192, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (111, 31, 192, NULL, 'RADIO', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (112, 31, 192, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (113, 31, 193, NULL, 'ZINARA', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (114, 31, 193, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (115, 31, 193, NULL, 'RADIO', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (116, 31, 193, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (117, 31, 194, NULL, 'ZINARA', '2026-02-01 00:00:00', 'due_soon', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (118, 31, 194, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (119, 31, 194, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (120, 31, 194, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (121, 31, 195, NULL, 'ZINARA', '2026-02-01 00:00:00', 'due_soon', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (122, 31, 195, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (123, 31, 195, NULL, 'RADIO', '2026-02-01 00:00:00', 'due_soon', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (124, 31, 195, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (125, 31, 196, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (126, 31, 196, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (127, 31, 196, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (128, 31, 196, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (129, 31, 197, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (130, 31, 197, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (131, 31, 197, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (132, 31, 197, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (133, 31, 198, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (134, 31, 198, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (135, 31, 198, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (136, 31, 198, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (137, 31, 199, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (138, 31, 199, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (139, 31, 199, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (140, 31, 199, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (141, 31, 200, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (142, 31, 200, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (143, 31, 200, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (144, 31, 200, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (145, 31, 201, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (146, 31, 201, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (147, 31, 201, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (148, 31, 201, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (149, 31, 202, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (150, 31, 202, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (151, 31, 202, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (152, 31, 202, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (153, 31, 203, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (154, 31, 203, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (155, 31, 203, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (156, 31, 203, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (157, 31, 204, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (158, 31, 204, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (159, 31, 204, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (160, 31, 204, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (161, 31, 205, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (162, 31, 205, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (163, 31, 205, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (164, 31, 205, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (165, 31, 206, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (166, 31, 206, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (167, 31, 206, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (168, 31, 206, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (169, 31, 207, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (170, 31, 207, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (171, 31, 207, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (172, 31, 207, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (173, 31, 208, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (174, 31, 208, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (175, 31, 208, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (176, 31, 208, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (177, 31, 209, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (178, 31, 209, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (179, 31, 209, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (180, 31, 209, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (181, 31, 210, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (182, 31, 210, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (183, 31, 210, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (184, 31, 210, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (185, 31, 211, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (186, 31, 211, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (187, 31, 211, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (188, 31, 211, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (189, 31, 212, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (190, 31, 212, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (191, 31, 212, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (192, 31, 212, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (193, 31, 213, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (194, 31, 213, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (195, 31, 213, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (196, 31, 213, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (197, 31, 214, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (198, 31, 214, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (199, 31, 214, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (200, 31, 214, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (201, 31, 215, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (202, 31, 215, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (203, 31, 215, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (204, 31, 215, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (205, 31, 216, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (206, 31, 216, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (207, 31, 216, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (208, 31, 216, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (209, 31, 217, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (210, 31, 217, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (211, 31, 217, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (212, 31, 217, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (213, 31, 218, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (214, 31, 218, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (215, 31, 218, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (216, 31, 218, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (217, 31, 219, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (218, 31, 219, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (219, 31, 219, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (220, 31, 219, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (221, 31, 220, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (222, 31, 220, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (223, 31, 220, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (224, 31, 220, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (225, 31, 221, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (226, 31, 221, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (227, 31, 221, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:16', '2026-01-25 13:50:16');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (228, 31, 221, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (229, 31, 222, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (230, 31, 222, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (231, 31, 222, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (232, 31, 222, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (233, 31, 223, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (234, 31, 223, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (235, 31, 223, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (236, 31, 223, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (237, 31, 224, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (238, 31, 224, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (239, 31, 224, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (240, 31, 224, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (241, 31, 225, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (242, 31, 225, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (243, 31, 225, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (244, 31, 225, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (245, 31, 226, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (246, 31, 226, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (247, 31, 226, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (248, 31, 226, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (249, 31, 227, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (250, 31, 227, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (251, 31, 227, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (252, 31, 227, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (253, 31, 228, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (254, 31, 228, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (255, 31, 228, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (256, 31, 228, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (257, 31, 229, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (258, 31, 229, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (259, 31, 229, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (260, 31, 229, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (261, 31, 230, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (262, 31, 230, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (263, 31, 230, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (264, 31, 230, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (265, 31, 231, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (266, 31, 231, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (267, 31, 231, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (268, 31, 231, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (269, 31, 232, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (270, 31, 232, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (271, 31, 232, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (272, 31, 232, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (273, 31, 233, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (274, 31, 233, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (275, 31, 233, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (276, 31, 233, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (277, 31, 234, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (278, 31, 234, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (279, 31, 234, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (280, 31, 234, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (281, 31, 235, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (282, 31, 235, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (283, 31, 235, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (284, 31, 235, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (285, 31, 236, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (286, 31, 236, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (287, 31, 236, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (288, 31, 236, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (289, 31, 237, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (290, 31, 237, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (291, 31, 237, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (292, 31, 237, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (293, 31, 238, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (294, 31, 238, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (295, 31, 238, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (296, 31, 238, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (297, 31, 239, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (298, 31, 239, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (299, 31, 239, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (300, 31, 239, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (301, 31, 240, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (302, 31, 240, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (303, 31, 240, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (304, 31, 240, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (305, 31, 241, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (306, 31, 241, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (307, 31, 241, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (308, 31, 241, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (309, 31, 242, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (310, 31, 242, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (311, 31, 242, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (312, 31, 242, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (313, 31, 243, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (314, 31, 243, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (315, 31, 243, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (316, 31, 243, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (317, 31, 244, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (318, 31, 244, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (319, 31, 244, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (320, 31, 244, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (321, 31, 245, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (322, 31, 245, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (323, 31, 245, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (324, 31, 245, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (325, 31, 246, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (326, 31, 246, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (327, 31, 246, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (328, 31, 246, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (329, 31, 247, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (330, 31, 247, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (331, 31, 247, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (332, 31, 247, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (333, 31, 248, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (334, 31, 248, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (335, 31, 248, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (336, 31, 248, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (337, 31, 249, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (338, 31, 249, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (339, 31, 249, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (340, 31, 249, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (341, 31, 250, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (342, 31, 250, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (343, 31, 250, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (344, 31, 250, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (345, 31, 251, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (346, 31, 251, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (347, 31, 251, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (348, 31, 251, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (349, 31, 252, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (350, 31, 252, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (351, 31, 252, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (352, 31, 252, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (353, 31, 253, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (354, 31, 253, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (355, 31, 253, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (356, 31, 253, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (357, 31, 254, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (358, 31, 254, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (359, 31, 254, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (360, 31, 254, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (361, 31, 255, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (362, 31, 255, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (363, 31, 255, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (364, 31, 255, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (365, 31, 256, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (366, 31, 256, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (367, 31, 256, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (368, 31, 256, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (369, 31, 257, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (370, 31, 257, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (371, 31, 257, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (372, 31, 257, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (373, 31, 258, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (374, 31, 258, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (375, 31, 258, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (376, 31, 258, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (377, 31, 259, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (378, 31, 259, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (379, 31, 259, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (380, 31, 259, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (381, 31, 260, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (382, 31, 260, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (383, 31, 260, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (384, 31, 260, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (385, 31, 261, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (386, 31, 261, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (387, 31, 261, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (388, 31, 261, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (389, 31, 262, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (390, 31, 262, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (391, 31, 262, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (392, 31, 262, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (393, 31, 263, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (394, 31, 263, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (395, 31, 263, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (396, 31, 263, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (397, 31, 264, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (398, 31, 264, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (399, 31, 264, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (400, 31, 264, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (401, 31, 265, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (402, 31, 265, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (403, 31, 265, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (404, 31, 265, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (405, 31, 266, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (406, 31, 266, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (407, 31, 266, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (408, 31, 266, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (409, 31, 267, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (410, 31, 267, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (411, 31, 267, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (412, 31, 267, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (413, 31, 268, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (414, 31, 268, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (415, 31, 268, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (416, 31, 268, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (417, 31, 269, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (418, 31, 269, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (419, 31, 269, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (420, 31, 269, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (421, 31, 270, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (422, 31, 270, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (423, 31, 270, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (424, 31, 270, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (425, 31, 271, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (426, 31, 271, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (427, 31, 271, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (428, 31, 271, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (429, 31, 272, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (430, 31, 272, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (431, 31, 272, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (432, 31, 272, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (433, 31, 273, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (434, 31, 273, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (435, 31, 273, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (436, 31, 273, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (437, 31, 274, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (438, 31, 274, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (439, 31, 274, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (440, 31, 274, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (441, 31, 275, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (442, 31, 275, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (443, 31, 275, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (444, 31, 275, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (445, 31, 276, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (446, 31, 276, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (447, 31, 276, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (448, 31, 276, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (449, 31, 277, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (450, 31, 277, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (451, 31, 277, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (452, 31, 277, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (453, 31, 278, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (454, 31, 278, NULL, 'INSURANCE', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (455, 31, 278, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (456, 31, 278, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (457, 31, 279, NULL, 'ZINARA', '2026-03-03 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (458, 31, 279, NULL, 'INSURANCE', '2026-04-30 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (459, 31, 279, NULL, 'RADIO', '2026-03-03 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (460, 31, 279, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (461, 31, 280, NULL, 'ZINARA', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (462, 31, 280, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (463, 31, 280, NULL, 'RADIO', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (464, 31, 280, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (465, 31, 281, NULL, 'ZINARA', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (466, 31, 281, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (467, 31, 281, NULL, 'RADIO', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (468, 31, 281, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (469, 31, 282, NULL, 'ZINARA', '2025-11-30 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (470, 31, 282, NULL, 'INSURANCE', '2026-04-30 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (471, 31, 282, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (472, 31, 282, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (473, 31, 283, NULL, 'ZINARA', '2025-07-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (474, 31, 283, NULL, 'INSURANCE', '2025-08-31 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (475, 31, 283, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (476, 31, 283, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (477, 31, 284, NULL, 'ZINARA', '2026-03-31 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (478, 31, 284, NULL, 'INSURANCE', '2026-04-30 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (479, 31, 284, NULL, 'RADIO', '2026-03-31 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (480, 31, 284, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (481, 31, 285, NULL, 'ZINARA', '2026-02-01 00:00:00', 'due_soon', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (482, 31, 285, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (483, 31, 285, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (484, 31, 285, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (485, 31, 286, NULL, 'ZINARA', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (486, 31, 286, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (487, 31, 286, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (488, 31, 286, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (489, 31, 287, NULL, 'ZINARA', '2025-11-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (490, 31, 287, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (491, 31, 287, NULL, 'RADIO', '2025-11-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (492, 31, 287, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (493, 31, 288, NULL, 'ZINARA', '2025-07-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (494, 31, 288, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (495, 31, 288, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (496, 31, 288, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (497, 31, 289, NULL, 'ZINARA', '2025-12-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (498, 31, 289, NULL, 'INSURANCE', '2025-12-21 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (499, 31, 289, NULL, 'RADIO', '2025-11-01 00:00:00', 'expired', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (500, 31, 289, NULL, 'REG BOOK', NULL, 'NO', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (501, 31, 290, NULL, 'ZINARA', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (502, 31, 290, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (503, 31, 290, NULL, 'RADIO', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (504, 31, 290, NULL, 'REG BOOK', NULL, 'YES', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (505, 31, 291, NULL, 'ZINARA', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (506, 31, 291, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (507, 31, 291, NULL, 'RADIO', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (508, 31, 291, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (509, 31, 292, NULL, 'ZINARA', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (510, 31, 292, NULL, 'INSURANCE', '2026-02-23 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (511, 31, 292, NULL, 'RADIO', '2026-02-28 00:00:00', 'ok', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:19');
INSERT INTO `compliance_records` (`id`, `tenant_id`, `asset_id`, `vehicle_id`, `compliance_type`, `expiry_date`, `status`, `last_notified_at`, `meta_json`, `created_at`, `updated_at`) VALUES (512, 31, 292, NULL, 'REG BOOK', NULL, 'missing', NULL, NULL, '2026-01-25 13:50:17', '2026-01-25 13:50:17');

-- Table: devices
DROP TABLE IF EXISTS `devices`;
CREATE TABLE `devices` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `asset_id` BIGINT,
    `name` TEXT,
    `type` TEXT,
    `identifier` TEXT,
    `meta` TEXT,
    `last_seen_at` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (1, 21, 63, 'CAN Gateway', 'CAN', 'DEV-923ZW', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (2, 21, 63, 'CAN Gateway', 'CAN', 'DEV-729QP', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (3, 21, 63, 'CAN Gateway', 'CAN', 'DEV-259FO', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (4, 21, 63, 'CAN Gateway', 'CAN', 'DEV-815RH', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (5, 22, 67, 'CAN Gateway', 'CAN', 'DEV-004KP', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (6, 22, 67, 'CAN Gateway', 'CAN', 'DEV-781CX', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (7, 22, 67, 'CAN Gateway', 'CAN', 'DEV-939QO', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (8, 22, 67, 'CAN Gateway', 'CAN', 'DEV-759WM', '{"source":"seed"}', '2026-01-11 13:10:54', '2026-01-11 14:10:54', '2026-01-11 14:10:54');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (9, 23, 75, 'CAN Gateway', 'CAN', 'DEV-307UR', '{"source":"seed"}', '2026-01-11 13:10:55', '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (10, 23, 75, 'CAN Gateway', 'CAN', 'DEV-187VK', '{"source":"seed"}', '2026-01-11 13:10:55', '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (11, 23, 75, 'CAN Gateway', 'CAN', 'DEV-227KR', '{"source":"seed"}', '2026-01-11 13:10:55', '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (12, 23, 75, 'CAN Gateway', 'CAN', 'DEV-949ES', '{"source":"seed"}', '2026-01-11 13:10:55', '2026-01-11 14:10:55', '2026-01-11 14:10:55');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (13, 24, 86, 'CAN Gateway', 'CAN', 'DEV-959ES', '{"source":"seed"}', '2026-01-11 13:10:56', '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (14, 24, 86, 'CAN Gateway', 'CAN', 'DEV-518NN', '{"source":"seed"}', '2026-01-11 13:10:56', '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (15, 24, 86, 'CAN Gateway', 'CAN', 'DEV-814FB', '{"source":"seed"}', '2026-01-11 13:10:56', '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (16, 24, 86, 'CAN Gateway', 'CAN', 'DEV-387WG', '{"source":"seed"}', '2026-01-11 13:10:56', '2026-01-11 14:10:56', '2026-01-11 14:10:56');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (17, 25, 98, 'CAN Gateway', 'CAN', 'DEV-658SN', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (18, 25, 98, 'CAN Gateway', 'CAN', 'DEV-442ZS', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (19, 25, 98, 'CAN Gateway', 'CAN', 'DEV-527QJ', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (20, 25, 98, 'CAN Gateway', 'CAN', 'DEV-247RI', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (21, 26, 104, 'CAN Gateway', 'CAN', 'DEV-449DP', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (22, 26, 104, 'CAN Gateway', 'CAN', 'DEV-315PO', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (23, 26, 104, 'CAN Gateway', 'CAN', 'DEV-716RE', '{"source":"seed"}', '2026-01-11 13:10:57', '2026-01-11 14:10:57', '2026-01-11 14:10:57');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (24, 26, 104, 'CAN Gateway', 'CAN', 'DEV-968ZE', '{"source":"seed"}', '2026-01-11 13:10:58', '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (25, 27, 113, 'CAN Gateway', 'CAN', 'DEV-192XD', '{"source":"seed"}', '2026-01-11 13:10:58', '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (26, 27, 113, 'CAN Gateway', 'CAN', 'DEV-795UY', '{"source":"seed"}', '2026-01-11 13:10:58', '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (27, 27, 113, 'CAN Gateway', 'CAN', 'DEV-769FQ', '{"source":"seed"}', '2026-01-11 13:10:58', '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (28, 27, 113, 'CAN Gateway', 'CAN', 'DEV-515VO', '{"source":"seed"}', '2026-01-11 13:10:58', '2026-01-11 14:10:58', '2026-01-11 14:10:58');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (29, 28, 121, 'CAN Gateway', 'CAN', 'DEV-939EZ', '{"source":"seed"}', '2026-01-11 13:10:59', '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (30, 28, 121, 'CAN Gateway', 'CAN', 'DEV-157GV', '{"source":"seed"}', '2026-01-11 13:10:59', '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (31, 28, 121, 'CAN Gateway', 'CAN', 'DEV-687FB', '{"source":"seed"}', '2026-01-11 13:10:59', '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (32, 28, 121, 'CAN Gateway', 'CAN', 'DEV-643HU', '{"source":"seed"}', '2026-01-11 13:10:59', '2026-01-11 14:10:59', '2026-01-11 14:10:59');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (33, 29, 128, 'CAN Gateway', 'CAN', 'DEV-137FA', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (34, 29, 128, 'CAN Gateway', 'CAN', 'DEV-794PZ', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (35, 29, 128, 'CAN Gateway', 'CAN', 'DEV-967MU', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (36, 29, 128, 'CAN Gateway', 'CAN', 'DEV-778QG', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (37, 30, 133, 'CAN Gateway', 'CAN', 'DEV-106PF', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (38, 30, 133, 'CAN Gateway', 'CAN', 'DEV-414OT', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (39, 30, 133, 'CAN Gateway', 'CAN', 'DEV-939YE', '{"source":"seed"}', '2026-01-11 13:11:00', '2026-01-11 14:11:00', '2026-01-11 14:11:00');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (40, 30, 133, 'CAN Gateway', 'CAN', 'DEV-807XU', '{"source":"seed"}', '2026-01-11 13:11:01', '2026-01-11 14:11:01', '2026-01-11 14:11:01');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (41, 31, 146, 'CAN Gateway', 'CAN', 'DEV-040FR', '{"source":"seed"}', '2026-01-13 20:10:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (42, 31, 145, 'CAN Gateway', 'CAN', 'DEV-934UW', '{"source":"seed"}', '2026-01-13 19:51:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (43, 31, 158, 'CAN Gateway', 'CAN', 'DEV-704OQ', '{"source":"seed"}', '2026-01-13 19:39:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (44, 31, 159, 'CAN Gateway', 'CAN', 'DEV-970LC', '{"source":"seed"}', '2026-01-13 20:09:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (45, 31, 164, 'CAN Gateway', 'CAN', 'DEV-317SM', '{"source":"seed"}', '2026-01-13 19:43:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (46, 31, 160, 'CAN Gateway', 'CAN', 'DEV-027ZB', '{"source":"seed"}', '2026-01-13 20:08:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (47, 31, 161, 'CAN Gateway', 'CAN', 'DEV-924KH', '{"source":"seed"}', '2026-01-13 19:40:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');
INSERT INTO `devices` (`id`, `tenant_id`, `asset_id`, `name`, `type`, `identifier`, `meta`, `last_seen_at`, `created_at`, `updated_at`) VALUES (48, 31, 147, 'CAN Gateway', 'CAN', 'DEV-354LM', '{"source":"seed"}', '2026-01-13 19:53:03', '2026-01-13 20:15:03', '2026-01-13 20:15:03');

-- Table: document_intake_batches
DROP TABLE IF EXISTS `document_intake_batches`;
CREATE TABLE `document_intake_batches` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `conversation_id` BIGINT,
    `user_id` BIGINT,
    `doc_type` TEXT,
    `status` VARCHAR(100) NOT NULL DEFAULT 'pending',
    `schema_version` TEXT,
    `summary` TEXT,
    `warnings` TEXT,
    `source_upload_ids` TEXT,
    `processed_at` DATETIME,
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (1, 31, 3, NULL, NULL, 'applied', 'v1', '{"rows":0,"errors":0,"warnings":0,"doc_type":null,"applied":0,"skipped":0}', '["AI OCR failed for WhatsApp Image 2026-01-05 at 10.17.00.jpeg"]', '[1]', '2026-01-14 18:48:22', '2026-01-14 18:48:22', '2026-01-14 18:48:34');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (2, 31, 4, NULL, NULL, 'review', 'v1', NULL, NULL, '[2]', NULL, '2026-01-18 15:09:27', '2026-01-18 15:09:27');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (3, 31, 5, NULL, 'purchase_request', 'applied', 'v1', '{"rows":45,"errors":0,"warnings":0,"doc_type":"purchase_request","applied":11,"skipped":0}', '[]', '[3]', '2026-01-18 15:11:32', '2026-01-18 15:11:31', '2026-01-18 15:11:48');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (4, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[4]', NULL, '2026-01-23 11:45:39', '2026-01-23 11:45:39');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (5, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[5]', NULL, '2026-01-23 11:49:05', '2026-01-23 11:49:05');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (6, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[6]', NULL, '2026-01-23 11:49:10', '2026-01-23 11:49:10');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (7, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[7]', NULL, '2026-01-23 11:49:16', '2026-01-23 11:49:16');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (8, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[8]', NULL, '2026-01-23 11:49:23', '2026-01-23 11:49:23');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (9, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[9]', NULL, '2026-01-23 11:49:34', '2026-01-23 11:49:34');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (10, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[10]', NULL, '2026-01-23 11:49:54', '2026-01-23 11:49:54');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (11, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[11]', NULL, '2026-01-23 11:50:34', '2026-01-23 11:50:34');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (12, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[12]', NULL, '2026-01-23 11:51:42', '2026-01-23 11:51:42');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (13, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[13]', NULL, '2026-01-23 17:20:56', '2026-01-23 17:20:56');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (14, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[14]', NULL, '2026-01-23 17:55:04', '2026-01-23 17:55:04');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (15, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[15]', NULL, '2026-01-23 17:55:11', '2026-01-23 17:55:11');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (16, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[16]', NULL, '2026-01-23 17:55:17', '2026-01-23 17:55:17');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (17, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[17]', NULL, '2026-01-23 17:55:24', '2026-01-23 17:55:24');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (18, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[18]', NULL, '2026-01-23 17:55:35', '2026-01-23 17:55:35');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (19, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[19]', NULL, '2026-01-23 17:55:54', '2026-01-23 17:55:54');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (20, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[20]', NULL, '2026-01-23 17:57:51', '2026-01-23 17:57:51');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (21, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[21]', NULL, '2026-01-23 17:59:04', '2026-01-23 17:59:04');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (22, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[22]', NULL, '2026-01-23 18:01:00', '2026-01-23 18:01:00');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (23, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[23]', NULL, '2026-01-23 18:02:30', '2026-01-23 18:02:30');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (24, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[24]', NULL, '2026-01-23 18:04:00', '2026-01-23 18:04:00');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (25, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[25]', NULL, '2026-01-23 18:06:11', '2026-01-23 18:06:11');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (26, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[26]', NULL, '2026-01-23 18:07:48', '2026-01-23 18:07:48');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (27, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[27]', NULL, '2026-01-23 18:09:03', '2026-01-23 18:09:03');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (28, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[28]', NULL, '2026-01-23 18:10:46', '2026-01-23 18:10:46');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (29, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[29]', NULL, '2026-01-23 18:12:02', '2026-01-23 18:12:02');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (30, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[30]', NULL, '2026-01-23 18:14:02', '2026-01-23 18:14:02');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (31, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[31]', NULL, '2026-01-23 18:15:31', '2026-01-23 18:15:31');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (32, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[32]', NULL, '2026-01-23 18:17:33', '2026-01-23 18:17:33');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (33, 31, 6, 1, NULL, 'review', 'v1', NULL, NULL, '[33]', NULL, '2026-01-23 18:19:27', '2026-01-23 18:19:27');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (34, 31, 6, 1, NULL, 'applied', 'v1', '{"rows":0,"errors":0,"warnings":0,"doc_type":null,"applied":0,"skipped":0}', '["AI OCR failed for photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg"]', '[34]', '2026-01-23 18:21:18', '2026-01-23 18:21:12', '2026-01-23 18:22:18');
INSERT INTO `document_intake_batches` (`id`, `tenant_id`, `conversation_id`, `user_id`, `doc_type`, `status`, `schema_version`, `summary`, `warnings`, `source_upload_ids`, `processed_at`, `created_at`, `updated_at`) VALUES (35, 31, 10, NULL, NULL, 'review', 'v1', '{"rows":0,"errors":0,"warnings":0,"doc_type":null}', '["Unsupported file type: txt"]', '[35]', '2026-01-25 16:02:30', '2026-01-25 16:02:30', '2026-01-25 16:02:30');

-- Table: document_intake_rows
DROP TABLE IF EXISTS `document_intake_rows`;
CREATE TABLE `document_intake_rows` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `batch_id` BIGINT NOT NULL,
    `row_index` BIGINT,
    `data` TEXT,
    `errors` TEXT,
    `warnings` TEXT,
    `matches` TEXT,
    `status` VARCHAR(100) NOT NULL DEFAULT 'pending',
    `created_at` DATETIME,
    `updated_at` DATETIME,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (1, 31, 3, 1, '{"item_ordered":"ROLLER IDLERS (BIG)","quantity":"","purpose_cost_centre":"CONVEYOR BELTS","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:31', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (2, 31, 3, 2, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (3, 31, 3, 3, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (4, 31, 3, 4, '{"item_ordered":"CONE OIL FILTERS","quantity":"2","purpose_cost_centre":"CONE OIL TANK","date_initiated":"46001","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:31', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (5, 31, 3, 5, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (6, 31, 3, 6, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:31', '2026-01-18 15:11:31');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (7, 31, 3, 7, '{"item_ordered":"ROLLER IDLERS (SMALL)","quantity":"","purpose_cost_centre":"CONVEYOR BELTS","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (8, 31, 3, 8, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (9, 31, 3, 9, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (10, 31, 3, 10, '{"item_ordered":"FIRE EXTINGUISHER 9KG","quantity":"8","purpose_cost_centre":"PLANT","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"496","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (11, 31, 3, 11, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (12, 31, 3, 12, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (13, 31, 3, 13, '{"item_ordered":"20MM STEEL PLATE","quantity":"1","purpose_cost_centre":"PLANT","date_initiated":"20\/12\/25","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (14, 31, 3, 14, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (15, 31, 3, 15, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (16, 31, 3, 16, '{"item_ordered":"CONE PRESSURE GUAGE & REGULATOR","quantity":"1","purpose_cost_centre":"CONE OIL TANK","date_initiated":"46001","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (17, 31, 3, 17, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (18, 31, 3, 18, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (19, 31, 3, 19, '{"item_ordered":"CONVEYOR GEARBOX","quantity":"1","purpose_cost_centre":"SCREEN 3","date_initiated":"46011","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (20, 31, 3, 20, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (21, 31, 3, 21, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (22, 31, 3, 22, '{"item_ordered":"TYRE PRESSURE GUAGE & PIPE","quantity":"1","purpose_cost_centre":"PLANT","date_initiated":"45689","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (23, 31, 3, 23, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (24, 31, 3, 24, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (25, 31, 3, 25, '{"item_ordered":"BELT FASTENERS","quantity":"30","purpose_cost_centre":"CONVEYOR BELTS","date_initiated":"45689","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (26, 31, 3, 26, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (27, 31, 3, 27, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (28, 31, 3, 28, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (29, 31, 3, 29, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (30, 31, 3, 30, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (31, 31, 3, 31, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (32, 31, 3, 32, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (33, 31, 3, 33, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (34, 31, 3, 34, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (35, 31, 3, 35, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (36, 31, 3, 36, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (37, 31, 3, 37, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"1","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (38, 31, 3, 38, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"2","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (39, 31, 3, 39, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"3","quote_number":"","quote_amount_usd":"","selected_supplier":"","quote_amount_zwl":"","comments":""}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (40, 31, 3, 40, '{"item_ordered":null,"quantity":null,"purpose_cost_centre":null,"date_initiated":null,"suppliers":null,"quote_number":"","quote_amount_usd":"","selected_supplier":"SUMMARY","quote_amount_zwl":"","comments":null}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (41, 31, 3, 41, '{"item_ordered":null,"quantity":null,"purpose_cost_centre":null,"date_initiated":null,"suppliers":null,"quote_number":null,"quote_amount_usd":"","selected_supplier":"USD","quote_amount_zwl":"ZWL","comments":null}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (42, 31, 3, 42, '{"item_ordered":null,"quantity":null,"purpose_cost_centre":null,"date_initiated":null,"suppliers":null,"quote_number":"","quote_amount_usd":"","selected_supplier":"0","quote_amount_zwl":"#REF!","comments":null}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (43, 31, 3, 43, '{"item_ordered":"Prepared By:","quantity":"Stores & Procurement: \u2026........................................","purpose_cost_centre":"","date_initiated":"","suppliers":"","quote_number":null,"quote_amount_usd":null,"selected_supplier":null,"quote_amount_zwl":"","comments":null}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (44, 31, 3, 44, '{"item_ordered":"","quantity":"","purpose_cost_centre":"","date_initiated":"","suppliers":"","quote_number":null,"quote_amount_usd":"0","selected_supplier":null,"quote_amount_zwl":"","comments":null}', '["Missing item_ordered"]', '[]', '[]', 'error', '2026-01-18 15:11:32', '2026-01-18 15:11:32');
INSERT INTO `document_intake_rows` (`id`, `tenant_id`, `batch_id`, `row_index`, `data`, `errors`, `warnings`, `matches`, `status`, `created_at`, `updated_at`) VALUES (45, 31, 3, 45, '{"item_ordered":"Authorised By:","quantity":"Mine Manager: \u2026........................................","purpose_cost_centre":"","date_initiated":"","suppliers":"","quote_number":null,"quote_amount_usd":null,"selected_supplier":null,"quote_amount_zwl":null,"comments":null}', '[]', '[]', '[]', 'applied', '2026-01-18 15:11:32', '2026-01-18 15:11:48');

-- Table: document_intakes
DROP TABLE IF EXISTS `document_intakes`;
CREATE TABLE `document_intakes` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `tenant_id` BIGINT NOT NULL,
    `status` TEXT NOT NULL,
    `source_channel` TEXT NOT NULL,
    `uploaded_by` BIGINT,
    `original_filename` TEXT NOT NULL,
    `stored_path` TEXT NOT NULL,
    `mime_type` TEXT,
    `meta_json` TEXT,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;


INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (1, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100546_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:05:48');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (2, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100552_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:05:52');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (3, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100558_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:05:58');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (4, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100606_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:06:07');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (5, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100626_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:06:26');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (6, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100647_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:06:47');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (7, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100723_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:07:23');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (8, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_100832_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:08:32');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (9, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_101005_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:10:05');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (10, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_101123_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:11:23');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (11, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_101325_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:13:25');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (12, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_101515_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:15:15');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (13, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_101913_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:19:13');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (14, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_102019_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:20:19');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (15, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_102219_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:22:19');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (16, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_102409_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:24:09');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (17, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_102555_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:25:55');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (18, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_102753_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:27:53');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (19, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_102901_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:29:01');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (20, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_103012_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:30:12');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (21, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_103204_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:32:04');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (22, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_103348_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:33:48');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (23, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_103545_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:35:45');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (24, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_103723_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:37:23');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (25, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_103845_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:38:45');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (26, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_104031_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:40:31');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (27, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_104210_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:42:10');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (28, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_104356_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:43:56');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (29, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_104553_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:45:53');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (30, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_104731_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:47:31');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (31, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_104912_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:49:12');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (32, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_105102_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:51:02');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (33, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_105211_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:52:11');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (34, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_105331_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:53:31');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (35, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_105520_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:55:21');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (36, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_105655_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:56:55');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (37, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_105858_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 10:58:58');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (38, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110009_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:00:09');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (39, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110210_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:02:10');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (40, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110359_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:03:59');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (41, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110508_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:05:09');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (42, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110631_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:06:32');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (43, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110820_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:08:20');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (44, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_110944_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:09:44');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (45, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_111141_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:11:41');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (46, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_111307_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:13:07');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (47, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_111454_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:14:54');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (48, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_111618_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:16:18');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (49, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_111737_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:17:37');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (50, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_111934_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:19:34');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (51, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_112052_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:20:52');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (52, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_112255_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:22:55');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (53, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_112452_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:24:52');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (54, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_112616_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:26:16');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (55, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_112804_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:28:04');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (56, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_112915_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:29:15');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (57, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_113105_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:31:05');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (58, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_113314_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:33:14');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (59, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_113425_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:34:25');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (60, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_113549_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:35:50');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (61, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_113753_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:37:53');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (62, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_113902_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:39:02');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (63, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114035_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:40:35');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (64, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114206_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:42:06');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (65, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114356_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:43:56');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (66, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114539_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:45:39');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (67, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114904_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:49:04');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (68, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114910_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:49:10');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (69, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114915_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:49:16');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (70, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114923_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:49:23');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (71, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114934_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:49:34');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (72, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_114953_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:49:54');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (73, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_115034_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:50:34');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (74, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_115142_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 11:51:42');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (75, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_172056_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:20:56');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (76, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175503_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:55:04');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (77, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175511_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:55:11');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (78, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175517_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:55:17');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (79, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175524_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:55:24');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (80, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175535_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:55:35');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (81, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175554_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:55:54');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (82, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175751_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}', '2026-01-23 17:57:51');
INSERT INTO `document_intakes` (`id`, `tenant_id`, `status`, `source_channel`, `uploaded_by`, `original_filename`, `stored_path`, `mime_type`, `meta_json`, `created_at`) VALUES (83, 31, 'review', 'telegram', 1, 'photo_AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ.jpg', 'tenants/31/uploads/telegram/20260123_175904_photo-agacagqaaxkbaaibnwlzr-cnfja5yeqfmdbughpzp0vfaakac2sbhesyu4bgvpkmqgfpaqadagadeqadoaq.jpg', 'image/jpeg', '{"telegram_file_id":"AgACAgQAAxkBAAIBNWlzR_cnfJa5yEqFMDbughpZp0vFAAKaC2sbheSYU4bgvpkmqgFpAQADAgADeQADOAQ","telegram_chat_id":"6161130318","telegram_user_id":"6161130318"}',